/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.OutputBase;
import org.apache.jena.sparql.util.NodeToLabelMap;
import org.apache.jena.util.FileUtils;

public class CSVOutput
extends OutputBase {
    static String NL = "\r\n";
    static final byte[] headerBytes = StrUtils.asUTF8bytes("_askResult" + NL);
    static final byte[] yesBytes = StrUtils.asUTF8bytes("true");
    static final byte[] noBytes = StrUtils.asUTF8bytes("false");
    static final byte[] NLBytes = StrUtils.asUTF8bytes(NL);

    @Override
    public void format(OutputStream out, ResultSet resultSet) {
        try {
            Writer w = FileUtils.asUTF8(out);
            NodeToLabelMap bnodes = new NodeToLabelMap();
            w = new BufferedWriter(w);
            String sep = null;
            List<String> varNames = resultSet.getResultVars();
            ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
            for (String v : varNames) {
                if (sep != null) {
                    w.write(sep);
                } else {
                    sep = ",";
                }
                w.write(this.csvSafe(v));
                vars.add(Var.alloc(v));
            }
            w.write(NL);
            while (resultSet.hasNext()) {
                sep = null;
                Binding b = resultSet.nextBinding();
                for (Var v : vars) {
                    if (sep != null) {
                        w.write(sep);
                    }
                    sep = ",";
                    Node n = b.get(v);
                    if (n == null) continue;
                    this.output(w, n, bnodes);
                }
                w.write(NL);
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }

    protected void output(Writer w, Node n, NodeToLabelMap bnodes) throws IOException {
        String str2 = "?";
        if (n.isLiteral()) {
            str2 = n.getLiteralLexicalForm();
        } else if (n.isURI()) {
            str2 = n.getURI();
        } else if (n.isBlank()) {
            str2 = bnodes.asString(n);
        }
        str2 = this.csvSafe(str2);
        w.write(str2);
    }

    protected String csvSafe(String str2) {
        if (str2.contains("\"") || str2.contains(",") || str2.contains("\r") || str2.contains("\n")) {
            str2 = "\"" + str2.replaceAll("\"", "\"\"") + "\"";
        } else if (str2.isEmpty()) {
            str2 = "\"\"";
        }
        return str2;
    }

    @Override
    public void format(OutputStream out, boolean booleanResult) {
        try {
            out.write(headerBytes);
            if (booleanResult) {
                out.write(yesBytes);
            } else {
                out.write(noBytes);
            }
            out.write(NLBytes);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }
}

