/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;

public class PrefixMapStd
extends PrefixMapBase {
    final Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private final Map<String, IRI> prefixes2 = Collections.unmodifiableMap(this.prefixes);
    final Map<String, String> uriToPrefix = new HashMap<String, String>();

    public PrefixMapStd() {
    }

    public PrefixMapStd(PrefixMap prefixMap) {
        this.prefixes.putAll(prefixMap.getMapping());
    }

    @Override
    public Map<String, IRI> getMapping() {
        return this.prefixes2;
    }

    @Override
    public void add(String prefix, String iriString) {
        prefix = this.canonicalPrefix(prefix);
        IRI iri = IRIResolver.iriFactory().create(iriString);
        this.prefixes.put(prefix, iri);
        this.uriToPrefix.put(iriString, prefix);
    }

    @Override
    public void add(String prefix, IRI iri) {
        prefix = this.canonicalPrefix(prefix);
        this.prefixes.put(prefix, iri);
        this.uriToPrefix.put(iri.toString(), prefix);
    }

    @Override
    public void delete(String prefix) {
        prefix = this.canonicalPrefix(prefix);
        this.prefixes.remove(prefix);
        this.uriToPrefix.values().remove(prefix);
    }

    @Override
    public void clear() {
        this.prefixes.clear();
    }

    @Override
    public boolean contains(String prefix) {
        prefix = this.canonicalPrefix(prefix);
        return this.prefixes.containsKey(prefix);
    }

    @Override
    public String abbreviate(String uriStr) {
        Pair<String, String> p = this.abbrev(uriStr);
        if (p == null) {
            return null;
        }
        return p.getLeft() + ":" + p.getRight();
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        String ln2;
        String candidate = PrefixMapStd.getPossibleKey(uriStr);
        String uriForPrefix = this.uriToPrefix.get(candidate);
        if (uriForPrefix != null && this.isSafeLocalPart(ln2 = uriStr.substring(candidate.length()))) {
            return Pair.create(uriForPrefix, ln2);
        }
        return this.abbrev(this.prefixes, uriStr, true);
    }

    protected static String getPossibleKey(String iriString) {
        int index = iriString.lastIndexOf(35);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        index = iriString.lastIndexOf(47);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        return null;
    }

    @Override
    public String expand(String prefix, String localName) {
        IRI x = this.prefixes.get(prefix = this.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x.toString() + localName;
    }

    @Override
    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    @Override
    public int size() {
        return this.prefixes.size();
    }
}

