/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DefaultDistributedCollectionService;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.multiset.DistributedMultisetType;
import io.atomix.core.multiset.impl.DistributedMultisetService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultDistributedMultisetService
extends DefaultDistributedCollectionService<Multiset<String>, String>
implements DistributedMultisetService {
    private static final int MAX_ITERATOR_BATCH_SIZE = 32768;
    private final Serializer serializer;
    protected Map<Long, IteratorContext> entryIterators = Maps.newHashMap();

    public DefaultDistributedMultisetService() {
        super(DistributedMultisetType.instance(), HashMultiset.create());
        this.serializer = Serializer.using((Namespace)Namespace.builder().register(DistributedMultisetType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{DefaultDistributedCollectionService.IteratorContext.class}).register(new Class[]{IteratorContext.class}).build());
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    private Multiset<String> multiset() {
        return (Multiset)this.collection();
    }

    @Override
    public void backup(BackupOutput output) {
        super.backup(output);
        output.writeObject(this.entryIterators);
    }

    @Override
    public void restore(BackupInput input) {
        super.restore(input);
        this.entryIterators = (Map)input.readObject();
    }

    @Override
    public int count(Object element) {
        return this.multiset().count(element);
    }

    @Override
    public CollectionUpdateResult<Integer> add(String element, int occurrences) {
        int count = this.multiset().add((Object)element, occurrences);
        for (int i = 0; i < occurrences; ++i) {
            this.added(element);
        }
        return CollectionUpdateResult.ok(count);
    }

    @Override
    public CollectionUpdateResult<Integer> remove(Object element, int occurrences) {
        int count = this.multiset().remove(element, occurrences);
        for (int i = 0; i < Math.min(count, occurrences); ++i) {
            this.removed((String)element);
        }
        return CollectionUpdateResult.ok(count);
    }

    @Override
    public CollectionUpdateResult<Integer> setCount(String element, int count) {
        int previous;
        block3: {
            block2: {
                previous = this.multiset().setCount((Object)element, count);
                if (previous >= count) break block2;
                for (int i = previous; i < count; ++i) {
                    this.added(element);
                }
                break block3;
            }
            if (previous <= count) break block3;
            for (int i = count; i < previous; ++i) {
                this.removed(element);
            }
        }
        return CollectionUpdateResult.ok(previous);
    }

    @Override
    public CollectionUpdateResult<Boolean> setCount(String element, int oldCount, int newCount) {
        boolean succeeded;
        block2: {
            block3: {
                succeeded = this.multiset().setCount((Object)element, oldCount, newCount);
                if (!succeeded) break block2;
                if (oldCount >= newCount) break block3;
                for (int i = oldCount; i < newCount; ++i) {
                    this.added(element);
                }
                break block2;
            }
            if (oldCount <= newCount) break block2;
            for (int i = newCount; i < oldCount; ++i) {
                this.removed(element);
            }
        }
        return CollectionUpdateResult.ok(succeeded);
    }

    @Override
    public int elements() {
        return this.multiset().elementSet().size();
    }

    @Override
    public long iterateElements() {
        return this.iterateEntries();
    }

    @Override
    public IteratorBatch<String> nextElements(long iteratorId, int position) {
        IteratorBatch<Multiset.Entry<String>> batch = this.nextEntries(iteratorId, position);
        return batch == null ? null : new IteratorBatch(batch.position(), batch.entries().stream().map(element -> (String)element.getElement()).collect(Collectors.toList()));
    }

    @Override
    public void closeElements(long iteratorId) {
        this.closeEntries(iteratorId);
    }

    @Override
    public long iterateEntries() {
        this.entryIterators.put(this.getCurrentIndex(), new IteratorContext((Long)this.getCurrentSession().sessionId().id()));
        return this.getCurrentIndex();
    }

    @Override
    public IteratorBatch<Multiset.Entry<String>> nextEntries(long iteratorId, int position) {
        IteratorContext context = this.entryIterators.get(iteratorId);
        if (context == null) {
            return null;
        }
        ArrayList<Multiset.Entry> entries = new ArrayList<Multiset.Entry>();
        int size = 0;
        while (context.iterator.hasNext()) {
            context.position++;
            if (context.position <= position) continue;
            Multiset.Entry entry = (Multiset.Entry)context.iterator.next();
            entries.add(Multisets.immutableEntry((Object)entry.getElement(), (int)entry.getCount()));
            if ((size += ((String)entry.getElement()).length() + 4) < 32768) continue;
            break;
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new IteratorBatch<Multiset.Entry<String>>(context.position, entries);
    }

    @Override
    public void closeEntries(long iteratorId) {
        this.entryIterators.remove(iteratorId);
    }

    static /* synthetic */ Multiset access$200(DefaultDistributedMultisetService x0) {
        return x0.multiset();
    }

    private class IteratorContext {
        private final long sessionId;
        private int position = 0;
        private transient Iterator<Multiset.Entry<String>> iterator = DefaultDistributedMultisetService.access$200(DefaultDistributedMultisetService.this).entrySet().iterator();

        IteratorContext(long sessionId) {
            this.sessionId = sessionId;
        }
    }
}

