/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zeppelin.interpreter.YarnAppMonitor;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterManagedProcess;
import org.apache.zeppelin.interpreter.util.ProcessLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecRemoteInterpreterProcess
extends RemoteInterpreterManagedProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecRemoteInterpreterProcess.class);
    private static final Pattern YARN_APP_PATTER = Pattern.compile("Submitted application (\\w+)");
    private final String interpreterRunner;
    private InterpreterProcessLauncher interpreterProcessLauncher;

    public ExecRemoteInterpreterProcess(int intpEventServerPort, String intpEventServerHost, String interpreterPortRange, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, int connectionPoolSize, String interpreterSettingName, String interpreterGroupId, boolean isUserImpersonated, String intpRunner) {
        super(intpEventServerPort, intpEventServerHost, interpreterPortRange, intpDir, localRepoDir, env, connectTimeout, connectionPoolSize, interpreterSettingName, interpreterGroupId, isUserImpersonated);
        this.interpreterRunner = intpRunner;
    }

    public void start(String userName) throws IOException {
        String launchOutput;
        Matcher m;
        CommandLine cmdLine = CommandLine.parse((String)this.interpreterRunner);
        cmdLine.addArgument("-d", false);
        cmdLine.addArgument(this.getInterpreterDir(), false);
        cmdLine.addArgument("-c", false);
        cmdLine.addArgument(this.getIntpEventServerHost(), false);
        cmdLine.addArgument("-p", false);
        cmdLine.addArgument(String.valueOf(this.intpEventServerPort), false);
        cmdLine.addArgument("-r", false);
        cmdLine.addArgument(this.getInterpreterPortRange(), false);
        cmdLine.addArgument("-i", false);
        cmdLine.addArgument(this.getInterpreterGroupId(), false);
        if (this.isUserImpersonated() && !userName.equals("anonymous")) {
            cmdLine.addArgument("-u", false);
            cmdLine.addArgument(userName, false);
        }
        cmdLine.addArgument("-l", false);
        cmdLine.addArgument(this.getLocalRepoDir(), false);
        cmdLine.addArgument("-g", false);
        cmdLine.addArgument(this.getInterpreterSettingName(), false);
        this.interpreterProcessLauncher = new InterpreterProcessLauncher(cmdLine, this.getEnv());
        this.interpreterProcessLauncher.launch();
        this.interpreterProcessLauncher.waitForReady(this.getConnectTimeout());
        if (this.interpreterProcessLauncher.isLaunchTimeout()) {
            throw new IOException(String.format("Interpreter Process creation is time out in %d seconds", this.getConnectTimeout() / 1000) + "\nYou can increase timeout threshold via setting zeppelin.interpreter.connect.timeout of this interpreter.\n" + this.interpreterProcessLauncher.getErrorMessage());
        }
        if (!this.interpreterProcessLauncher.isRunning()) {
            throw new IOException("Fail to launch interpreter process:\n" + this.interpreterProcessLauncher.getErrorMessage());
        }
        if (this.isHadoopClientAvailable() && (m = YARN_APP_PATTER.matcher(launchOutput = this.interpreterProcessLauncher.getProcessLaunchOutput())).find()) {
            String appId = m.group(1);
            LOGGER.info("Detected yarn app: {}, add it to YarnAppMonitor", (Object)appId);
            YarnAppMonitor.get().addYarnApp(ConverterUtils.toApplicationId((String)appId), this);
        }
    }

    private boolean isHadoopClientAvailable() {
        try {
            Class.forName("org.apache.hadoop.yarn.conf.YarnConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void processStarted(int port, String host) {
        super.processStarted(port, host);
        this.interpreterProcessLauncher.onProcessRunning();
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            super.stop();
            this.interpreterProcessLauncher.waitForShutdown(2500);
            this.interpreterProcessLauncher.stop();
            this.interpreterProcessLauncher = null;
            LOGGER.info("Remote exec process of interpreter group: {} is terminated", (Object)this.getInterpreterGroupId());
        } else {
            super.close();
            LOGGER.warn("Try to stop a not running interpreter process of interpreter group: {}", (Object)this.getInterpreterGroupId());
        }
    }

    @VisibleForTesting
    public String getInterpreterRunner() {
        return this.interpreterRunner;
    }

    public boolean isAlive() {
        return this.interpreterProcessLauncher != null && this.interpreterProcessLauncher.isAlive();
    }

    public boolean isRunning() {
        return this.interpreterProcessLauncher != null && this.interpreterProcessLauncher.isRunning();
    }

    @Override
    public String getErrorMessage() {
        return this.interpreterProcessLauncher != null ? this.interpreterProcessLauncher.getErrorMessage() : "";
    }

    private class InterpreterProcessLauncher
    extends ProcessLauncher {
        public InterpreterProcessLauncher(CommandLine commandLine, Map<String, String> envs) {
            super(commandLine, envs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForShutdown(int timeout) {
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                long startTime = System.currentTimeMillis();
                long timeoutTime = startTime + (long)timeout;
                while (this.state == ProcessLauncher.State.RUNNING && !Thread.currentThread().isInterrupted()) {
                    long timetoTimeout = timeoutTime - System.currentTimeMillis();
                    if (timetoTimeout <= 0L) {
                        LOGGER.warn("Shutdown timeout reached");
                        break;
                    }
                    try {
                        ((Object)((Object)this)).wait(timetoTimeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.error("waitForShutdown interrupted", (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForReady(int timeout) {
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                long startTime = System.currentTimeMillis();
                long timeoutTime = startTime + (long)timeout;
                while (this.state != ProcessLauncher.State.RUNNING && this.state != ProcessLauncher.State.TERMINATED && !Thread.currentThread().isInterrupted()) {
                    long timetoTimeout = timeoutTime - System.currentTimeMillis();
                    if (timetoTimeout <= 0L) {
                        LOGGER.warn("Ready timeout reached");
                        break;
                    }
                    try {
                        ((Object)((Object)this)).wait(timetoTimeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("waitForReady interrupted", (Throwable)e);
                    }
                }
            }
            this.stopCatchLaunchOutput();
            if (this.state == ProcessLauncher.State.LAUNCHED) {
                this.onTimeout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessRunning() {
            super.onProcessRunning();
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessComplete(int exitValue) {
            LOGGER.warn("Process is exited with exit value {}", (Object)exitValue);
            if (this.isSparkYarnClusterMode()) {
                InterpreterProcessLauncher interpreterProcessLauncher = this;
                synchronized (interpreterProcessLauncher) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
            if (this.isFlinkApplicationMode() && exitValue == 0) {
                InterpreterProcessLauncher interpreterProcessLauncher = this;
                synchronized (interpreterProcessLauncher) {
                    ((Object)((Object)this)).notifyAll();
                }
                return;
            }
            if (exitValue != 0) {
                this.transition(ProcessLauncher.State.TERMINATED);
            } else {
                this.transition(ProcessLauncher.State.COMPLETED);
            }
        }

        private boolean isSparkYarnClusterMode() {
            return Boolean.parseBoolean(ExecRemoteInterpreterProcess.this.getEnv().getOrDefault("ZEPPELIN_SPARK_YARN_CLUSTER", "false"));
        }

        private boolean isFlinkApplicationMode() {
            return ExecRemoteInterpreterProcess.this.getEnv().containsKey("ZEPPELIN_FLINK_APPLICATION_MODE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

