/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.retrypolicies;

import com.microsoft.azure.datalake.store.retrypolicies.RetryPolicy;

public class ExponentialBackoffPolicy
implements RetryPolicy {
    private int retryCount = 0;
    private int maxRetries = 4;
    private int exponentialRetryInterval = 1000;
    private int exponentialFactor = 4;

    public ExponentialBackoffPolicy() {
    }

    public ExponentialBackoffPolicy(int maxRetries, int linearRetryInterval, int exponentialRetryInterval) {
        this.maxRetries = maxRetries;
        this.exponentialRetryInterval = exponentialRetryInterval;
    }

    @Override
    public boolean shouldRetry(int httpResponseCode, Exception lastException) {
        if (httpResponseCode >= 300 && httpResponseCode < 500 && httpResponseCode != 408 && httpResponseCode != 429 && httpResponseCode != 401 || httpResponseCode == 501 || httpResponseCode == 505) {
            return false;
        }
        if (lastException != null || httpResponseCode >= 500 || httpResponseCode == 408 || httpResponseCode == 429 || httpResponseCode == 401) {
            if (this.retryCount < this.maxRetries) {
                this.wait(this.exponentialRetryInterval);
                this.exponentialRetryInterval *= this.exponentialFactor;
                ++this.retryCount;
                return true;
            }
            return false;
        }
        if (httpResponseCode >= 100 && httpResponseCode < 300) {
            return false;
        }
        return false;
    }

    private void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

