/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionClient;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.protocols.backup.PrimaryBackupClient;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupClientCommunicator;
import io.atomix.protocols.backup.serializer.impl.PrimaryBackupNamespaces;
import io.atomix.protocols.backup.session.PrimaryBackupSessionClient;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionClient
implements PartitionClient,
Managed<PrimaryBackupPartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PrimaryBackupPartition partition;
    private final PartitionManagementService managementService;
    private final ThreadContextFactory threadFactory;
    private volatile PrimaryBackupClient client;

    public PrimaryBackupPartitionClient(PrimaryBackupPartition partition, PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.threadFactory = threadFactory;
    }

    public PrimaryBackupSessionClient.Builder sessionBuilder(String primitiveName, PrimitiveType primitiveType, ServiceConfig serviceConfig) {
        return this.client.sessionBuilder(primitiveName, primitiveType, serviceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PrimaryBackupPartitionClient> start() {
        PrimaryBackupPartitionClient primaryBackupPartitionClient = this;
        synchronized (primaryBackupPartitionClient) {
            this.client = this.newClient();
            this.log.debug("Successfully started client for {}", (Object)this.partition.id());
        }
        return CompletableFuture.completedFuture(this);
    }

    private PrimaryBackupClient newClient() {
        return PrimaryBackupClient.builder().withClientName(this.partition.name()).withPartitionId(this.partition.id()).withMembershipService(this.managementService.getMembershipService()).withProtocol(new PrimaryBackupClientCommunicator(this.partition.name(), Serializer.using((Namespace)PrimaryBackupNamespaces.PROTOCOL), this.managementService.getMessagingService())).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withSessionIdProvider(this.managementService.getSessionIdService()).withThreadContextFactory(this.threadFactory).build();
    }

    public boolean isRunning() {
        return this.client != null;
    }

    public CompletableFuture<Void> stop() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }
}

