/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import java.util.Set;

public class BaseTypeSignature
extends TypeSignature {
    private final String baseType;

    public BaseTypeSignature(String baseType) {
        this.baseType = baseType;
    }

    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
    }

    @Override
    public Class<?> instantiate(ScanResult scanResult) {
        switch (this.baseType) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        throw new RuntimeException("Unknown base type " + this.baseType);
    }

    public int hashCode() {
        return this.baseType.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BaseTypeSignature && ((BaseTypeSignature)obj).baseType.equals(this.baseType);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (!(other instanceof BaseTypeSignature)) {
            return false;
        }
        return this.baseType.equals(((BaseTypeSignature)other).baseType);
    }

    public String toString() {
        return this.baseType;
    }

    static BaseTypeSignature parse(TypeUtils.ParseState parseState) {
        switch (parseState.peek()) {
            case 'B': {
                parseState.next();
                return new BaseTypeSignature("byte");
            }
            case 'C': {
                parseState.next();
                return new BaseTypeSignature("char");
            }
            case 'D': {
                parseState.next();
                return new BaseTypeSignature("double");
            }
            case 'F': {
                parseState.next();
                return new BaseTypeSignature("float");
            }
            case 'I': {
                parseState.next();
                return new BaseTypeSignature("int");
            }
            case 'J': {
                parseState.next();
                return new BaseTypeSignature("long");
            }
            case 'S': {
                parseState.next();
                return new BaseTypeSignature("short");
            }
            case 'Z': {
                parseState.next();
                return new BaseTypeSignature("boolean");
            }
            case 'V': {
                parseState.next();
                return new BaseTypeSignature("void");
            }
        }
        return null;
    }
}

