/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.influxdb;

import com.influxdb.LogLevel;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.QueryApi;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDBInterpreter.class);
    private static final String INFLUXDB_API_URL_PROPERTY = "influxdb.url";
    private static final String INFLUXDB_TOKEN_PROPERTY = "influxdb.token";
    private static final String INFLUXDB_ORG_PROPERTY = "influxdb.org";
    private static final String INFLUXDB_LOGLEVEL_PROPERTY = "influxdb.logLevel";
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String WHITESPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final String EMPTY_COLUMN_VALUE = "";
    private volatile InfluxDBClient client;
    private volatile QueryApi queryApi;

    public InfluxDBInterpreter(Properties properties) {
        super(properties);
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    protected InterpreterResult internalInterpret(String query, InterpreterContext context) throws InterpreterException {
        LOGGER.debug("Run Flux command '{}'", (Object)query);
        query = query.trim();
        QueryApi queryService = this.getInfluxDBClient(context);
        int[] actualIndex = new int[]{-1};
        AtomicReference resultRef = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        StringBuilder result = new StringBuilder();
        queryService.query(query, (cancellable, fluxRecord) -> {
            Integer tableIndex = fluxRecord.getTable();
            if (actualIndex[0] != tableIndex) {
                result.append(NEWLINE);
                result.append(TABLE_MAGIC_TAG);
                actualIndex[0] = tableIndex;
                StringJoiner joiner = new StringJoiner(TAB);
                fluxRecord.getValues().keySet().forEach(c -> joiner.add(this.replaceReservedChars((String)c)));
                result.append(joiner.toString());
                result.append(NEWLINE);
            }
            StringJoiner rowsJoiner = new StringJoiner(TAB);
            for (Object value : fluxRecord.getValues().values()) {
                if (value == null) {
                    value = EMPTY_COLUMN_VALUE;
                }
                rowsJoiner.add(this.replaceReservedChars(value.toString()));
            }
            result.append(rowsJoiner.toString());
            result.append(NEWLINE);
        }, throwable -> {
            LOGGER.error(throwable.getMessage(), (Throwable)throwable);
            resultRef.set(new InterpreterResult(InterpreterResult.Code.ERROR, throwable.getMessage()));
            countDownLatch.countDown();
        }, () -> {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
            intpResult.add(result.toString());
            resultRef.set(intpResult);
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new InterpreterException((Throwable)e);
        }
        return (InterpreterResult)resultRef.get();
    }

    private QueryApi getInfluxDBClient(InterpreterContext context) {
        if (this.queryApi == null) {
            this.queryApi = this.client.getQueryApi();
        }
        return this.queryApi;
    }

    public void open() throws InterpreterException {
        if (this.client == null) {
            InfluxDBClientOptions opt = InfluxDBClientOptions.builder().url(this.getProperty(INFLUXDB_API_URL_PROPERTY)).authenticateToken(this.getProperty(INFLUXDB_TOKEN_PROPERTY).toCharArray()).logLevel(LogLevel.valueOf(this.getProperty(INFLUXDB_LOGLEVEL_PROPERTY, LogLevel.NONE.toString()))).org(this.getProperty(INFLUXDB_ORG_PROPERTY)).build();
            this.client = InfluxDBClientFactory.create(opt);
        }
    }

    public void close() throws InterpreterException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    private String replaceReservedChars(String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return str.replace(TAB, WHITESPACE).replace(NEWLINE, WHITESPACE);
    }
}

