/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.serialdiff;

import com.google.common.collect.EvictingQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class SerialDiffPipelineAggregator
extends PipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("serial_diff");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public SerialDiffPipelineAggregator readResult(StreamInput in) throws IOException {
            SerialDiffPipelineAggregator result = new SerialDiffPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private ValueFormatter formatter;
    private BucketHelpers.GapPolicy gapPolicy;
    private int lag;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    public SerialDiffPipelineAggregator() {
    }

    public SerialDiffPipelineAggregator(String name, String[] bucketsPaths, @Nullable ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, int lag, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.lag = lag;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalHistogram histo = (InternalHistogram)aggregation;
        List buckets = histo.getBuckets();
        InternalHistogram.Factory factory = histo.getFactory();
        ArrayList<InternalHistogram.Bucket> newBuckets = new ArrayList<InternalHistogram.Bucket>();
        EvictingQueue<Double> lagWindow = EvictingQueue.create(this.lag);
        int counter = 0;
        for (InternalHistogram.Bucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)bucket, this.bucketsPaths()[0], this.gapPolicy);
            InternalHistogram.Bucket newBucket = bucket;
            Double lagValue = ++counter <= this.lag ? Double.valueOf(Double.NaN) : (Double)lagWindow.peek();
            if (thisBucketValue == null) {
                thisBucketValue = Double.NaN;
            }
            if (!Double.isNaN(thisBucketValue) && !Double.isNaN(lagValue)) {
                double diff = thisBucketValue - lagValue;
                ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
                aggs.add(new InternalSimpleValue(this.name(), diff, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                newBucket = factory.createBucket(bucket.getKey(), bucket.getDocCount(), new InternalAggregations(aggs), bucket.getKeyed(), bucket.getFormatter());
            }
            newBuckets.add(newBucket);
            lagWindow.add(thisBucketValue);
        }
        return factory.create(newBuckets, histo);
    }

    @Override
    public void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.lag = in.readVInt();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.lag);
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private BucketHelpers.GapPolicy gapPolicy;
        private int lag;

        public Factory(String name, String[] bucketsPaths, @Nullable ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, int lag) {
            super(name, TYPE.name(), bucketsPaths);
            this.formatter = formatter;
            this.gapPolicy = gapPolicy;
            this.lag = lag;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new SerialDiffPipelineAggregator(this.name, this.bucketsPaths, this.formatter, this.gapPolicy, this.lag, metaData);
        }
    }
}

