/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import com.google.common.collect.Iterables;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreFormat;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.LegacyBlobStoreFormat;

public class BlobStoreIndexShardRepository
extends AbstractComponent
implements IndexShardRepository {
    private static final int BUFFER_SIZE = 4096;
    private BlobStore blobStore;
    private BlobPath basePath;
    private final String repositoryName;
    private ByteSizeValue chunkSize;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private RateLimiter snapshotRateLimiter;
    private RateLimiter restoreRateLimiter;
    private RateLimiterListener rateLimiterListener;
    private RateLimitingInputStream.Listener snapshotThrottleListener;
    private RateLimitingInputStream.Listener restoreThrottleListener;
    private boolean compress;
    private final ParseFieldMatcher parseFieldMatcher;
    protected static final String LEGACY_SNAPSHOT_PREFIX = "snapshot-";
    protected static final String LEGACY_SNAPSHOT_NAME_FORMAT = "snapshot-%s";
    protected static final String SNAPSHOT_PREFIX = "snap-";
    protected static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    protected static final String SNAPSHOT_CODEC = "snapshot";
    protected static final String SNAPSHOT_INDEX_PREFIX = "index-";
    protected static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    protected static final String SNAPSHOT_INDEX_CODEC = "snapshots";
    protected static final String DATA_BLOB_PREFIX = "__";
    private ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat;
    private LegacyBlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotLegacyFormat;
    private ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> indexShardSnapshotsFormat;

    @Inject
    public BlobStoreIndexShardRepository(Settings settings, RepositoryName repositoryName, IndicesService indicesService, ClusterService clusterService) {
        super(settings);
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.repositoryName = repositoryName.name();
        this.indicesService = indicesService;
        this.clusterService = clusterService;
    }

    public void initialize(BlobStore blobStore, BlobPath basePath, ByteSizeValue chunkSize, RateLimiter snapshotRateLimiter, RateLimiter restoreRateLimiter, final RateLimiterListener rateLimiterListener, boolean compress) {
        this.blobStore = blobStore;
        this.basePath = basePath;
        this.chunkSize = chunkSize;
        this.snapshotRateLimiter = snapshotRateLimiter;
        this.restoreRateLimiter = restoreRateLimiter;
        this.rateLimiterListener = rateLimiterListener;
        this.snapshotThrottleListener = new RateLimitingInputStream.Listener(){

            @Override
            public void onPause(long nanos) {
                rateLimiterListener.onSnapshotPause(nanos);
            }
        };
        this.restoreThrottleListener = new RateLimitingInputStream.Listener(){

            @Override
            public void onPause(long nanos) {
                rateLimiterListener.onRestorePause(nanos);
            }
        };
        this.compress = compress;
        this.indexShardSnapshotFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, BlobStoreIndexShardSnapshot.PROTO, this.parseFieldMatcher, this.isCompress());
        this.indexShardSnapshotLegacyFormat = new LegacyBlobStoreFormat<BlobStoreIndexShardSnapshot>(LEGACY_SNAPSHOT_NAME_FORMAT, BlobStoreIndexShardSnapshot.PROTO, this.parseFieldMatcher);
        this.indexShardSnapshotsFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>(SNAPSHOT_INDEX_CODEC, SNAPSHOT_INDEX_NAME_FORMAT, BlobStoreIndexShardSnapshots.PROTO, this.parseFieldMatcher, this.isCompress());
    }

    @Override
    public void snapshot(SnapshotId snapshotId, ShardId shardId, SnapshotIndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        SnapshotContext snapshotContext = new SnapshotContext(snapshotId, shardId, snapshotStatus);
        snapshotStatus.startTime(System.currentTimeMillis());
        try {
            snapshotContext.snapshot(snapshotIndexCommit);
            snapshotStatus.time(System.currentTimeMillis() - snapshotStatus.startTime());
            snapshotStatus.updateStage(IndexShardSnapshotStatus.Stage.DONE);
        }
        catch (Throwable e) {
            snapshotStatus.time(System.currentTimeMillis() - snapshotStatus.startTime());
            snapshotStatus.updateStage(IndexShardSnapshotStatus.Stage.FAILURE);
            snapshotStatus.failure(ExceptionsHelper.detailedMessage(e));
            if (e instanceof IndexShardSnapshotFailedException) {
                throw (IndexShardSnapshotFailedException)e;
            }
            throw new IndexShardSnapshotFailedException(shardId, e.getMessage(), e);
        }
    }

    @Override
    public void restore(SnapshotId snapshotId, Version version, ShardId shardId, ShardId snapshotShardId, RecoveryState recoveryState) {
        RestoreContext snapshotContext = new RestoreContext(snapshotId, version, shardId, snapshotShardId, recoveryState);
        try {
            snapshotContext.restore();
        }
        catch (Throwable e) {
            throw new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId.getSnapshot() + "]", e);
        }
    }

    @Override
    public IndexShardSnapshotStatus snapshotStatus(SnapshotId snapshotId, Version version, ShardId shardId) {
        Context context = new Context(snapshotId, version, shardId);
        BlobStoreIndexShardSnapshot snapshot = context.loadSnapshot();
        IndexShardSnapshotStatus status = new IndexShardSnapshotStatus();
        status.updateStage(IndexShardSnapshotStatus.Stage.DONE);
        status.startTime(snapshot.startTime());
        status.files(snapshot.numberOfFiles(), snapshot.totalSize());
        status.processedFiles(snapshot.numberOfFiles(), snapshot.totalSize());
        status.time(snapshot.time());
        return status;
    }

    @Override
    public void verify(String seed) {
        BlobContainer testBlobContainer = this.blobStore.blobContainer(this.basePath.add(BlobStoreRepository.testBlobPrefix(seed)));
        DiscoveryNode localNode = this.clusterService.localNode();
        if (testBlobContainer.blobExists("master.dat")) {
            try {
                testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", new BytesArray(seed));
            }
            catch (IOException exp) {
                throw new RepositoryVerificationException(this.repositoryName, "store location [" + this.blobStore + "] is not accessible on the node [" + localNode + "]", exp);
            }
        } else {
            throw new RepositoryVerificationException(this.repositoryName, "a file written by master to the store [" + this.blobStore + "] cannot be accessed on the node [" + localNode + "]. " + "This might indicate that the store [" + this.blobStore + "] is not shared between this node and the master node or " + "that permissions on the store don't allow reading files written by the master node");
        }
    }

    public void delete(SnapshotId snapshotId, Version version, ShardId shardId) {
        Context context = new Context(snapshotId, version, shardId, shardId);
        context.delete();
    }

    public String toString() {
        return "BlobStoreIndexShardRepository[[" + this.repositoryName + "], [" + this.blobStore + ']' + ']';
    }

    protected boolean isCompress() {
        return this.compress;
    }

    BlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat(Version version) {
        if (BlobStoreRepository.legacyMetaData(version)) {
            return this.indexShardSnapshotLegacyFormat;
        }
        return this.indexShardSnapshotFormat;
    }

    private static void maybeRecalculateMetadataHash(BlobContainer blobContainer, BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store.MetadataSnapshot snapshot) throws Throwable {
        StoreFileMetaData metadata;
        if (fileInfo != null && (metadata = snapshot.get(fileInfo.physicalName())) != null && metadata.hash().length > 0 && fileInfo.metadata().hash().length == 0) {
            try (PartSliceStream stream = new PartSliceStream(blobContainer, fileInfo);){
                BytesRefBuilder builder = new BytesRefBuilder();
                Store.MetadataSnapshot.hashFile(builder, stream, fileInfo.length());
                BytesRef hash = fileInfo.metadata().hash();
                assert (hash.length == 0);
                hash.bytes = builder.bytes();
                hash.offset = 0;
                hash.length = builder.length();
            }
        }
    }

    public static interface RateLimiterListener {
        public void onRestorePause(long var1);

        public void onSnapshotPause(long var1);
    }

    private class RestoreContext
    extends Context {
        private final Store store;
        private final RecoveryState recoveryState;

        public RestoreContext(SnapshotId snapshotId, Version version, ShardId shardId, ShardId snapshotShardId, RecoveryState recoveryState) {
            super(snapshotId, version, shardId, snapshotShardId);
            this.store = BlobStoreIndexShardRepository.this.indicesService.indexServiceSafe(shardId.getIndex()).shardInjectorSafe(shardId.id()).getInstance(Store.class);
            this.recoveryState = recoveryState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restore() throws IOException {
            this.store.incRef();
            try {
                SegmentInfos segmentCommitInfos;
                BlobStoreIndexShardSnapshot.FileInfo fileInfo;
                Store.MetadataSnapshot recoveryTargetMetadata;
                BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] restoring to [{}] ...", this.snapshotId, BlobStoreIndexShardRepository.this.repositoryName, this.shardId);
                BlobStoreIndexShardSnapshot snapshot = this.loadSnapshot();
                SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles());
                try {
                    recoveryTargetMetadata = this.store.getMetadataOrEmpty();
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("{} Can't read metadata from store", e, this.shardId);
                    throw new IndexShardRestoreFailedException(this.shardId, "Can't restore corrupted shard", e);
                }
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                HashMap<String, StoreFileMetaData> snapshotMetaData = new HashMap<String, StoreFileMetaData>();
                HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo2 : snapshot.indexFiles()) {
                    try {
                        BlobStoreIndexShardRepository.maybeRecalculateMetadataHash(this.blobContainer, fileInfo2, recoveryTargetMetadata);
                    }
                    catch (Throwable e) {
                        BlobStoreIndexShardRepository.this.logger.warn("{} Can't calculate hash from blog for file [{}] [{}]", e, this.shardId, fileInfo2.physicalName(), fileInfo2.metadata());
                    }
                    snapshotMetaData.put(fileInfo2.metadata().name(), fileInfo2.metadata());
                    fileInfos.put(fileInfo2.metadata().name(), fileInfo2);
                }
                Store.MetadataSnapshot sourceMetaData = new Store.MetadataSnapshot(snapshotMetaData, Collections.EMPTY_MAP, 0L);
                Store.RecoveryDiff diff = sourceMetaData.recoveryDiff(recoveryTargetMetadata);
                for (StoreFileMetaData md : diff.identical) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    this.recoveryState.getIndex().addFileDetail(fileInfo.name(), fileInfo.length(), true);
                    if (!BlobStoreIndexShardRepository.this.logger.isTraceEnabled()) continue;
                    BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] not_recovering [{}] from [{}], exists in local store and is same", this.shardId, this.snapshotId, fileInfo.physicalName(), fileInfo.name());
                }
                for (StoreFileMetaData md : Iterables.concat(diff.different, diff.missing)) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    filesToRecover.add(fileInfo);
                    this.recoveryState.getIndex().addFileDetail(fileInfo.name(), fileInfo.length(), false);
                    if (!BlobStoreIndexShardRepository.this.logger.isTraceEnabled()) continue;
                    if (md == null) {
                        BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] recovering [{}] from [{}], does not exists in local store", this.shardId, this.snapshotId, fileInfo.physicalName(), fileInfo.name());
                        continue;
                    }
                    BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] recovering [{}] from [{}], exists in local store but is different", this.shardId, this.snapshotId, fileInfo.physicalName(), fileInfo.name());
                }
                RecoveryState.Index index = this.recoveryState.getIndex();
                if (filesToRecover.isEmpty()) {
                    BlobStoreIndexShardRepository.this.logger.trace("no files to recover, all exists within the local store", new Object[0]);
                }
                if (BlobStoreIndexShardRepository.this.logger.isTraceEnabled()) {
                    BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] recovering_files [{}] with total_size [{}], reusing_files [{}] with reused_size [{}]", this.shardId, this.snapshotId, index.totalRecoverFiles(), new ByteSizeValue(index.totalRecoverBytes()), index.reusedFileCount(), new ByteSizeValue(index.reusedFileCount()));
                }
                try {
                    for (BlobStoreIndexShardSnapshot.FileInfo fileToRecover : filesToRecover) {
                        BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] restoring file [{}]", this.shardId, this.snapshotId, fileToRecover.name());
                        this.restoreFile(fileToRecover);
                    }
                }
                catch (IOException ex) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Failed to recover index", ex);
                }
                StoreFileMetaData restoredSegmentsFile = sourceMetaData.getSegmentsFile();
                if (recoveryTargetMetadata == null) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Snapshot has no segments file");
                }
                assert (restoredSegmentsFile != null);
                try {
                    segmentCommitInfos = Lucene.pruneUnreferencedFiles(restoredSegmentsFile.name(), this.store.directory());
                }
                catch (IOException e) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Failed to fetch index version after copying it over", e);
                }
                this.recoveryState.getIndex().updateVersion(segmentCommitInfos.getVersion());
                try {
                    for (String storeFile : this.store.directory().listAll()) {
                        if (Store.isAutogenerated(storeFile) || snapshotFiles.containPhysicalIndexFile(storeFile)) continue;
                        try {
                            this.store.deleteQuiet("restore", storeFile);
                            this.store.directory().deleteFile(storeFile);
                        }
                        catch (IOException e) {
                            BlobStoreIndexShardRepository.this.logger.warn("[{}] failed to delete file [{}] during snapshot cleanup", this.snapshotId, storeFile);
                        }
                    }
                }
                catch (IOException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("[{}] failed to list directory - some of files might not be deleted", this.snapshotId);
                }
            }
            finally {
                this.store.decRef();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void restoreFile(BlobStoreIndexShardSnapshot.FileInfo fileInfo) throws IOException {
            boolean success = false;
            try (PartSliceStream partSliceStream = new PartSliceStream(this.blobContainer, fileInfo);){
                InputStream stream = BlobStoreIndexShardRepository.this.restoreRateLimiter == null ? partSliceStream : new RateLimitingInputStream(partSliceStream, BlobStoreIndexShardRepository.this.restoreRateLimiter, BlobStoreIndexShardRepository.this.restoreThrottleListener);
                try {
                    try (IndexOutput indexOutput = this.store.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                        int length;
                        byte[] buffer = new byte[4096];
                        while ((length = stream.read(buffer)) > 0) {
                            indexOutput.writeBytes(buffer, 0, length);
                            this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.name(), length);
                        }
                        Store.verify(indexOutput);
                        indexOutput.close();
                        if (fileInfo.metadata().hasLegacyChecksum()) {
                            Store.LegacyChecksums legacyChecksums = new Store.LegacyChecksums();
                            legacyChecksums.add(fileInfo.metadata());
                            legacyChecksums.write(this.store);
                        }
                        this.store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                        success = true;
                    }
                    if (success) return;
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                    try {
                        try {
                            this.store.markStoreCorrupted(ex);
                            throw ex;
                        }
                        catch (IOException e) {
                            BlobStoreIndexShardRepository.this.logger.warn("store cannot be marked as corrupted", e, new Object[0]);
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        this.store.deleteQuiet(fileInfo.physicalName());
                        throw throwable;
                    }
                }
                this.store.deleteQuiet(fileInfo.physicalName());
                return;
            }
        }
    }

    private static final class PartSliceStream
    extends SlicedInputStream {
        private final BlobContainer container;
        private final BlobStoreIndexShardSnapshot.FileInfo info;

        public PartSliceStream(BlobContainer container, BlobStoreIndexShardSnapshot.FileInfo info) {
            super(info.numberOfParts());
            this.info = info;
            this.container = container;
        }

        @Override
        protected InputStream openSlice(long slice) throws IOException {
            return this.container.readBlob(this.info.partName(slice));
        }
    }

    private class SnapshotContext
    extends Context {
        private final Store store;
        private final IndexShardSnapshotStatus snapshotStatus;

        public SnapshotContext(SnapshotId snapshotId, ShardId shardId, IndexShardSnapshotStatus snapshotStatus) {
            super(snapshotId, Version.CURRENT, shardId);
            IndexService indexService = BlobStoreIndexShardRepository.this.indicesService.indexServiceSafe(shardId.getIndex());
            this.store = indexService.shardInjectorSafe(shardId.id()).getInstance(Store.class);
            this.snapshotStatus = snapshotStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void snapshot(SnapshotIndexCommit snapshotIndexCommit) {
            BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] snapshot to [{}] ...", this.shardId, this.snapshotId, BlobStoreIndexShardRepository.this.repositoryName);
            this.store.incRef();
            try {
                Store.MetadataSnapshot metadata;
                Map<String, BlobMetaData> blobs;
                try {
                    blobs = this.blobContainer.listBlobs();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(this.shardId, "failed to list blobs", e);
                }
                long generation = this.findLatestFileNameGeneration(blobs);
                Tuple<BlobStoreIndexShardSnapshots, Integer> tuple = this.buildBlobStoreIndexShardSnapshots(blobs);
                BlobStoreIndexShardSnapshots snapshots = tuple.v1();
                int fileListGeneration = tuple.v2();
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                int indexNumberOfFiles = 0;
                long indexTotalFilesSize = 0L;
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                try {
                    metadata = this.store.getMetadata(snapshotIndexCommit);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(this.shardId, "Failed to get store file metadata", e);
                }
                for (String fileName : snapshotIndexCommit.getFiles()) {
                    if (this.snapshotStatus.aborted()) {
                        BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] Aborted on the file [{}], exiting", this.shardId, this.snapshotId, fileName);
                        throw new IndexShardSnapshotFailedException(this.shardId, "Aborted");
                    }
                    BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] Processing [{}]", this.shardId, this.snapshotId, fileName);
                    StoreFileMetaData md = metadata.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            try {
                                BlobStoreIndexShardRepository.maybeRecalculateMetadataHash(this.blobContainer, fileInfo, metadata);
                            }
                            catch (Throwable e) {
                                BlobStoreIndexShardRepository.this.logger.warn("{} Can't calculate hash from blob for file [{}] [{}]", e, this.shardId, fileInfo.physicalName(), fileInfo.metadata());
                            }
                            if (!fileInfo.isSame(md) || !this.snapshotFileExistsInBlobs(fileInfo, blobs)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    if (existingFileInfo == null) {
                        ++indexNumberOfFiles;
                        indexTotalFilesSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo(this.fileNameFromGeneration(++generation), md, BlobStoreIndexShardRepository.this.chunkSize);
                        indexCommitPointFiles.add(snapshotFileInfo);
                        filesToSnapshot.add(snapshotFileInfo);
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
                this.snapshotStatus.files(indexNumberOfFiles, indexTotalFilesSize);
                if (this.snapshotStatus.aborted()) {
                    BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] Aborted during initialization", this.shardId, this.snapshotId);
                    throw new IndexShardSnapshotFailedException(this.shardId, "Aborted");
                }
                this.snapshotStatus.updateStage(IndexShardSnapshotStatus.Stage.STARTED);
                for (BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo : filesToSnapshot) {
                    try {
                        this.snapshotFile(snapshotFileInfo);
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(this.shardId, "Failed to perform snapshot (index files)", e);
                    }
                }
                this.snapshotStatus.indexVersion(snapshotIndexCommit.getGeneration());
                this.snapshotStatus.updateStage(IndexShardSnapshotStatus.Stage.FINALIZE);
                BlobStoreIndexShardSnapshot snapshot = new BlobStoreIndexShardSnapshot(this.snapshotId.getSnapshot(), snapshotIndexCommit.getGeneration(), indexCommitPointFiles, this.snapshotStatus.startTime(), System.currentTimeMillis() - this.snapshotStatus.startTime(), indexNumberOfFiles, indexTotalFilesSize);
                BlobStoreIndexShardRepository.this.logger.trace("[{}] [{}] writing shard snapshot file", this.shardId, this.snapshotId);
                try {
                    BlobStoreIndexShardRepository.this.indexShardSnapshotFormat.write(snapshot, this.blobContainer, this.snapshotId.getSnapshot());
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(this.shardId, "Failed to write commit point", e);
                }
                ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
                newSnapshotsList.add(new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles()));
                for (SnapshotFiles point : snapshots) {
                    newSnapshotsList.add(point);
                }
                this.finalize(newSnapshotsList, fileListGeneration + 1, blobs);
                this.snapshotStatus.updateStage(IndexShardSnapshotStatus.Stage.DONE);
            }
            finally {
                this.store.decRef();
            }
        }

        private void snapshotFile(BlobStoreIndexShardSnapshot.FileInfo fileInfo) throws IOException {
            String file = fileInfo.physicalName();
            try (IndexInput indexInput = this.store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
                int i = 0;
                while ((long)i < fileInfo.numberOfParts()) {
                    long partBytes = fileInfo.partBytes(i);
                    InputStreamIndexInput inputStreamIndexInput = new InputStreamIndexInput(indexInput, partBytes);
                    InputStream inputStream = BlobStoreIndexShardRepository.this.snapshotRateLimiter == null ? inputStreamIndexInput : new RateLimitingInputStream(inputStreamIndexInput, BlobStoreIndexShardRepository.this.snapshotRateLimiter, BlobStoreIndexShardRepository.this.snapshotThrottleListener);
                    inputStream = new AbortableInputStream(inputStream, fileInfo.physicalName());
                    this.blobContainer.writeBlob(fileInfo.partName(i), inputStream, partBytes);
                    ++i;
                }
                Store.verify(indexInput);
                this.snapshotStatus.addProcessedFile(fileInfo.length());
            }
            catch (Throwable t) {
                this.failStoreIfCorrupted(t);
                this.snapshotStatus.addProcessedFile(0L);
                throw t;
            }
        }

        private void failStoreIfCorrupted(Throwable t) {
            if (t instanceof CorruptIndexException || t instanceof IndexFormatTooOldException || t instanceof IndexFormatTooNewException) {
                try {
                    this.store.markStoreCorrupted((IOException)t);
                }
                catch (IOException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("store cannot be marked as corrupted", e, new Object[0]);
                }
            }
        }

        private boolean snapshotFileExistsInBlobs(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Map<String, BlobMetaData> blobs) {
            BlobMetaData blobMetaData = blobs.get(fileInfo.name());
            if (blobMetaData != null) {
                return blobMetaData.length() == fileInfo.length();
            }
            if (blobs.containsKey(fileInfo.partName(0L))) {
                int part = 0;
                long totalSize = 0L;
                while ((blobMetaData = blobs.get(fileInfo.partName(part++))) != null) {
                    totalSize += blobMetaData.length();
                }
                return totalSize == fileInfo.length();
            }
            return false;
        }

        private class AbortableInputStream
        extends FilterInputStream {
            private final String fileName;

            public AbortableInputStream(InputStream delegate, String fileName) {
                super(delegate);
                this.fileName = fileName;
            }

            @Override
            public int read() throws IOException {
                this.checkAborted();
                return this.in.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkAborted();
                return this.in.read(b, off, len);
            }

            private void checkAborted() {
                if (SnapshotContext.this.snapshotStatus.aborted()) {
                    BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] Aborted on the file [{}], exiting", SnapshotContext.this.shardId, SnapshotContext.this.snapshotId, this.fileName);
                    throw new IndexShardSnapshotFailedException(SnapshotContext.this.shardId, "Aborted");
                }
            }
        }
    }

    private class Context {
        protected final SnapshotId snapshotId;
        protected final ShardId shardId;
        protected final BlobContainer blobContainer;
        protected final Version version;

        public Context(SnapshotId snapshotId, Version version, ShardId shardId) {
            this(snapshotId, version, shardId, shardId);
        }

        public Context(SnapshotId snapshotId, Version version, ShardId shardId, ShardId snapshotShardId) {
            this.snapshotId = snapshotId;
            this.version = version;
            this.shardId = shardId;
            this.blobContainer = BlobStoreIndexShardRepository.this.blobStore.blobContainer(BlobStoreIndexShardRepository.this.basePath.add("indices").add(snapshotShardId.getIndex()).add(Integer.toString(snapshotShardId.getId())));
        }

        public void delete() {
            Map<String, BlobMetaData> blobs;
            try {
                blobs = this.blobContainer.listBlobs();
            }
            catch (IOException e) {
                throw new IndexShardSnapshotException(this.shardId, "Failed to list content of gateway", e);
            }
            Tuple<BlobStoreIndexShardSnapshots, Integer> tuple = this.buildBlobStoreIndexShardSnapshots(blobs);
            BlobStoreIndexShardSnapshots snapshots = tuple.v1();
            int fileListGeneration = tuple.v2();
            try {
                BlobStoreIndexShardRepository.this.indexShardSnapshotFormat(this.version).delete(this.blobContainer, this.snapshotId.getSnapshot());
            }
            catch (IOException e) {
                BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] failed to delete shard snapshot file", this.shardId, this.snapshotId);
            }
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            for (SnapshotFiles point : snapshots) {
                if (point.snapshot().equals(this.snapshotId.getSnapshot())) continue;
                newSnapshotsList.add(point);
            }
            this.finalize(newSnapshotsList, fileListGeneration + 1, blobs);
        }

        public BlobStoreIndexShardSnapshot loadSnapshot() {
            try {
                return BlobStoreIndexShardRepository.this.indexShardSnapshotFormat(this.version).read(this.blobContainer, this.snapshotId.getSnapshot());
            }
            catch (IOException ex) {
                throw new IndexShardRestoreFailedException(this.shardId, "failed to read shard snapshot file", ex);
            }
        }

        protected void finalize(List<SnapshotFiles> snapshots, int fileListGeneration, Map<String, BlobMetaData> blobs) {
            BlobStoreIndexShardSnapshots newSnapshots = new BlobStoreIndexShardSnapshots(snapshots);
            ArrayList<String> blobsToDelete = new ArrayList<String>();
            for (String blobName : blobs.keySet()) {
                if (!BlobStoreIndexShardRepository.this.indexShardSnapshotsFormat.isTempBlobName(blobName) && !blobName.startsWith(BlobStoreIndexShardRepository.SNAPSHOT_INDEX_PREFIX)) continue;
                blobsToDelete.add(blobName);
            }
            try {
                this.blobContainer.deleteBlobs(blobsToDelete);
            }
            catch (IOException e) {
                throw new IndexShardSnapshotFailedException(this.shardId, "error deleting index files during cleanup, reason: " + e.getMessage(), e);
            }
            blobsToDelete = new ArrayList();
            for (String blobName : blobs.keySet()) {
                if (!blobName.startsWith(BlobStoreIndexShardRepository.DATA_BLOB_PREFIX) || newSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blobName)) != null) continue;
                blobsToDelete.add(blobName);
            }
            try {
                this.blobContainer.deleteBlobs(blobsToDelete);
            }
            catch (IOException e) {
                BlobStoreIndexShardRepository.this.logger.debug("[{}] [{}] error deleting some of the blobs [{}] during cleanup", e, this.snapshotId, this.shardId, blobsToDelete);
            }
            if (snapshots.size() > 0) {
                try {
                    BlobStoreIndexShardRepository.this.indexShardSnapshotsFormat.writeAtomic(newSnapshots, this.blobContainer, Integer.toString(fileListGeneration));
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(this.shardId, "Failed to write file list", e);
                }
            }
        }

        protected String fileNameFromGeneration(long generation) {
            return BlobStoreIndexShardRepository.DATA_BLOB_PREFIX + Long.toString(generation, 36);
        }

        protected long findLatestFileNameGeneration(Map<String, BlobMetaData> blobs) {
            long generation = -1L;
            for (String name : blobs.keySet()) {
                if (!name.startsWith(BlobStoreIndexShardRepository.DATA_BLOB_PREFIX)) continue;
                name = BlobStoreIndexShardSnapshot.FileInfo.canonicalName(name);
                try {
                    long currentGen = Long.parseLong(name.substring(BlobStoreIndexShardRepository.DATA_BLOB_PREFIX.length()), 36);
                    if (currentGen <= generation) continue;
                    generation = currentGen;
                }
                catch (NumberFormatException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("file [{}] does not conform to the '{}' schema", name, BlobStoreIndexShardRepository.DATA_BLOB_PREFIX);
                }
            }
            return generation;
        }

        protected Tuple<BlobStoreIndexShardSnapshots, Integer> buildBlobStoreIndexShardSnapshots(Map<String, BlobMetaData> blobs) {
            int latest = -1;
            for (String name : blobs.keySet()) {
                if (!name.startsWith(BlobStoreIndexShardRepository.SNAPSHOT_INDEX_PREFIX)) continue;
                try {
                    int gen = Integer.parseInt(name.substring(BlobStoreIndexShardRepository.SNAPSHOT_INDEX_PREFIX.length()));
                    if (gen <= latest) continue;
                    latest = gen;
                }
                catch (NumberFormatException ex) {
                    BlobStoreIndexShardRepository.this.logger.warn("failed to parse index file name [{}]", name);
                }
            }
            if (latest >= 0) {
                try {
                    return new Tuple<BlobStoreIndexShardSnapshots, Integer>((BlobStoreIndexShardSnapshots)BlobStoreIndexShardRepository.this.indexShardSnapshotsFormat.read(this.blobContainer, Integer.toString(latest)), latest);
                }
                catch (IOException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("failed to read index file  [{}]", e, BlobStoreIndexShardRepository.SNAPSHOT_INDEX_PREFIX + latest);
                }
            }
            ArrayList<SnapshotFiles> snapshots = new ArrayList<SnapshotFiles>();
            for (String name : blobs.keySet()) {
                try {
                    BlobStoreIndexShardSnapshot snapshot = null;
                    if (name.startsWith(BlobStoreIndexShardRepository.SNAPSHOT_PREFIX)) {
                        snapshot = (BlobStoreIndexShardSnapshot)BlobStoreIndexShardRepository.this.indexShardSnapshotFormat.readBlob(this.blobContainer, name);
                    } else if (name.startsWith(BlobStoreIndexShardRepository.LEGACY_SNAPSHOT_PREFIX)) {
                        snapshot = (BlobStoreIndexShardSnapshot)BlobStoreIndexShardRepository.this.indexShardSnapshotLegacyFormat.readBlob(this.blobContainer, name);
                    }
                    if (snapshot == null) continue;
                    snapshots.add(new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles()));
                }
                catch (IOException e) {
                    BlobStoreIndexShardRepository.this.logger.warn("failed to read commit point [{}]", e, name);
                }
            }
            return new Tuple<BlobStoreIndexShardSnapshots, Integer>(new BlobStoreIndexShardSnapshots(snapshots), -1);
        }
    }
}

