/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.all.AllEntries;

public final class AllTokenStream
extends TokenFilter {
    private final BytesRef payloadSpare = new BytesRef(new byte[4]);
    private final AllEntries allEntries;
    private final OffsetAttribute offsetAttribute;
    private final PayloadAttribute payloadAttribute;

    public static TokenStream allTokenStream(String allFieldName, AllEntries allEntries, Analyzer analyzer) throws IOException {
        return new AllTokenStream(analyzer.tokenStream(allFieldName, allEntries), allEntries);
    }

    AllTokenStream(TokenStream input, AllEntries allEntries) {
        super(input);
        this.allEntries = allEntries;
        this.offsetAttribute = this.addAttribute(OffsetAttribute.class);
        this.payloadAttribute = this.addAttribute(PayloadAttribute.class);
    }

    public AllEntries allEntries() {
        return this.allEntries;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        float boost = this.allEntries.boost(this.offsetAttribute.startOffset());
        if (boost != 1.0f) {
            PayloadHelper.encodeFloat(boost, this.payloadSpare.bytes, this.payloadSpare.offset);
            this.payloadAttribute.setPayload(this.payloadSpare);
        } else {
            this.payloadAttribute.setPayload(null);
        }
        return true;
    }

    @Override
    public String toString() {
        return this.allEntries.toString();
    }
}

