/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.spi;

import com.google.common.base.Preconditions;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.ElementVisitor;

public final class Message
implements Serializable,
Element {
    private final String message;
    private final Throwable cause;
    private final List<Object> sources;
    private static final long serialVersionUID = 0L;

    public Message(List<Object> sources, String message, Throwable cause) {
        this.sources = Collections.unmodifiableList(sources);
        this.message = Preconditions.checkNotNull(message, "message");
        this.cause = cause;
    }

    public Message(Object source, String message) {
        this(Collections.singletonList(source), message, null);
    }

    public Message(String message) {
        this(Collections.emptyList(), message, null);
    }

    @Override
    public String getSource() {
        return this.sources.isEmpty() ? SourceProvider.UNKNOWN_SOURCE.toString() : Errors.convert(this.sources.get(this.sources.size() - 1)).toString();
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message e = (Message)o;
        return this.message.equals(e.message) && Objects.equals(this.cause, e.cause) && this.sources.equals(e.sources);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).addError(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        Object[] sourcesAsStrings = this.sources.toArray();
        for (int i = 0; i < sourcesAsStrings.length; ++i) {
            sourcesAsStrings[i] = Errors.convert(sourcesAsStrings[i]).toString();
        }
        return new Message(Arrays.asList(sourcesAsStrings), this.message, this.cause);
    }
}

