/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.exists;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.exists.ExistsResponse;
import org.elasticsearch.action.exists.ShardExistsRequest;
import org.elasticsearch.action.exists.ShardExistsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExistsAction
extends TransportBroadcastAction<ExistsRequest, ExistsResponse, ShardExistsRequest, ShardExistsResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportExistsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/exists", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExistsRequest.class, ShardExistsRequest.class, "search");
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
    }

    @Override
    protected void doExecute(Task task, ExistsRequest request, ActionListener<ExistsResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        new ExistsAsyncBroadcastAction(task, request, listener).start();
    }

    @Override
    protected ShardExistsRequest newShardRequest(int numShards, ShardRouting shard, ExistsRequest request) {
        String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterService.state(), shard.index(), request.indices());
        return new ShardExistsRequest(shard.shardId(), filteringAliases, request);
    }

    @Override
    protected ShardExistsResponse newShardResponse() {
        return new ShardExistsResponse();
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, ExistsRequest request, String[] concreteIndices) {
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, request.routing(), request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ExistsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ExistsRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    @Override
    protected ExistsResponse newResponse(ExistsRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        boolean exists = false;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = shardsResponses.length() - 1; i >= 0; --i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) continue;
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            ++successfulShards;
            exists = ((ShardExistsResponse)shardResponse).exists();
            if (!exists) continue;
            successfulShards = shardsResponses.length() - failedShards;
            break;
        }
        return new ExistsResponse(exists, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ShardExistsResponse shardOperation(ShardExistsRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.shardSafe(request.shardId().id());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.shardId().getIndex(), request.shardId().id());
        DefaultSearchContext context = new DefaultSearchContext(0L, new ShardSearchLocalRequest(request.types(), request.nowInMillis(), request.filteringAliases()), shardTarget, indexShard.acquireSearcher("exists"), indexService, indexShard, this.scriptService, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), this.parseFieldMatcher, SearchService.NO_TIMEOUT);
        SearchContext.setCurrent(context);
        try {
            BytesReference source;
            if (request.minScore() != -1.0f) {
                ((SearchContext)context).minimumScore(request.minScore());
            }
            if ((source = request.querySource()) != null && source.length() > 0) {
                try {
                    QueryParseContext.setTypes(request.types());
                    ((SearchContext)context).parsedQuery(indexService.queryParserService().parseQuery(source));
                }
                finally {
                    QueryParseContext.removeTypes();
                }
            }
            ((SearchContext)context).preProcess();
            try {
                boolean exists;
                try {
                    exists = Lucene.exists(((SearchContext)context).searcher(), ((SearchContext)context).query());
                }
                finally {
                    context.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                ShardExistsResponse shardExistsResponse = new ShardExistsResponse(request.shardId(), exists);
                return shardExistsResponse;
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context, "failed to execute exists", (Throwable)e);
            }
        }
        finally {
            context.close();
            SearchContext.removeCurrent();
        }
    }

    private final class ExistsAsyncBroadcastAction
    extends TransportBroadcastAction.AsyncBroadcastAction {
        final AtomicBoolean processed;

        ExistsAsyncBroadcastAction(Task task, ExistsRequest request, ActionListener<ExistsResponse> listener) {
            super((TransportBroadcastAction)TransportExistsAction.this, task, (BroadcastRequest)request, listener);
            this.processed = new AtomicBoolean(false);
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardExistsResponse response) {
            super.onOperation(shard, shardIndex, response);
            if (response.exists()) {
                this.finishHim();
            }
        }

        @Override
        protected void performOperation(ShardIterator shardIt, ShardRouting shard, int shardIndex) {
            if (this.processed.get()) {
                return;
            }
            super.performOperation(shardIt, shard, shardIndex);
        }

        @Override
        protected void finishHim() {
            if (this.processed.compareAndSet(false, true)) {
                super.finishHim();
            }
        }
    }
}

