/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private final IRubyObject io;
    private final InputStream in;
    private final IRubyObject numOne;
    private static final CallSite readAdapter = MethodIndex.getFunctionalCallSite("read");
    private static final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOInputStream(IRubyObject io2) {
        if (!io2.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io2 + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = io2;
        this.in = io2 instanceof RubyIO && !((RubyIO)io2).isClosed() && ((RubyIO)io2).isBuiltin("read") ? ((RubyIO)io2).getInStream() : null;
        this.numOne = RubyFixnum.one(this.io.getRuntime());
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        } else if (this.io.respondsTo("close")) {
            closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }

    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    public int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, this.numOne);
        int returnValue = -1;
        if (!readValue.isNil()) {
            returnValue = readValue.convertToString().getByteList().get(0);
        }
        return returnValue;
    }

    public int read(byte[] b) throws IOException {
        if (this.in != null) {
            return this.in.read(b, 0, b.length);
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)this.io.getRuntime().newFixnum(b.length));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = readValue.convertToString().getByteList();
            System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b, 0, str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in != null) {
            return this.in.read(b, off, len);
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)this.io.getRuntime().newFixnum(len));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = readValue.convertToString().getByteList();
            System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b, off, str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }
}

