/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedMethod;
import org.jruby.internal.runtime.methods.JittedMethod;
import org.jruby.internal.runtime.methods.TraceableInterpretedMethod;
import org.jruby.internal.runtime.methods.TraceableJittedMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;

public class DynamicMethodFactory {
    public static DynamicMethod newDefaultMethod(Ruby runtime2, RubyModule container, String name2, StaticScope scope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        if (runtime2.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFF) {
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                return new TraceableInterpretedMethod(container, scope, body, name2, argsNode, visibility, position);
            }
            return new InterpretedMethod(container, scope, body, name2, argsNode, visibility, position);
        }
        return new DefaultMethod(container, scope, body, name2, argsNode, visibility, position);
    }

    public static InterpretedMethod newInterpretedMethod(Ruby runtime2, RubyModule container, StaticScope scope, Node body, String name2, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return new TraceableInterpretedMethod(container, scope, body, name2, argsNode, visibility, position);
        }
        return new InterpretedMethod(container, scope, body, name2, argsNode, visibility, position);
    }

    public static DynamicMethod newJittedMethod(Ruby runtime2, RubyModule container, StaticScope scope, Script script, String name2, CallConfiguration config, Visibility visibility, Arity arity2, ISourcePosition position, DefaultMethod defaultMethod) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return new TraceableJittedMethod(container, scope, script, name2, config, visibility, arity2, position, defaultMethod);
        }
        return new JittedMethod(container, scope, script, name2, config, visibility, arity2, position, defaultMethod);
    }
}

