/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.IdentityHashMap;
import java.util.Map;
import org.jcodings.util.IntHash;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Enum"}, parent="Object")
public final class Enum
extends RubyObject {
    private final IRubyObject nativeType;
    private final RubyHash kv_map;
    private volatile IRubyObject tag;
    private volatile Map<RubySymbol, RubyInteger> symbolToValue = new IdentityHashMap<RubySymbol, RubyInteger>();
    private volatile IntHash<RubySymbol> valueToSymbol = new IntHash();

    public static RubyClass createEnumClass(Ruby runtime2, RubyModule ffiModule) {
        RubyClass enumClass = ffiModule.defineClassUnder("Enum", runtime2.getObject(), Allocator.INSTANCE);
        enumClass.defineAnnotatedMethods(Enum.class);
        enumClass.defineAnnotatedConstants(Enum.class);
        enumClass.includeModule(ffiModule.fastGetConstant("DataConverter"));
        return enumClass;
    }

    private Enum(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.nativeType = runtime2.fastGetModule("FFI").fastGetClass("Type").fastGetConstant("INT");
        this.kv_map = RubyHash.newHash(runtime2);
        this.tag = runtime2.getNil();
    }

    @JRubyMethod(name={"initialize"})
    public final IRubyObject initialize(ThreadContext context, IRubyObject values, IRubyObject tag2) {
        this.tag = tag2;
        return this.initialize(context, values);
    }

    @JRubyMethod(name={"initialize"})
    public final IRubyObject initialize(ThreadContext context, IRubyObject values) {
        if (!(values instanceof RubyArray)) {
            throw context.getRuntime().newTypeError(values, context.getRuntime().getArray());
        }
        RubyArray ary = (RubyArray)values;
        IdentityHashMap<RubySymbol, RubyFixnum> s2v = new IdentityHashMap<RubySymbol, RubyFixnum>();
        IRubyObject prevConstant = null;
        int nextValue = 0;
        for (int i2 = 0; i2 < ary.size(); ++i2) {
            IRubyObject v = ary.entry(i2);
            if (v instanceof RubySymbol) {
                s2v.put((RubySymbol)v, RubyFixnum.newFixnum(context.getRuntime(), nextValue));
                prevConstant = v;
                ++nextValue;
                continue;
            }
            if (v instanceof RubyFixnum) {
                if (prevConstant == null) {
                    throw context.getRuntime().newArgumentError("invalid enum sequence - no symbol for value " + v);
                }
                s2v.put((RubySymbol)prevConstant, (RubyFixnum)v);
                nextValue = (int)((RubyInteger)v).getLongValue() + 1;
                continue;
            }
            throw context.getRuntime().newTypeError(v, context.getRuntime().getSymbol());
        }
        this.symbolToValue = new IdentityHashMap<RubySymbol, RubyInteger>(s2v);
        this.valueToSymbol = new IntHash(this.symbolToValue.size());
        for (Map.Entry<RubySymbol, RubyInteger> e : this.symbolToValue.entrySet()) {
            this.kv_map.fastASet(e.getKey(), e.getValue());
            this.valueToSymbol.put((int)e.getValue().getLongValue(), e.getKey());
        }
        return this;
    }

    @JRubyMethod(name={"[]", "find"})
    public final IRubyObject find(ThreadContext context, IRubyObject query) {
        if (query instanceof RubySymbol) {
            IRubyObject value2 = this.kv_map.fastARef(query);
            return value2 != null ? value2 : context.getRuntime().getNil();
        }
        if (query instanceof RubyInteger) {
            RubySymbol symbol = this.valueToSymbol.get((int)((RubyInteger)query).getLongValue());
            return symbol != null ? symbol : context.getRuntime().getNil();
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"symbol_map", "to_h", "to_hash"})
    public final IRubyObject symbol_map(ThreadContext context) {
        return this.kv_map.dup(context);
    }

    @JRubyMethod(name={"symbols"})
    public final IRubyObject symbols(ThreadContext context) {
        return this.kv_map.keys();
    }

    @JRubyMethod(name={"tag"})
    public final IRubyObject tag(ThreadContext context) {
        return this.tag;
    }

    @JRubyMethod(name={"native_type"})
    public final IRubyObject native_type(ThreadContext context) {
        return this.nativeType;
    }

    @JRubyMethod(name={"to_native"})
    public final IRubyObject to_native(ThreadContext context, IRubyObject name2, IRubyObject ctx) {
        RubyInteger value2;
        if (name2 instanceof RubySymbol && (value2 = this.symbolToValue.get((RubySymbol)name2)) != null) {
            return value2;
        }
        if (name2 instanceof RubyInteger) {
            return name2;
        }
        if (name2.respondsTo("to_int")) {
            return name2.convertToInteger();
        }
        throw name2.getRuntime().newArgumentError("invalid enum value, " + name2.inspect());
    }

    @JRubyMethod(name={"from_native"})
    public final IRubyObject from_native(ThreadContext context, IRubyObject value2, IRubyObject ctx) {
        RubySymbol sym;
        if (value2 instanceof RubyInteger && (sym = this.valueToSymbol.get((int)((RubyInteger)value2).getLongValue())) != null) {
            return sym;
        }
        return value2;
    }

    @JRubyMethod(name={"reference_required?"})
    public IRubyObject reference_required_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Enum(runtime2, klass);
        }
    }
}

