/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.flexible;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

public class QuorumMaj
implements QuorumVerifier {
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private HashMap<Long, QuorumPeer.QuorumServer> votingMembers = new HashMap();
    private HashMap<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap();
    private long version = 0L;
    private int half;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QuorumMaj)) {
            return false;
        }
        QuorumMaj qm = (QuorumMaj)o;
        if (qm.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != qm.getAllMembers().size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer qs : this.allMembers.values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(qs.id);
            if (qso != null && qs.equals(qso)) continue;
            return false;
        }
        return true;
    }

    public QuorumMaj(Map<Long, QuorumPeer.QuorumServer> allMembers) {
        this.allMembers = allMembers;
        for (QuorumPeer.QuorumServer qs : allMembers.values()) {
            if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                this.votingMembers.put(qs.id, qs);
                continue;
            }
            this.observingMembers.put(qs.id, qs);
        }
        this.half = this.votingMembers.size() / 2;
    }

    public QuorumMaj(Properties props) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key2 = entry.getKey().toString();
            String value2 = entry.getValue().toString();
            if (key2.startsWith("server.")) {
                int dot = key2.indexOf(46);
                long sid = Long.parseLong(key2.substring(dot + 1));
                QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(sid, value2);
                this.allMembers.put(sid, qs);
                if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.votingMembers.put(sid, qs);
                    continue;
                }
                this.observingMembers.put(sid, qs);
                continue;
            }
            if (!key2.equals("version")) continue;
            this.version = Long.parseLong(value2, 16);
        }
        this.half = this.votingMembers.size() / 2;
    }

    @Override
    public long getWeight(long id2) {
        return 1L;
    }

    @Override
    public String toString() {
        StringBuilder sw = new StringBuilder();
        for (QuorumPeer.QuorumServer member : this.getAllMembers().values()) {
            String key2 = "server." + member.id;
            String value2 = member.toString();
            sw.append(key2);
            sw.append('=');
            sw.append(value2);
            sw.append('\n');
        }
        String hexVersion = Long.toHexString(this.version);
        sw.append("version=");
        sw.append(hexVersion);
        return sw.toString();
    }

    @Override
    public boolean containsQuorum(Set<Long> ackSet) {
        return ackSet.size() > this.half;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.votingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long ver2) {
        this.version = ver2;
    }
}

