/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliException;

public class CliWrapperException
extends CliException {
    public CliWrapperException(Throwable cause2) {
        super(CliWrapperException.getMessage(cause2), cause2);
    }

    private static String getMessage(Throwable cause2) {
        if (cause2 instanceof KeeperException) {
            KeeperException keeperException = (KeeperException)cause2;
            if (keeperException instanceof KeeperException.NoNodeException) {
                return "Node does not exist: " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.NoChildrenForEphemeralsException) {
                return "Ephemerals cannot have children: " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.NodeExistsException) {
                return "Node already exists: " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.NotEmptyException) {
                return "Node not empty: " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.NotReadOnlyException) {
                return "Not a read-only call: " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.InvalidACLException) {
                return "Acl is not valid : " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.NoAuthException) {
                return "Authentication is not valid : " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.BadArgumentsException) {
                return "Arguments are not valid : " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.BadVersionException) {
                return "version No is not valid : " + keeperException.getPath();
            }
            if (keeperException instanceof KeeperException.ReconfigInProgress) {
                return "Another reconfiguration is in progress -- concurrent reconfigs not supported (yet)";
            }
            if (keeperException instanceof KeeperException.NewConfigNoQuorum) {
                return "No quorum of new config is connected and up-to-date with the leader of last commmitted config - try invoking reconfiguration after new servers are connected and synced";
            }
        }
        return cause2.getMessage();
    }
}

