/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.BitSet;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class TokenParser {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final char DQUOTE = '\"';
    public static final char ESCAPE = '\\';
    public static final TokenParser INSTANCE = new TokenParser();

    public static BitSet INIT_BITSET(int ... b) {
        BitSet bitset = new BitSet();
        for (int aB : b) {
            bitset.set(aB);
        }
        return bitset;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public String parseToken(CharArrayBuffer buf, ParserCursor cursor, BitSet delimiters) {
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current2 = buf.charAt(cursor.getPos());
            if (delimiters != null && delimiters.get(current2)) break;
            if (TokenParser.isWhitespace(current2)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (whitespace && dst.length() > 0) {
                dst.append(' ');
            }
            this.copyContent(buf, cursor, delimiters, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    public String parseValue(CharArrayBuffer buf, ParserCursor cursor, BitSet delimiters) {
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current2 = buf.charAt(cursor.getPos());
            if (delimiters != null && delimiters.get(current2)) break;
            if (TokenParser.isWhitespace(current2)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (current2 == '\"') {
                if (whitespace && dst.length() > 0) {
                    dst.append(' ');
                }
                this.copyQuotedContent(buf, cursor, dst);
                whitespace = false;
                continue;
            }
            if (whitespace && dst.length() > 0) {
                dst.append(' ');
            }
            this.copyUnquotedContent(buf, cursor, delimiters, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    public void skipWhiteSpace(CharArrayBuffer buf, ParserCursor cursor) {
        char current2;
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo && TokenParser.isWhitespace(current2 = buf.charAt(i2)); ++i2) {
            ++pos2;
        }
        cursor.updatePos(pos2);
    }

    public void copyContent(CharArrayBuffer buf, ParserCursor cursor, BitSet delimiters, StringBuilder dst) {
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo; ++i2) {
            char current2 = buf.charAt(i2);
            if (delimiters != null && delimiters.get(current2) || TokenParser.isWhitespace(current2)) break;
            ++pos2;
            dst.append(current2);
        }
        cursor.updatePos(pos2);
    }

    public void copyUnquotedContent(CharArrayBuffer buf, ParserCursor cursor, BitSet delimiters, StringBuilder dst) {
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo; ++i2) {
            char current2 = buf.charAt(i2);
            if (delimiters != null && delimiters.get(current2) || TokenParser.isWhitespace(current2) || current2 == '\"') break;
            ++pos2;
            dst.append(current2);
        }
        cursor.updatePos(pos2);
    }

    public void copyQuotedContent(CharArrayBuffer buf, ParserCursor cursor, StringBuilder dst) {
        if (cursor.atEnd()) {
            return;
        }
        int pos2 = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        char current2 = buf.charAt(pos2);
        if (current2 != '\"') {
            return;
        }
        ++pos2;
        boolean escaped = false;
        int i2 = ++indexFrom;
        while (i2 < indexTo) {
            current2 = buf.charAt(i2);
            if (escaped) {
                if (current2 != '\"' && current2 != '\\') {
                    dst.append('\\');
                }
                dst.append(current2);
                escaped = false;
            } else {
                if (current2 == '\"') {
                    ++pos2;
                    break;
                }
                if (current2 == '\\') {
                    escaped = true;
                } else if (current2 != '\r' && current2 != '\n') {
                    dst.append(current2);
                }
            }
            ++i2;
            ++pos2;
        }
        cursor.updatePos(pos2);
    }
}

