/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextAttributes {
    public static ContextAttributes getEmpty() {
        return Impl.getEmpty();
    }

    public abstract ContextAttributes withSharedAttribute(Object var1, Object var2);

    public abstract ContextAttributes withSharedAttributes(Map<Object, Object> var1);

    public abstract ContextAttributes withoutSharedAttribute(Object var1);

    public abstract Object getAttribute(Object var1);

    public abstract ContextAttributes withPerCallAttribute(Object var1, Object var2);

    public static class Impl
    extends ContextAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Impl EMPTY = new Impl(Collections.<Object, Object>emptyMap());
        protected static final Object NULL_SURROGATE = new Object();
        protected final Map<Object, Object> _shared;
        protected transient Map<Object, Object> _nonShared;

        protected Impl(Map<Object, Object> shared) {
            this._shared = shared;
            this._nonShared = null;
        }

        protected Impl(Map<Object, Object> shared, Map<Object, Object> nonShared) {
            this._shared = shared;
            this._nonShared = nonShared;
        }

        public static ContextAttributes getEmpty() {
            return EMPTY;
        }

        @Override
        public ContextAttributes withSharedAttribute(Object key2, Object value2) {
            Map<Object, Object> m = this == EMPTY ? new HashMap(8) : this._copy(this._shared);
            m.put(key2, value2);
            return new Impl(m);
        }

        @Override
        public ContextAttributes withSharedAttributes(Map<Object, Object> shared) {
            return new Impl(shared);
        }

        @Override
        public ContextAttributes withoutSharedAttribute(Object key2) {
            if (this._shared.isEmpty()) {
                return this;
            }
            if (this._shared.containsKey(key2)) {
                if (this._shared.size() == 1) {
                    return EMPTY;
                }
            } else {
                return this;
            }
            Map<Object, Object> m = this._copy(this._shared);
            m.remove(key2);
            return new Impl(m);
        }

        @Override
        public Object getAttribute(Object key2) {
            Object ob;
            if (this._nonShared != null && (ob = this._nonShared.get(key2)) != null) {
                if (ob == NULL_SURROGATE) {
                    return null;
                }
                return ob;
            }
            return this._shared.get(key2);
        }

        @Override
        public ContextAttributes withPerCallAttribute(Object key2, Object value2) {
            if (value2 == null) {
                if (this._shared.containsKey(key2)) {
                    value2 = NULL_SURROGATE;
                } else {
                    return this;
                }
            }
            if (this._nonShared == null) {
                return this.nonSharedInstance(key2, value2);
            }
            this._nonShared.put(key2, value2);
            return this;
        }

        protected ContextAttributes nonSharedInstance(Object key2, Object value2) {
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            if (value2 == null) {
                value2 = NULL_SURROGATE;
            }
            m.put(key2, value2);
            return new Impl(this._shared, m);
        }

        private Map<Object, Object> _copy(Map<Object, Object> src) {
            return new HashMap<Object, Object>(src);
        }
    }
}

