/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.stream;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.stream.ChunkedInput;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public class ChunkedFile
implements ChunkedInput<ByteBuf> {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedFile(File file2) throws IOException {
        this(file2, 8192);
    }

    public ChunkedFile(File file2, int chunkSize) throws IOException {
        this(new RandomAccessFile(file2, "r"), chunkSize);
    }

    public ChunkedFile(RandomAccessFile file2) throws IOException {
        this(file2, 8192);
    }

    public ChunkedFile(RandomAccessFile file2, int chunkSize) throws IOException {
        this(file2, 0L, file2.length(), chunkSize);
    }

    public ChunkedFile(RandomAccessFile file2, long offset2, long length2, int chunkSize) throws IOException {
        ObjectUtil.checkNotNull(file2, "file");
        ObjectUtil.checkPositiveOrZero(offset2, "offset");
        ObjectUtil.checkPositiveOrZero(length2, "length");
        ObjectUtil.checkPositive(chunkSize, "chunkSize");
        this.file = file2;
        this.offset = this.startOffset = offset2;
        this.endOffset = offset2 + length2;
        this.chunkSize = chunkSize;
        file2.seek(offset2);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset >= this.endOffset || !this.file.getChannel().isOpen();
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        long offset2 = this.offset;
        if (offset2 >= this.endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset2);
        ByteBuf buf = allocator.heapBuffer(chunkSize);
        boolean release = true;
        try {
            this.file.readFully(buf.array(), buf.arrayOffset(), chunkSize);
            buf.writerIndex(chunkSize);
            this.offset = offset2 + (long)chunkSize;
            release = false;
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
        finally {
            if (release) {
                buf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

