/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.util.ByteProcessor;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

@Deprecated
public class SwappedByteBuf
extends ByteBuf {
    private final ByteBuf buf;
    private final ByteOrder order;

    public SwappedByteBuf(ByteBuf buf) {
        this.buf = ObjectUtil.checkNotNull(buf, "buf");
        this.order = buf.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (ObjectUtil.checkNotNull(endianness, "endianness") == this.order) {
            return this;
        }
        return this.buf;
    }

    @Override
    public ByteBuf unwrap() {
        return this.buf;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.buf.capacity(newCapacity);
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.buf.maxCapacity();
    }

    @Override
    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buf.isDirect();
    }

    @Override
    public int readerIndex() {
        return this.buf.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int readerIndex) {
        this.buf.readerIndex(readerIndex);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buf.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int writerIndex) {
        this.buf.writerIndex(writerIndex);
        return this;
    }

    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        this.buf.setIndex(readerIndex, writerIndex);
        return this;
    }

    @Override
    public int readableBytes() {
        return this.buf.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.buf.writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    @Override
    public int maxFastWritableBytes() {
        return this.buf.maxFastWritableBytes();
    }

    @Override
    public boolean isReadable() {
        return this.buf.isReadable();
    }

    @Override
    public boolean isReadable(int size2) {
        return this.buf.isReadable(size2);
    }

    @Override
    public boolean isWritable() {
        return this.buf.isWritable();
    }

    @Override
    public boolean isWritable(int size2) {
        return this.buf.isWritable(size2);
    }

    @Override
    public ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.buf.markWriterIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.buf.discardReadBytes();
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int writableBytes) {
        this.buf.ensureWritable(writableBytes);
        return this;
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.buf.ensureWritable(minWritableBytes, force);
    }

    @Override
    public boolean getBoolean(int index2) {
        return this.buf.getBoolean(index2);
    }

    @Override
    public byte getByte(int index2) {
        return this.buf.getByte(index2);
    }

    @Override
    public short getUnsignedByte(int index2) {
        return this.buf.getUnsignedByte(index2);
    }

    @Override
    public short getShort(int index2) {
        return ByteBufUtil.swapShort(this.buf.getShort(index2));
    }

    @Override
    public short getShortLE(int index2) {
        return this.buf.getShort(index2);
    }

    @Override
    public int getUnsignedShort(int index2) {
        return this.getShort(index2) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int index2) {
        return this.getShortLE(index2) & 0xFFFF;
    }

    @Override
    public int getMedium(int index2) {
        return ByteBufUtil.swapMedium(this.buf.getMedium(index2));
    }

    @Override
    public int getMediumLE(int index2) {
        return this.buf.getMedium(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        return this.getMedium(index2) & 0xFFFFFF;
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        return this.getMediumLE(index2) & 0xFFFFFF;
    }

    @Override
    public int getInt(int index2) {
        return ByteBufUtil.swapInt(this.buf.getInt(index2));
    }

    @Override
    public int getIntLE(int index2) {
        return this.buf.getInt(index2);
    }

    @Override
    public long getUnsignedInt(int index2) {
        return (long)this.getInt(index2) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int index2) {
        return (long)this.getIntLE(index2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int index2) {
        return ByteBufUtil.swapLong(this.buf.getLong(index2));
    }

    @Override
    public long getLongLE(int index2) {
        return this.buf.getLong(index2);
    }

    @Override
    public char getChar(int index2) {
        return (char)this.getShort(index2);
    }

    @Override
    public float getFloat(int index2) {
        return Float.intBitsToFloat(this.getInt(index2));
    }

    @Override
    public double getDouble(int index2) {
        return Double.longBitsToDouble(this.getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst) {
        this.buf.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int length2) {
        this.buf.getBytes(index2, dst, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.buf.getBytes(index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst) {
        this.buf.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.buf.getBytes(index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.buf.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.buf.getBytes(index2, out, length2);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return this.buf.getBytes(index2, out, length2);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length2) throws IOException {
        return this.buf.getBytes(index2, out, position, length2);
    }

    @Override
    public CharSequence getCharSequence(int index2, int length2, Charset charset) {
        return this.buf.getCharSequence(index2, length2, charset);
    }

    @Override
    public ByteBuf setBoolean(int index2, boolean value2) {
        this.buf.setBoolean(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.buf.setByte(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.buf.setShort(index2, ByteBufUtil.swapShort((short)value2));
        return this;
    }

    @Override
    public ByteBuf setShortLE(int index2, int value2) {
        this.buf.setShort(index2, (short)value2);
        return this;
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.buf.setMedium(index2, ByteBufUtil.swapMedium(value2));
        return this;
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value2) {
        this.buf.setMedium(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.buf.setInt(index2, ByteBufUtil.swapInt(value2));
        return this;
    }

    @Override
    public ByteBuf setIntLE(int index2, int value2) {
        this.buf.setInt(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.buf.setLong(index2, ByteBufUtil.swapLong(value2));
        return this;
    }

    @Override
    public ByteBuf setLongLE(int index2, long value2) {
        this.buf.setLong(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setChar(int index2, int value2) {
        this.setShort(index2, value2);
        return this;
    }

    @Override
    public ByteBuf setFloat(int index2, float value2) {
        this.setInt(index2, Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public ByteBuf setDouble(int index2, double value2) {
        this.setLong(index2, Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src) {
        this.buf.setBytes(index2, src);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int length2) {
        this.buf.setBytes(index2, src, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.buf.setBytes(index2, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src) {
        this.buf.setBytes(index2, src);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.buf.setBytes(index2, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.buf.setBytes(index2, src);
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        return this.buf.setBytes(index2, in, length2);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        return this.buf.setBytes(index2, in, length2);
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length2) throws IOException {
        return this.buf.setBytes(index2, in, position, length2);
    }

    @Override
    public ByteBuf setZero(int index2, int length2) {
        this.buf.setZero(index2, length2);
        return this;
    }

    @Override
    public int setCharSequence(int index2, CharSequence sequence, Charset charset) {
        return this.buf.setCharSequence(index2, sequence, charset);
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return ByteBufUtil.swapShort(this.buf.readShort());
    }

    @Override
    public short readShortLE() {
        return this.buf.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        return ByteBufUtil.swapMedium(this.buf.readMedium());
    }

    @Override
    public int readMediumLE() {
        return this.buf.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        return this.readMedium() & 0xFFFFFF;
    }

    @Override
    public int readUnsignedMediumLE() {
        return this.readMediumLE() & 0xFFFFFF;
    }

    @Override
    public int readInt() {
        return ByteBufUtil.swapInt(this.buf.readInt());
    }

    @Override
    public int readIntLE() {
        return this.buf.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        return ByteBufUtil.swapLong(this.buf.readLong());
    }

    @Override
    public long readLongLE() {
        return this.buf.readLongLE();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int length2) {
        return this.buf.readBytes(length2).order(this.order());
    }

    @Override
    public ByteBuf readSlice(int length2) {
        return this.buf.readSlice(length2).order(this.order);
    }

    @Override
    public ByteBuf readRetainedSlice(int length2) {
        return this.buf.readRetainedSlice(length2).order(this.order);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        this.buf.readBytes(dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length2) {
        this.buf.readBytes(dst, length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length2) {
        this.buf.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.buf.readBytes(dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.buf.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        this.buf.readBytes(dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) throws IOException {
        this.buf.readBytes(out, length2);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        return this.buf.readBytes(out, length2);
    }

    @Override
    public int readBytes(FileChannel out, long position, int length2) throws IOException {
        return this.buf.readBytes(out, position, length2);
    }

    @Override
    public CharSequence readCharSequence(int length2, Charset charset) {
        return this.buf.readCharSequence(length2, charset);
    }

    @Override
    public ByteBuf skipBytes(int length2) {
        this.buf.skipBytes(length2);
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean value2) {
        this.buf.writeBoolean(value2);
        return this;
    }

    @Override
    public ByteBuf writeByte(int value2) {
        this.buf.writeByte(value2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int value2) {
        this.buf.writeShort(ByteBufUtil.swapShort((short)value2));
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int value2) {
        this.buf.writeShortLE((short)value2);
        return this;
    }

    @Override
    public ByteBuf writeMedium(int value2) {
        this.buf.writeMedium(ByteBufUtil.swapMedium(value2));
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int value2) {
        this.buf.writeMediumLE(value2);
        return this;
    }

    @Override
    public ByteBuf writeInt(int value2) {
        this.buf.writeInt(ByteBufUtil.swapInt(value2));
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int value2) {
        this.buf.writeIntLE(value2);
        return this;
    }

    @Override
    public ByteBuf writeLong(long value2) {
        this.buf.writeLong(ByteBufUtil.swapLong(value2));
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long value2) {
        this.buf.writeLongLE(value2);
        return this;
    }

    @Override
    public ByteBuf writeChar(int value2) {
        this.writeShort(value2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value2) {
        this.writeInt(Float.floatToRawIntBits(value2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value2) {
        this.writeLong(Double.doubleToRawLongBits(value2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        this.buf.writeBytes(src);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length2) {
        this.buf.writeBytes(src, length2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length2) {
        this.buf.writeBytes(src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        this.buf.writeBytes(src);
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length2) {
        this.buf.writeBytes(src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        this.buf.writeBytes(src);
        return this;
    }

    @Override
    public int writeBytes(InputStream in, int length2) throws IOException {
        return this.buf.writeBytes(in, length2);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length2) throws IOException {
        return this.buf.writeBytes(in, length2);
    }

    @Override
    public int writeBytes(FileChannel in, long position, int length2) throws IOException {
        return this.buf.writeBytes(in, position, length2);
    }

    @Override
    public ByteBuf writeZero(int length2) {
        this.buf.writeZero(length2);
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence sequence, Charset charset) {
        return this.buf.writeCharSequence(sequence, charset);
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        return this.buf.indexOf(fromIndex, toIndex, value2);
    }

    @Override
    public int bytesBefore(byte value2) {
        return this.buf.bytesBefore(value2);
    }

    @Override
    public int bytesBefore(int length2, byte value2) {
        return this.buf.bytesBefore(length2, value2);
    }

    @Override
    public int bytesBefore(int index2, int length2, byte value2) {
        return this.buf.bytesBefore(index2, length2, value2);
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        return this.buf.forEachByte(processor);
    }

    @Override
    public int forEachByte(int index2, int length2, ByteProcessor processor) {
        return this.buf.forEachByte(index2, length2, processor);
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        return this.buf.forEachByteDesc(processor);
    }

    @Override
    public int forEachByteDesc(int index2, int length2, ByteProcessor processor) {
        return this.buf.forEachByteDesc(index2, length2, processor);
    }

    @Override
    public ByteBuf copy() {
        return this.buf.copy().order(this.order);
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        return this.buf.copy(index2, length2).order(this.order);
    }

    @Override
    public ByteBuf slice() {
        return this.buf.slice().order(this.order);
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.buf.retainedSlice().order(this.order);
    }

    @Override
    public ByteBuf slice(int index2, int length2) {
        return this.buf.slice(index2, length2).order(this.order);
    }

    @Override
    public ByteBuf retainedSlice(int index2, int length2) {
        return this.buf.retainedSlice(index2, length2).order(this.order);
    }

    @Override
    public ByteBuf duplicate() {
        return this.buf.duplicate().order(this.order);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.buf.retainedDuplicate().order(this.order);
    }

    @Override
    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer().order(this.order);
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        return this.buf.nioBuffer(index2, length2).order(this.order);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        return this.nioBuffer(index2, length2);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        ByteBuffer[] nioBuffers = this.buf.nioBuffers();
        for (int i2 = 0; i2 < nioBuffers.length; ++i2) {
            nioBuffers[i2] = nioBuffers[i2].order(this.order);
        }
        return nioBuffers;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        ByteBuffer[] nioBuffers = this.buf.nioBuffers(index2, length2);
        for (int i2 = 0; i2 < nioBuffers.length; ++i2) {
            nioBuffers[i2] = nioBuffers[i2].order(this.order);
        }
        return nioBuffers;
    }

    @Override
    public boolean hasArray() {
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    @Override
    public boolean isContiguous() {
        return this.buf.isContiguous();
    }

    @Override
    public long memoryAddress() {
        return this.buf.memoryAddress();
    }

    @Override
    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    @Override
    public String toString(int index2, int length2, Charset charset) {
        return this.buf.toString(index2, length2, charset);
    }

    @Override
    public int refCnt() {
        return this.buf.refCnt();
    }

    @Override
    final boolean isAccessible() {
        return this.buf.isAccessible();
    }

    @Override
    public ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ByteBuf retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    @Override
    public ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        this.buf.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.buf.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.buf.release(decrement);
    }

    @Override
    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteBuf) {
            return ByteBufUtil.equals(this, (ByteBuf)obj);
        }
        return false;
    }

    @Override
    public int compareTo(ByteBuf buffer) {
        return ByteBufUtil.compare(this, buffer);
    }

    @Override
    public String toString() {
        return "Swapped(" + this.buf + ')';
    }
}

