/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class ReflectionUtils {
    private static long previousLogTime = 0L;
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public static <T> T instantiateWithCustomCtor(String className, Class<?>[] ctorArgTypes, Object[] ctorArgs) {
        try {
            Class<?> resultType = Class.forName(className);
            Constructor<?> ctor = resultType.getDeclaredConstructor(ctorArgTypes);
            return (T)ReflectionUtils.instantiate(className, ctor, ctorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + className, e);
        }
    }

    private static <T> T instantiate(String className, Constructor<T> ctor, Object[] ctorArgs) {
        try {
            ctor.setAccessible(true);
            return ctor.newInstance(ctorArgs);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> type2, Object ... params2) {
        return ReflectionUtils.instantiate(type2.getName(), ReflectionUtils.findConstructor(type2, params2), params2);
    }

    public static <T> Constructor<T> findConstructor(Class<T> type2, Object ... paramTypes) {
        Constructor<?>[] constructors2;
        for (Constructor<?> ctor : constructors2 = type2.getDeclaredConstructors()) {
            Class<?>[] ctorParamTypes = ctor.getParameterTypes();
            if (ctorParamTypes.length != paramTypes.length) continue;
            boolean match2 = true;
            for (int i2 = 0; i2 < ctorParamTypes.length && match2; ++i2) {
                Class<?> paramType = paramTypes[i2].getClass();
                match2 = !ctorParamTypes[i2].isPrimitive() ? ctorParamTypes[i2].isAssignableFrom(paramType) : Integer.TYPE.equals(ctorParamTypes[i2]) && Integer.class.equals(paramType) || Long.TYPE.equals(ctorParamTypes[i2]) && Long.class.equals(paramType) || Double.TYPE.equals(ctorParamTypes[i2]) && Double.class.equals(paramType) || Character.TYPE.equals(ctorParamTypes[i2]) && Character.class.equals(paramType) || Short.TYPE.equals(ctorParamTypes[i2]) && Short.class.equals(paramType) || Boolean.TYPE.equals(ctorParamTypes[i2]) && Boolean.class.equals(paramType) || Byte.TYPE.equals(ctorParamTypes[i2]) && Byte.class.equals(paramType);
            }
            if (!match2) continue;
            return ctor;
        }
        throw new UnsupportedOperationException("Unable to find suitable constructor for class " + type2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logThreadInfo(Logger log3, String title, long minInterval) {
        boolean dumpStack = false;
        if (!log3.isInfoEnabled()) return;
        Class<ReflectionUtils> clazz = ReflectionUtils.class;
        synchronized (ReflectionUtils.class) {
            long now = System.currentTimeMillis();
            if (now - previousLogTime >= minInterval * 1000L) {
                previousLogTime = now;
                dumpStack = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!dumpStack) return;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ReflectionUtils.printThreadInfo(new PrintStream((OutputStream)buffer, false, "UTF-8"), title);
                log3.info(buffer.toString(Charset.defaultCharset().name()));
                return;
            }
            catch (UnsupportedEncodingException ignored) {
                log3.warn("Could not write thread info about '" + title + "' due to a string encoding issue.");
            }
            return;
        }
    }

    private static void printThreadInfo(PrintStream stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ReflectionUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ReflectionUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    private static String getTaskName(long id2, String name2) {
        if (name2 == null) {
            return Long.toString(id2);
        }
        return id2 + " (" + name2 + ")";
    }

    @NonNull
    public static Object invokeMethod(Object obj, String methodName, Object ... params2) {
        try {
            Method m = obj.getClass().getMethod(methodName, ReflectionUtils.getParameterTypes(params2));
            m.setAccessible(true);
            return m.invoke(obj, params2);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Cannot find specified method " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified method " + methodName, e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("Illegal arguments supplied for method " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Method threw an exception for " + methodName, e);
        }
    }

    private static Class<?>[] getParameterTypes(Object[] params2) {
        Class[] parameterTypes = new Class[params2.length];
        for (int i2 = 0; i2 < params2.length; ++i2) {
            parameterTypes[i2] = params2[i2].getClass();
        }
        return parameterTypes;
    }
}

