/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class KeyStoreKeyProvider
implements KeyProvider {
    protected KeyStore store;
    protected char[] password;
    protected Properties passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processParameter(String name2, String value2) throws IOException {
        if (name2.equalsIgnoreCase("password")) {
            this.password = value2.toCharArray();
        }
        if (name2.equalsIgnoreCase("passwordfile")) {
            Properties p2 = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(value2)));){
                p2.load(in);
                this.passwordFile = p2;
            }
        }
    }

    protected void processParameters(URI uri) throws IOException {
        int valueEnd;
        String params2 = uri.getQuery();
        if (params2 == null || params2.isEmpty()) {
            return;
        }
        do {
            int nameStart = 0;
            int nameEnd = params2.indexOf(61);
            if (nameEnd == -1) {
                throw new RuntimeException("Invalid parameters: '" + params2 + "'");
            }
            int valueStart = nameEnd + 1;
            valueEnd = params2.indexOf(38);
            if (valueEnd == -1) {
                valueEnd = params2.length();
            }
            String name2 = URLDecoder.decode(params2.substring(nameStart, nameEnd), "UTF-8");
            String value2 = URLDecoder.decode(params2.substring(valueStart, valueEnd), "UTF-8");
            this.processParameter(name2, value2);
        } while (!(params2 = params2.substring(valueEnd, params2.length())).isEmpty());
    }

    protected void load(URI uri) throws IOException {
        String path2 = uri.getPath();
        if (path2 == null || path2.isEmpty()) {
            throw new RuntimeException("KeyProvider parameters should specify a path");
        }
        try (FileInputStream is = new FileInputStream(new File(path2));){
            this.store.load(is, this.password);
        }
    }

    @Override
    public void init(String params2) {
        try {
            URI uri = new URI(params2);
            String storeType = uri.getScheme();
            if (storeType == null || storeType.isEmpty()) {
                throw new RuntimeException("KeyProvider scheme should specify KeyStore type");
            }
            this.store = KeyStore.getInstance(storeType.toUpperCase(Locale.ROOT));
            this.processParameters(uri);
            this.load(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected char[] getAliasPassword(String alias2) {
        String p2;
        if (this.password != null) {
            return this.password;
        }
        if (this.passwordFile != null && (p2 = this.passwordFile.getProperty(alias2)) != null) {
            return p2.toCharArray();
        }
        return null;
    }

    @Override
    public Key getKey(String alias2) {
        try {
            return this.store.getKey(alias2, this.getAliasPassword(alias2));
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Key[] getKeys(String[] aliases2) {
        Key[] result2 = new Key[aliases2.length];
        for (int i2 = 0; i2 < aliases2.length; ++i2) {
            result2[i2] = this.getKey(aliases2[i2]);
        }
        return result2;
    }
}

