/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RegionStatesCount {
    private int openRegions;
    private int splitRegions;
    private int closedRegions;
    private int regionsInTransition;
    private int totalRegions;

    private RegionStatesCount() {
    }

    public int getClosedRegions() {
        return this.closedRegions;
    }

    public int getOpenRegions() {
        return this.openRegions;
    }

    public int getSplitRegions() {
        return this.splitRegions;
    }

    public int getRegionsInTransition() {
        return this.regionsInTransition;
    }

    public int getTotalRegions() {
        return this.totalRegions;
    }

    private void setClosedRegions(int closedRegions) {
        this.closedRegions = closedRegions;
    }

    private void setOpenRegions(int openRegions) {
        this.openRegions = openRegions;
    }

    private void setSplitRegions(int splitRegions) {
        this.splitRegions = splitRegions;
    }

    private void setRegionsInTransition(int regionsInTransition) {
        this.regionsInTransition = regionsInTransition;
    }

    private void setTotalRegions(int totalRegions) {
        this.totalRegions = totalRegions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RegionStatesCount{");
        sb.append("openRegions=").append(this.openRegions);
        sb.append(", splitRegions=").append(this.splitRegions);
        sb.append(", closedRegions=").append(this.closedRegions);
        sb.append(", regionsInTransition=").append(this.regionsInTransition);
        sb.append(", totalRegions=").append(this.totalRegions);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionStatesCount that = (RegionStatesCount)o;
        if (this.openRegions != that.openRegions) {
            return false;
        }
        if (this.splitRegions != that.splitRegions) {
            return false;
        }
        if (this.closedRegions != that.closedRegions) {
            return false;
        }
        if (this.regionsInTransition != that.regionsInTransition) {
            return false;
        }
        return this.totalRegions == that.totalRegions;
    }

    public int hashCode() {
        int result2 = this.openRegions;
        result2 = 31 * result2 + this.splitRegions;
        result2 = 31 * result2 + this.closedRegions;
        result2 = 31 * result2 + this.regionsInTransition;
        result2 = 31 * result2 + this.totalRegions;
        return result2;
    }

    public static class RegionStatesCountBuilder {
        private int openRegions;
        private int splitRegions;
        private int closedRegions;
        private int regionsInTransition;
        private int totalRegions;

        public RegionStatesCountBuilder setOpenRegions(int openRegions) {
            this.openRegions = openRegions;
            return this;
        }

        public RegionStatesCountBuilder setSplitRegions(int splitRegions) {
            this.splitRegions = splitRegions;
            return this;
        }

        public RegionStatesCountBuilder setClosedRegions(int closedRegions) {
            this.closedRegions = closedRegions;
            return this;
        }

        public RegionStatesCountBuilder setRegionsInTransition(int regionsInTransition) {
            this.regionsInTransition = regionsInTransition;
            return this;
        }

        public RegionStatesCountBuilder setTotalRegions(int totalRegions) {
            this.totalRegions = totalRegions;
            return this;
        }

        public RegionStatesCount build() {
            RegionStatesCount regionStatesCount = new RegionStatesCount();
            regionStatesCount.setOpenRegions(this.openRegions);
            regionStatesCount.setClosedRegions(this.closedRegions);
            regionStatesCount.setRegionsInTransition(this.regionsInTransition);
            regionStatesCount.setSplitRegions(this.splitRegions);
            regionStatesCount.setTotalRegions(this.totalRegions);
            return regionStatesCount;
        }
    }
}

