/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferKeyValue
extends ByteBufferExtendedCell {
    protected final ByteBuffer buf;
    protected final int offset;
    protected final int length;
    private long seqId = 0L;
    public static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 8 + 8;

    public ByteBufferKeyValue(ByteBuffer buf, int offset2, int length2, long seqId) {
        this.buf = buf;
        this.offset = offset2;
        this.length = length2;
        this.seqId = seqId;
    }

    public ByteBufferKeyValue(ByteBuffer buf, int offset2, int length2) {
        this.buf = buf;
        this.offset = offset2;
        this.length = length2;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public byte[] getRowArray() {
        return CellUtil.cloneRow(this);
    }

    @Override
    public int getRowOffset() {
        return 0;
    }

    @Override
    public short getRowLength() {
        return ByteBufferUtils.toShort(this.buf, this.offset + 8);
    }

    @Override
    public byte[] getFamilyArray() {
        return CellUtil.cloneFamily(this);
    }

    @Override
    public int getFamilyOffset() {
        return 0;
    }

    @Override
    public byte getFamilyLength() {
        return this.getFamilyLength(this.getFamilyLengthPosition());
    }

    int getFamilyLengthPosition() {
        return this.getFamilyLengthPosition(this.getRowLength());
    }

    int getFamilyLengthPosition(int rowLength) {
        return this.offset + 10 + rowLength;
    }

    byte getFamilyLength(int famLenPos) {
        return ByteBufferUtils.toByte(this.buf, famLenPos);
    }

    @Override
    public byte[] getQualifierArray() {
        return CellUtil.cloneQualifier(this);
    }

    @Override
    public int getQualifierOffset() {
        return 0;
    }

    @Override
    public int getQualifierLength() {
        return this.getQualifierLength(this.getKeyLength(), this.getRowLength(), this.getFamilyLength());
    }

    int getQualifierLength(int keyLength, int rlength, int flength) {
        return keyLength - (int)KeyValue.getKeyDataStructureSize(rlength, flength, 0);
    }

    @Override
    public long getTimestamp() {
        return this.getTimestamp(this.getKeyLength());
    }

    long getTimestamp(int keyLength) {
        int offset2 = this.getTimestampOffset(keyLength);
        return ByteBufferUtils.toLong(this.buf, offset2);
    }

    int getKeyLength() {
        return ByteBufferUtils.toInt(this.buf, this.offset);
    }

    private int getTimestampOffset(int keyLen) {
        return this.offset + 8 + keyLen - 9;
    }

    @Override
    public byte getTypeByte() {
        return this.getTypeByte(this.getKeyLength());
    }

    byte getTypeByte(int keyLen) {
        return ByteBufferUtils.toByte(this.buf, this.offset + keyLen - 1 + 8);
    }

    @Override
    public long getSequenceId() {
        return this.seqId;
    }

    @Override
    public void setSequenceId(long seqId) {
        this.seqId = seqId;
    }

    @Override
    public byte[] getValueArray() {
        return CellUtil.cloneValue(this);
    }

    @Override
    public int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return ByteBufferUtils.toInt(this.buf, this.offset + 4);
    }

    @Override
    public byte[] getTagsArray() {
        return CellUtil.cloneTags(this);
    }

    @Override
    public int getTagsOffset() {
        return 0;
    }

    @Override
    public int getTagsLength() {
        int tagsLen = this.length - (this.getKeyLength() + this.getValueLength() + 8);
        if (tagsLen > 0) {
            tagsLen -= 2;
        }
        return tagsLen;
    }

    @Override
    public ByteBuffer getRowByteBuffer() {
        return this.buf;
    }

    @Override
    public int getRowPosition() {
        return this.offset + 10;
    }

    @Override
    public ByteBuffer getFamilyByteBuffer() {
        return this.buf;
    }

    @Override
    public int getFamilyPosition() {
        return this.getFamilyPosition(this.getFamilyLengthPosition());
    }

    public int getFamilyPosition(int familyLengthPosition) {
        return familyLengthPosition + 1;
    }

    @Override
    public ByteBuffer getQualifierByteBuffer() {
        return this.buf;
    }

    @Override
    public int getQualifierPosition() {
        return this.getQualifierPosition(this.getFamilyPosition(), this.getFamilyLength());
    }

    int getQualifierPosition(int familyPosition, int familyLength) {
        return familyPosition + familyLength;
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        return this.buf;
    }

    @Override
    public int getValuePosition() {
        return this.offset + 8 + this.getKeyLength();
    }

    @Override
    public ByteBuffer getTagsByteBuffer() {
        return this.buf;
    }

    @Override
    public int getTagsPosition() {
        int tagsLen = this.getTagsLength();
        if (tagsLen == 0) {
            return this.offset + this.length;
        }
        return this.offset + this.length - tagsLen;
    }

    @Override
    public long heapSize() {
        if (this.buf.hasArray()) {
            return ClassSize.align(FIXED_OVERHEAD + this.length);
        }
        return ClassSize.align(FIXED_OVERHEAD) + this.getSerializedSize();
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        int length2 = this.getSerializedSize(withTags);
        ByteBufferUtils.copyBufferToStream(out, this.buf, this.offset, length2);
        return length2;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        if (withTags) {
            return this.length;
        }
        return this.getKeyLength() + this.getValueLength() + 8;
    }

    @Override
    public int getSerializedSize() {
        return this.length;
    }

    @Override
    public void write(ByteBuffer buf, int offset2) {
        ByteBufferUtils.copyFromBufferToBuffer(this.buf, buf, this.offset, offset2, this.length);
    }

    public String toString() {
        return CellUtil.toString(this, true);
    }

    @Override
    public void setTimestamp(long ts) throws IOException {
        ByteBufferUtils.copyFromArrayToBuffer(this.buf, this.getTimestampOffset(), Bytes.toBytes(ts), 0, 8);
    }

    private int getTimestampOffset() {
        return this.offset + 8 + this.getKeyLength() - 9;
    }

    @Override
    public void setTimestamp(byte[] ts) throws IOException {
        ByteBufferUtils.copyFromArrayToBuffer(this.buf, this.getTimestampOffset(), ts, 0, 8);
    }

    @Override
    public ExtendedCell deepClone() {
        byte[] copy = new byte[this.length];
        ByteBufferUtils.copyFromBufferToArray(copy, this.buf, this.offset, 0, this.length);
        KeyValue kv = new KeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Cell)) {
            return false;
        }
        return CellUtil.equals(this, (Cell)other);
    }

    public int hashCode() {
        return this.calculateHashForKey(this);
    }

    private int calculateHashForKey(ByteBufferExtendedCell cell) {
        int rowHash = ByteBufferUtils.hashCode(cell.getRowByteBuffer(), cell.getRowPosition(), cell.getRowLength());
        int familyHash = ByteBufferUtils.hashCode(cell.getFamilyByteBuffer(), cell.getFamilyPosition(), cell.getFamilyLength());
        int qualifierHash = ByteBufferUtils.hashCode(cell.getQualifierByteBuffer(), cell.getQualifierPosition(), cell.getQualifierLength());
        int hash2 = 31 * rowHash + familyHash;
        hash2 = 31 * hash2 + qualifierHash;
        hash2 = 31 * hash2 + (int)cell.getTimestamp();
        hash2 = 31 * hash2 + cell.getTypeByte();
        return hash2;
    }
}

