/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

public class PathUtils {
    public static void validatePath(String path2, boolean isSequential) throws IllegalArgumentException {
        PathUtils.validatePath(isSequential ? path2 + "1" : path2);
    }

    public static String validatePath(String path2) throws IllegalArgumentException {
        if (path2 == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path2.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path2.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path2.length() == 1) {
            return path2;
        }
        if (path2.charAt(path2.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason2 = null;
        int lastc = 47;
        char[] chars2 = path2.toCharArray();
        for (int i2 = 1; i2 < chars2.length; ++i2) {
            char c = chars2[i2];
            if (c == '\u0000') {
                reason2 = "null character not allowed @" + i2;
                break;
            }
            if (c == '/' && lastc == 47) {
                reason2 = "empty node name specified @" + i2;
                break;
            }
            if (c == '.' && lastc == 46) {
                if (chars2[i2 - 2] == '/' && (i2 + 1 == chars2.length || chars2[i2 + 1] == '/')) {
                    reason2 = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c == '.') {
                if (chars2[i2 - 1] == '/' && (i2 + 1 == chars2.length || chars2[i2 + 1] == '/')) {
                    reason2 = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') {
                reason2 = "invalid charater @" + i2;
                break;
            }
            lastc = chars2[i2];
        }
        if (reason2 != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path2 + "\" caused by " + reason2);
        }
        return path2;
    }
}

