/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.curator.framework.api.CompressionProvider;

public class GzipCompressionProvider
implements CompressionProvider {
    @Override
    public byte[] compress(String path2, byte[] data) throws Exception {
        ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bytes2);
        out.write(data);
        out.finish();
        return bytes2.toByteArray();
    }

    @Override
    public byte[] decompress(String path2, byte[] compressedData) throws Exception {
        int bytesRead;
        ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(compressedData.length);
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressedData));
        byte[] buffer = new byte[compressedData.length];
        while ((bytesRead = in.read(buffer, 0, buffer.length)) >= 0) {
            bytes2.write(buffer, 0, bytesRead);
        }
        return bytes2.toByteArray();
    }
}

