/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    ByteBuffer buffer;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;

    public UnpooledDirectByteBuf(ByteBufAllocator alloc2, int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc2, "alloc");
        ObjectUtil.checkPositiveOrZero(initialCapacity, "initialCapacity");
        ObjectUtil.checkPositiveOrZero(maxCapacity, "maxCapacity");
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.alloc = alloc2;
        this.setByteBuffer(this.allocateDirect(initialCapacity), false);
    }

    protected UnpooledDirectByteBuf(ByteBufAllocator alloc2, ByteBuffer initialBuffer, int maxCapacity) {
        this(alloc2, initialBuffer, maxCapacity, false, true);
    }

    UnpooledDirectByteBuf(ByteBufAllocator alloc2, ByteBuffer initialBuffer, int maxCapacity, boolean doFree, boolean slice) {
        super(maxCapacity);
        ObjectUtil.checkNotNull(alloc2, "alloc");
        ObjectUtil.checkNotNull(initialBuffer, "initialBuffer");
        if (!initialBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (initialBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int initialCapacity = initialBuffer.remaining();
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", initialCapacity, maxCapacity));
        }
        this.alloc = alloc2;
        this.doNotFree = !doFree;
        this.setByteBuffer((slice ? initialBuffer.slice() : initialBuffer).order(ByteOrder.BIG_ENDIAN), false);
        this.writerIndex(initialCapacity);
    }

    protected ByteBuffer allocateDirect(int initialCapacity) {
        return ByteBuffer.allocateDirect(initialCapacity);
    }

    protected void freeDirect(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer(buffer);
    }

    void setByteBuffer(ByteBuffer buffer, boolean tryFree) {
        ByteBuffer oldBuffer;
        if (tryFree && (oldBuffer = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(oldBuffer);
            }
        }
        this.buffer = buffer;
        this.tmpNioBuf = null;
        this.capacity = buffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        int bytesToCopy;
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.capacity;
        if (newCapacity == oldCapacity) {
            return this;
        }
        if (newCapacity > oldCapacity) {
            bytesToCopy = oldCapacity;
        } else {
            this.trimIndicesToCapacity(newCapacity);
            bytesToCopy = newCapacity;
        }
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = this.allocateDirect(newCapacity);
        oldBuffer.position(0).limit(bytesToCopy);
        newBuffer.position(0).limit(bytesToCopy);
        newBuffer.put(oldBuffer).clear();
        this.setByteBuffer(newBuffer, true);
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int index2) {
        this.ensureAccessible();
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.buffer.get(index2);
    }

    @Override
    public short getShort(int index2) {
        this.ensureAccessible();
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return (this.getByte(index2) & 0xFF) << 16 | (this.getByte(index2 + 1) & 0xFF) << 8 | this.getByte(index2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.getByte(index2) & 0xFF | (this.getByte(index2 + 1) & 0xFF) << 8 | (this.getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index2) {
        this.ensureAccessible();
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(index2));
    }

    @Override
    public long getLong(int index2) {
        this.ensureAccessible();
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return ByteBufUtil.swapLong(this.buffer.getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length2)) {
                int bbLen = bb.remaining();
                this.getBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.getBytes(index2, dst, dstIndex, length2, false);
        return this;
    }

    void getBytes(int index2, byte[] dst, int dstIndex, int length2, boolean internal) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        tmpBuf.get(dst, dstIndex, length2);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.getBytes(index2, dst, false);
        return this;
    }

    void getBytes(int index2, ByteBuffer dst, boolean internal) {
        this.checkIndex(index2, dst.remaining());
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index2).limit(index2 + dst.remaining());
        dst.put(tmpBuf);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.ensureAccessible();
        this._setByte(index2, value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        this.buffer.put(index2, (byte)value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.ensureAccessible();
        this._setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        this.buffer.putShort(index2, (short)value2);
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        this.buffer.putShort(index2, ByteBufUtil.swapShort((short)value2));
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.ensureAccessible();
        this._setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        this.setByte(index2, (byte)(value2 >>> 16));
        this.setByte(index2 + 1, (byte)(value2 >>> 8));
        this.setByte(index2 + 2, (byte)value2);
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        this.setByte(index2, (byte)value2);
        this.setByte(index2 + 1, (byte)(value2 >>> 8));
        this.setByte(index2 + 2, (byte)(value2 >>> 16));
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.ensureAccessible();
        this._setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        this.buffer.putInt(index2, value2);
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        this.buffer.putInt(index2, ByteBufUtil.swapInt(value2));
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.ensureAccessible();
        this._setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        this.buffer.putLong(index2, value2);
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        this.buffer.putLong(index2, ByteBufUtil.swapLong(value2));
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length2)) {
                int bbLen = bb.remaining();
                this.setBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            src.getBytes(srcIndex, this, index2, length2);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        tmpBuf.put(src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        tmpBuf.clear().position(index2).limit(index2 + src.remaining());
        tmpBuf.put(src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.getBytes(index2, out, length2, false);
        return this;
    }

    void getBytes(int index2, OutputStream out, int length2, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length2 == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), internal ? this.internalNioBuffer() : this.buffer.duplicate(), index2, length2, out);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return this.getBytes(index2, out, length2, false);
    }

    private int getBytes(int index2, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length2) throws IOException {
        return this.getBytes(index2, out, position, length2, false);
    }

    private int getBytes(int index2, FileChannel out, long position, int length2, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : this.buffer.duplicate();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        return out.write(tmpBuf, position);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int readBytes(FileChannel out, long position, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, position, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        this.ensureAccessible();
        if (this.buffer.hasArray()) {
            return in.read(this.buffer.array(), this.buffer.arrayOffset() + index2, length2);
        }
        byte[] tmp = ByteBufUtil.threadLocalTempArray(length2);
        int readBytes = in.read(tmp, 0, length2);
        if (readBytes <= 0) {
            return readBytes;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2);
        tmpBuf.put(tmp, 0, readBytes);
        return readBytes;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        try {
            return in.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length2) throws IOException {
        this.ensureAccessible();
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + length2);
        try {
            return in.read(tmpBuf, position);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index2, length2)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        ByteBuffer src;
        this.ensureAccessible();
        try {
            src = (ByteBuffer)this.buffer.duplicate().clear().position(index2).limit(index2 + length2);
        }
        catch (IllegalArgumentException ignored) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + length2));
        }
        return this.alloc().directBuffer(length2, this.maxCapacity()).writeBytes(src);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length2);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.buffer.duplicate();
        }
        return tmpNioBuf;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return ((ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length2)).slice();
    }

    @Override
    protected void deallocate() {
        ByteBuffer buffer = this.buffer;
        if (buffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(buffer);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

