/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodedInputStream {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    private static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    private static final int BUFFER_SIZE = 4096;

    public static CodedInputStream newInstance(InputStream input) {
        return new CodedInputStream(input);
    }

    public static CodedInputStream newInstance(byte[] buf) {
        return CodedInputStream.newInstance(buf, 0, buf.length);
    }

    public static CodedInputStream newInstance(byte[] buf, int off, int len) {
        CodedInputStream result2 = new CodedInputStream(buf, off, len);
        try {
            result2.pushLimit(len);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException(ex);
        }
        return result2;
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int value2) throws InvalidProtocolBufferException {
        if (this.lastTag != value2) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public boolean skipField(int tag2) throws IOException {
        switch (WireFormat.getTagWireType(tag2)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag2), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag2;
        while ((tag2 = this.readTag()) != 0 && this.skipField(tag2)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public String readString() throws IOException {
        int size2 = this.readRawVarint32();
        if (size2 <= this.bufferSize - this.bufferPos && size2 > 0) {
            String result2 = new String(this.buffer, this.bufferPos, size2, "UTF-8");
            this.bufferPos += size2;
            return result2;
        }
        return new String(this.readRawBytes(size2), "UTF-8");
    }

    public void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistry);
        this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
        --this.recursionDepth;
    }

    public <T extends MessageLite> T readGroup(int fieldNumber, Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite result2 = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
        this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
        --this.recursionDepth;
        return (T)result2;
    }

    @Deprecated
    public void readUnknownGroup(int fieldNumber, MessageLite.Builder builder) throws IOException {
        this.readGroup(fieldNumber, builder, null);
    }

    public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
        int length2 = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length2);
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistry);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(oldLimit);
    }

    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
        int length2 = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length2);
        ++this.recursionDepth;
        MessageLite result2 = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(oldLimit);
        return (T)result2;
    }

    public ByteString readBytes() throws IOException {
        int size2 = this.readRawVarint32();
        if (size2 == 0) {
            return ByteString.EMPTY;
        }
        if (size2 <= this.bufferSize - this.bufferPos && size2 > 0) {
            ByteString result2 = ByteString.copyFrom(this.buffer, this.bufferPos, size2);
            this.bufferPos += size2;
            return result2;
        }
        return ByteString.copyFrom(this.readRawBytes(size2));
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() throws IOException {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.readRawByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result2 = tmp & 0x7F;
        tmp = this.readRawByte();
        if (tmp >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            tmp = this.readRawByte();
            if (tmp >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                tmp = this.readRawByte();
                if (tmp >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    tmp = this.readRawByte();
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        for (int i2 = 0; i2 < 5; ++i2) {
                            if (this.readRawByte() < 0) continue;
                            return result2;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                }
            }
        }
        return result2;
    }

    static int readRawVarint32(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(firstByte, input);
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int b;
        int offset2;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int result2 = firstByte & 0x7F;
        for (offset2 = 7; offset2 < 32; offset2 += 7) {
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            result2 |= (b & 0x7F) << offset2;
            if ((b & 0x80) != 0) continue;
            return result2;
        }
        while (offset2 < 64) {
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((b & 0x80) == 0) {
                return result2;
            }
            offset2 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public long readRawVarint64() throws IOException {
        long result2 = 0L;
        for (int shift2 = 0; shift2 < 64; shift2 += 7) {
            byte b = this.readRawByte();
            result2 |= (long)(b & 0x7F) << shift2;
            if ((b & 0x80) != 0) continue;
            return result2;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private CodedInputStream(byte[] buffer, int off, int len) {
        this.buffer = buffer;
        this.bufferSize = off + len;
        this.bufferPos = off;
        this.totalBytesRetired = -off;
        this.input = null;
    }

    private CodedInputStream(InputStream input) {
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        this.input = input;
    }

    public int setRecursionLimit(int limit2) {
        if (limit2 < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + limit2);
        }
        int oldLimit = this.recursionLimit;
        this.recursionLimit = limit2;
        return oldLimit;
    }

    public int setSizeLimit(int limit2) {
        if (limit2 < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + limit2);
        }
        int oldLimit = this.sizeLimit;
        this.sizeLimit = limit2;
        return oldLimit;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }

    public int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
        if (byteLimit < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit += this.totalBytesRetired + this.bufferPos) > oldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = byteLimit;
        this.recomputeBufferSizeAfterLimit();
        return oldLimit;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - currentAbsolutePosition;
    }

    public boolean isAtEnd() throws IOException {
        return this.bufferPos == this.bufferSize && !this.refillBuffer(false);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    private boolean refillBuffer(boolean mustSucceed) throws IOException {
        if (this.bufferPos < this.bufferSize) {
            throw new IllegalStateException("refillBuffer() called when buffer wasn't empty.");
        }
        if (this.totalBytesRetired + this.bufferSize == this.currentLimit) {
            if (mustSucceed) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        int n = this.bufferSize = this.input == null ? -1 : this.input.read(this.buffer);
        if (this.bufferSize == 0 || this.bufferSize < -1) {
            throw new IllegalStateException("InputStream#read(byte[]) returned invalid result: " + this.bufferSize + "\nThe InputStream implementation is buggy.");
        }
        if (this.bufferSize == -1) {
            this.bufferSize = 0;
            if (mustSucceed) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.recomputeBufferSizeAfterLimit();
        int totalBytesRead = this.totalBytesRetired + this.bufferSize + this.bufferSizeAfterLimit;
        if (totalBytesRead > this.sizeLimit || totalBytesRead < 0) {
            throw InvalidProtocolBufferException.sizeLimitExceeded();
        }
        return true;
    }

    public byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(true);
        }
        return this.buffer[this.bufferPos++];
    }

    public byte[] readRawBytes(int size2) throws IOException {
        int pos2;
        byte[] chunk2;
        if (size2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (size2 <= this.bufferSize - this.bufferPos) {
            byte[] bytes2 = new byte[size2];
            System.arraycopy(this.buffer, this.bufferPos, bytes2, 0, size2);
            this.bufferPos += size2;
            return bytes2;
        }
        if (size2 < 4096) {
            byte[] bytes3 = new byte[size2];
            int pos3 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, bytes3, 0, pos3);
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (size2 - pos3 > this.bufferSize) {
                System.arraycopy(this.buffer, 0, bytes3, pos3, this.bufferSize);
                pos3 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            System.arraycopy(this.buffer, 0, bytes3, pos3, size2 - pos3);
            this.bufferPos = size2 - pos3;
            return bytes3;
        }
        int originalBufferPos = this.bufferPos;
        int originalBufferSize = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int sizeLeft = size2 - (originalBufferSize - originalBufferPos); sizeLeft > 0; sizeLeft -= chunk2.length) {
            int n;
            chunk2 = new byte[Math.min(sizeLeft, 4096)];
            for (pos2 = 0; pos2 < chunk2.length; pos2 += n) {
                int n2 = n = this.input == null ? -1 : this.input.read(chunk2, pos2, chunk2.length - pos2);
                if (n == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n;
            }
            chunks.add(chunk2);
        }
        byte[] bytes4 = new byte[size2];
        pos2 = originalBufferSize - originalBufferPos;
        System.arraycopy(this.buffer, originalBufferPos, bytes4, 0, pos2);
        for (byte[] chunk3 : chunks) {
            System.arraycopy(chunk3, 0, bytes4, pos2, chunk3.length);
            pos2 += chunk3.length;
        }
        return bytes4;
    }

    public void skipRawBytes(int size2) throws IOException {
        if (size2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (size2 <= this.bufferSize - this.bufferPos) {
            this.bufferPos += size2;
        } else {
            int pos2 = this.bufferSize - this.bufferPos;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (size2 - pos2 > this.bufferSize) {
                pos2 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            this.bufferPos = size2 - pos2;
        }
    }
}

