/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.protocol;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.zeppelin.cluster.protocol.RaftMessagingProtocol;

public class RaftServerMessagingProtocol
extends RaftMessagingProtocol
implements RaftServerProtocol {
    public RaftServerMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<MemberId, Address> addressProvider) {
        super(messagingService, serializer, addressProvider);
    }

    public CompletableFuture<OpenSessionResponse> openSession(MemberId memberId, OpenSessionRequest request) {
        return this.sendAndReceive(memberId, "open-session", request);
    }

    public CompletableFuture<CloseSessionResponse> closeSession(MemberId memberId, CloseSessionRequest request) {
        return this.sendAndReceive(memberId, "close-session", request);
    }

    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId memberId, KeepAliveRequest request) {
        return this.sendAndReceive(memberId, "keep-alive", request);
    }

    public CompletableFuture<QueryResponse> query(MemberId memberId, QueryRequest request) {
        return this.sendAndReceive(memberId, "query", request);
    }

    public CompletableFuture<CommandResponse> command(MemberId memberId, CommandRequest request) {
        return this.sendAndReceive(memberId, "command", request);
    }

    public CompletableFuture<MetadataResponse> metadata(MemberId memberId, MetadataRequest request) {
        return this.sendAndReceive(memberId, "metadata", request);
    }

    public CompletableFuture<JoinResponse> join(MemberId memberId, JoinRequest request) {
        return this.sendAndReceive(memberId, "join", request);
    }

    public CompletableFuture<LeaveResponse> leave(MemberId memberId, LeaveRequest request) {
        return this.sendAndReceive(memberId, "leave", request);
    }

    public CompletableFuture<ConfigureResponse> configure(MemberId memberId, ConfigureRequest request) {
        return this.sendAndReceive(memberId, "configure", request);
    }

    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId memberId, ReconfigureRequest request) {
        return this.sendAndReceive(memberId, "reconfigure", request);
    }

    public CompletableFuture<InstallResponse> install(MemberId memberId, InstallRequest request) {
        return this.sendAndReceive(memberId, "install", request);
    }

    public CompletableFuture<TransferResponse> transfer(MemberId memberId, TransferRequest request) {
        return this.sendAndReceive(memberId, "transfer", request);
    }

    public CompletableFuture<PollResponse> poll(MemberId memberId, PollRequest request) {
        return this.sendAndReceive(memberId, "poll", request);
    }

    public CompletableFuture<VoteResponse> vote(MemberId memberId, VoteRequest request) {
        return this.sendAndReceive(memberId, "vote", request);
    }

    public CompletableFuture<AppendResponse> append(MemberId memberId, AppendRequest request) {
        return this.sendAndReceive(memberId, "append", request);
    }

    public void publish(MemberId memberId, PublishRequest request) {
        this.sendAsync(memberId, String.format("publish-%d", request.session()), request);
    }

    public CompletableFuture<HeartbeatResponse> heartbeat(MemberId memberId, HeartbeatRequest request) {
        return this.sendAndReceive(memberId, "heartbeat", request);
    }

    public void registerOpenSessionHandler(Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> handler) {
        this.registerHandler("open-session", handler);
    }

    public void unregisterOpenSessionHandler() {
        this.unregisterHandler("open-session");
    }

    public void registerCloseSessionHandler(Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> handler) {
        this.registerHandler("close-session", handler);
    }

    public void unregisterCloseSessionHandler() {
        this.unregisterHandler("close-session");
    }

    public void registerKeepAliveHandler(Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> handler) {
        this.registerHandler("keep-alive", handler);
    }

    public void unregisterKeepAliveHandler() {
        this.unregisterHandler("keep-alive");
    }

    public void registerQueryHandler(Function<QueryRequest, CompletableFuture<QueryResponse>> handler) {
        this.registerHandler("query", handler);
    }

    public void unregisterQueryHandler() {
        this.unregisterHandler("query");
    }

    public void registerCommandHandler(Function<CommandRequest, CompletableFuture<CommandResponse>> handler) {
        this.registerHandler("command", handler);
    }

    public void unregisterCommandHandler() {
        this.unregisterHandler("command");
    }

    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> handler) {
        this.registerHandler("metadata", handler);
    }

    public void unregisterMetadataHandler() {
        this.unregisterHandler("metadata");
    }

    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.registerHandler("join", handler);
    }

    public void unregisterJoinHandler() {
        this.unregisterHandler("join");
    }

    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.registerHandler("leave", handler);
    }

    public void unregisterLeaveHandler() {
        this.unregisterHandler("leave");
    }

    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.registerHandler("configure", handler);
    }

    public void unregisterConfigureHandler() {
        this.unregisterHandler("configure");
    }

    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.registerHandler("reconfigure", handler);
    }

    public void unregisterReconfigureHandler() {
        this.unregisterHandler("reconfigure");
    }

    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.registerHandler("install", handler);
    }

    public void unregisterInstallHandler() {
        this.unregisterHandler("install");
    }

    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.registerHandler("transfer", handler);
    }

    public void unregisterTransferHandler() {
        this.unregisterHandler("transfer");
    }

    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.registerHandler("poll", handler);
    }

    public void unregisterPollHandler() {
        this.unregisterHandler("poll");
    }

    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.registerHandler("vote", handler);
    }

    public void unregisterVoteHandler() {
        this.unregisterHandler("vote");
    }

    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.registerHandler("append", handler);
    }

    public void unregisterAppendHandler() {
        this.unregisterHandler("append");
    }

    public void registerResetListener(SessionId sessionId, Consumer<ResetRequest> listener, Executor executor) {
        this.messagingService.registerHandler(String.format("reset-%d", sessionId.id()), (e, p) -> listener.accept((ResetRequest)this.serializer.decode(p)), executor);
    }

    public void unregisterResetListener(SessionId sessionId) {
        this.messagingService.unregisterHandler(String.format("reset-%d", sessionId.id()));
    }
}

