/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileAttributes;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;
import org.apache.commons.vfs2.provider.hdfs.HdfsRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileObject
extends AbstractFileObject<HdfsFileSystem> {
    private final HdfsFileSystem fs;
    private final FileSystem hdfs;
    private final Path path;
    private FileStatus stat;

    protected HdfsFileObject(AbstractFileName name, HdfsFileSystem fs, FileSystem hdfs, Path p) {
        super(name, fs);
        this.fs = fs;
        this.hdfs = hdfs;
        this.path = p;
    }

    @Override
    public boolean canRenameTo(FileObject newfile) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doAttach() throws Exception {
        try {
            this.stat = this.hdfs.getFileStatus(this.path);
        }
        catch (FileNotFoundException e) {
            this.stat = null;
            return;
        }
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        if (null == this.stat) {
            return super.doGetAttributes();
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(HdfsFileAttributes.LAST_ACCESS_TIME.toString(), this.stat.getAccessTime());
        attrs.put(HdfsFileAttributes.BLOCK_SIZE.toString(), this.stat.getBlockSize());
        attrs.put(HdfsFileAttributes.GROUP.toString(), this.stat.getGroup());
        attrs.put(HdfsFileAttributes.OWNER.toString(), this.stat.getOwner());
        attrs.put(HdfsFileAttributes.PERMISSIONS.toString(), this.stat.getPermission().toString());
        attrs.put(HdfsFileAttributes.LENGTH.toString(), this.stat.getLen());
        attrs.put(HdfsFileAttributes.MODIFICATION_TIME.toString(), this.stat.getModificationTime());
        return attrs;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.stat.getLen();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return this.hdfs.open(this.path, bufferSize);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (null != this.stat) {
            return this.stat.getModificationTime();
        }
        return -1L;
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        if (mode.equals((Object)RandomAccessMode.READWRITE)) {
            throw new UnsupportedOperationException();
        }
        return new HdfsRandomAccessContent(this.path, this.hdfs);
    }

    @Override
    protected FileType doGetType() throws Exception {
        try {
            this.doAttach();
            if (null == this.stat) {
                return FileType.IMAGINARY;
            }
            if (this.stat.isDirectory()) {
                return FileType.FOLDER;
            }
            return FileType.FILE;
        }
        catch (FileNotFoundException fnfe) {
            return FileType.IMAGINARY;
        }
    }

    @Override
    protected boolean doIsHidden() throws Exception {
        return false;
    }

    @Override
    protected boolean doIsReadable() throws Exception {
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws Exception {
        return false;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        if (this.doGetType() != FileType.FOLDER) {
            throw new FileNotFolderException(this);
        }
        FileStatus[] files = this.hdfs.listStatus(this.path);
        String[] children = new String[files.length];
        int i = 0;
        for (FileStatus status : files) {
            children[i++] = status.getPath().getName();
        }
        return children;
    }

    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.doGetType() != FileType.FOLDER) {
            return null;
        }
        String[] children = this.doListChildren();
        FileObject[] fo = new FileObject[children.length];
        for (int i = 0; i < children.length; ++i) {
            Path p = new Path(this.path, children[i]);
            fo[i] = this.fs.resolveFile(p.toUri().toString());
        }
        return fo;
    }

    @Override
    protected void doRemoveAttribute(String attrName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doSetAttribute(String attrName, Object value) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() throws FileSystemException {
        try {
            this.doAttach();
            return this.stat != null;
        }
        catch (FileNotFoundException fne) {
            return false;
        }
        catch (Exception e) {
            throw new FileSystemException("Unable to check existance ", e);
        }
    }
}

