/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.UpdateOptions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.OldNoteInfo;
import org.apache.zeppelin.notebook.repo.MongoNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.OldNotebookRepo;
import org.apache.zeppelin.notebook.repo.OldVFSNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldMongoNotebookRepo
implements OldNotebookRepo {
    private static final Logger LOG = LoggerFactory.getLogger(MongoNotebookRepo.class);
    private ZeppelinConfiguration conf;
    private MongoClient mongo;
    private MongoDatabase db;
    private MongoCollection<Document> coll;

    public void init(ZeppelinConfiguration zConf) throws IOException {
        this.conf = zConf;
        this.mongo = new MongoClient(new MongoClientURI(this.conf.getMongoUri()));
        this.db = this.mongo.getDatabase(this.conf.getMongoDatabase());
        this.coll = this.db.getCollection(this.conf.getMongoCollection());
        if (this.conf.getMongoAutoimport()) {
            this.insertFileSystemNotes();
        }
    }

    private void insertFileSystemNotes() throws IOException {
        LinkedList<Document> docs = new LinkedList<Document>();
        OldVFSNotebookRepo vfsRepo = new OldVFSNotebookRepo();
        vfsRepo.init(this.conf);
        List infos = vfsRepo.list(null);
        for (OldNoteInfo info : infos) {
            Note note = vfsRepo.get(info.getId(), null);
            Document doc = this.noteToDocument(note);
            docs.add(doc);
        }
        try {
            this.coll.insertMany(docs, new InsertManyOptions().ordered(false));
        }
        catch (MongoBulkWriteException e) {
            this.printDuplicatedException(e);
        }
        vfsRepo.close();
    }

    private void printDuplicatedException(MongoBulkWriteException e) {
        List errors = e.getWriteErrors();
        for (BulkWriteError error : errors) {
            String msg = error.getMessage();
            Pattern pattern = Pattern.compile("[A-Z0-9]{9}");
            Matcher matcher = pattern.matcher(msg);
            if (!matcher.find()) continue;
            String noteId = matcher.group();
            LOG.warn("Note " + noteId + " not inserted since already exists in MongoDB");
        }
    }

    public List<OldNoteInfo> list(AuthenticationInfo subject) throws IOException {
        this.syncId();
        LinkedList<OldNoteInfo> infos = new LinkedList<OldNoteInfo>();
        MongoCursor cursor = this.coll.find().iterator();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Note note = this.documentToNote(null, doc);
            OldNoteInfo info = new OldNoteInfo(note);
            infos.add(info);
        }
        cursor.close();
        return infos;
    }

    private void syncId() {
        MongoCursor cursor = this.coll.find(Filters.type((String)"_id", (BsonType)BsonType.OBJECT_ID)).iterator();
        if (!cursor.hasNext()) {
            return;
        }
        LinkedList<ObjectId> oldDocIds = new LinkedList<ObjectId>();
        LinkedList<Document> updatedDocs = new LinkedList<Document>();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            ObjectId oldId = doc.getObjectId((Object)"_id");
            oldDocIds.add(oldId);
            String noteId = doc.getString((Object)"id");
            doc.put("_id", (Object)noteId);
            updatedDocs.add(doc);
        }
        this.coll.insertMany(updatedDocs);
        this.coll.deleteMany(Filters.in((String)"_id", oldDocIds));
        cursor.close();
    }

    private Note documentToNote(String noteId, Document doc) throws IOException {
        String json = doc.toJson();
        return Note.fromJson((String)noteId, (String)json);
    }

    private Document noteToDocument(Note note) {
        String json = note.toJson();
        Document doc = Document.parse((String)json);
        doc.put("_id", (Object)note.getId());
        return doc;
    }

    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        Document doc = (Document)this.coll.find(Filters.eq((String)"_id", (Object)noteId)).first();
        if (doc == null) {
            throw new IOException("Note " + noteId + "not found");
        }
        return this.documentToNote(noteId, doc);
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        Document doc = this.noteToDocument(note);
        this.coll.replaceOne(Filters.eq((String)"_id", (Object)note.getId()), (Object)doc, new UpdateOptions().upsert(true));
    }

    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        this.coll.deleteOne(Filters.eq((String)"_id", (Object)noteId));
    }

    public void close() {
        this.mongo.close();
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
        return Collections.emptyList();
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
    }
}

