/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import java.io.Serializable;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePoolConnector;

public class RemoteResource
extends Resource
implements JsonSerializable,
Serializable {
    private static final Gson gson = new Gson();
    transient ResourcePoolConnector resourcePoolConnector;

    RemoteResource(ResourceId resourceId, Object r) {
        super(null, resourceId, r);
    }

    RemoteResource(ResourceId resourceId, boolean serializable, String className) {
        super(null, resourceId, serializable, className);
    }

    @Override
    public Object get() {
        if (this.isSerializable()) {
            Object o = this.resourcePoolConnector.readResource(this.getResourceId());
            return o;
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public ResourcePoolConnector getResourcePoolConnector() {
        return this.resourcePoolConnector;
    }

    public void setResourcePoolConnector(ResourcePoolConnector resourcePoolConnector) {
        this.resourcePoolConnector = resourcePoolConnector;
    }

    @Override
    public Object invokeMethod(String methodName, Class[] paramTypes, Object[] params) {
        ResourceId resourceId = this.getResourceId();
        return this.resourcePoolConnector.invokeMethod(resourceId, methodName, paramTypes, params);
    }

    @Override
    public Resource invokeMethod(String methodName, Class[] paramTypes, Object[] params, String returnResourceName) {
        ResourceId resourceId = this.getResourceId();
        Resource resource = this.resourcePoolConnector.invokeMethod(resourceId, methodName, paramTypes, params, returnResourceName);
        return resource;
    }

    @Override
    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static RemoteResource fromJson(String json) {
        return (RemoteResource)gson.fromJson(json, RemoteResource.class);
    }
}

