/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.DockerInterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.DockerSpecTemplate;
import org.apache.zeppelin.interpreter.launcher.utils.TarFileEntry;
import org.apache.zeppelin.interpreter.launcher.utils.TarUtils;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInterpreterProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerInterpreterLauncher.class);
    private String dockerIntpServicePort = "0";
    private final String interpreterGroupId;
    private final String interpreterGroupName;
    private final String interpreterSettingName;
    private final String containerImage;
    private final Properties properties;
    private final Map<String, String> envs;
    private AtomicBoolean dockerStarted = new AtomicBoolean(false);
    private DockerClient docker = null;
    private final String containerName;
    private String containerHost = "";
    private int containerPort = 0;
    private static final String DOCKER_INTP_JINJA = "/jinja_templates/docker-interpreter.jinja";
    @VisibleForTesting
    boolean uploadLocalLibToContainter = true;
    private ZeppelinConfiguration zconf;
    private String zeppelinHome;
    @VisibleForTesting
    final String CONTAINER_SPARK_HOME;
    @VisibleForTesting
    final String DOCKER_HOST;
    private String containerId;
    final String CONTAINER_UPLOAD_TAR_DIR = "/tmp/zeppelin-tar";

    public DockerInterpreterProcess(ZeppelinConfiguration zconf, String containerImage, String interpreterGroupId, String interpreterGroupName, String interpreterSettingName, Properties properties, Map<String, String> envs, String intpEventServerHost, int intpEventServerPort, int connectTimeout, int connectionPoolSize) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.containerImage = containerImage;
        this.interpreterGroupId = interpreterGroupId;
        this.interpreterGroupName = interpreterGroupName;
        this.interpreterSettingName = interpreterSettingName;
        this.properties = properties;
        this.envs = new HashMap<String, String>(envs);
        this.zconf = zconf;
        this.containerName = interpreterGroupId.toLowerCase();
        String sparkHome = System.getenv("CONTAINER_SPARK_HOME");
        this.CONTAINER_SPARK_HOME = sparkHome == null ? "/spark" : sparkHome;
        String uploadLocalLib = System.getenv("UPLOAD_LOCAL_LIB_TO_CONTAINTER");
        if (null != uploadLocalLib && StringUtils.equals((String)uploadLocalLib, (String)"false")) {
            this.uploadLocalLibToContainter = false;
        }
        try {
            this.zeppelinHome = this.getZeppelinHome();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        String defDockerHost = "http://0.0.0.0:2375";
        String dockerHost = System.getenv("DOCKER_HOST");
        this.DOCKER_HOST = dockerHost == null ? defDockerHost : dockerHost;
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String userName) throws IOException {
        String[] ports;
        this.docker = DefaultDockerClient.builder().uri(URI.create(this.DOCKER_HOST)).build();
        this.removeExistContainer(this.containerName);
        HashMap portBindings = new HashMap();
        int intpServicePort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
        this.dockerIntpServicePort = String.valueOf(intpServicePort);
        for (String port : ports = new String[]{this.dockerIntpServicePort}) {
            ArrayList<PortBinding> hostPorts = new ArrayList<PortBinding>();
            hostPorts.add(PortBinding.of((String)"0.0.0.0", (String)port));
            portBindings.put(port, hostPorts);
        }
        HostConfig hostConfig = HostConfig.builder().networkMode("host").portBindings(portBindings).build();
        DockerSpecTemplate specTemplate = new DockerSpecTemplate();
        specTemplate.loadProperties(this.getTemplateBindings());
        URL urlTemplate = ((Object)((Object)this)).getClass().getResource(DOCKER_INTP_JINJA);
        String template = Resources.toString((URL)urlTemplate, (Charset)Charsets.UTF_8);
        String dockerCommand = specTemplate.render(template);
        int firstLineIsNewline = dockerCommand.indexOf("\n");
        if (firstLineIsNewline == 0) {
            dockerCommand = dockerCommand.replaceFirst("\n", "");
        }
        LOGGER.info("dockerCommand = {}", (Object)dockerCommand);
        List<String> listEnv = this.getListEnvs();
        LOGGER.info("docker listEnv = {}", listEnv);
        StringBuilder sbStartCmd = new StringBuilder();
        sbStartCmd.append("sleep 10; ");
        sbStartCmd.append("process=RemoteInterpreterServer; ");
        sbStartCmd.append("RUNNING_PIDS=$(ps x | grep $process | grep -v grep | awk '{print $1}'); ");
        sbStartCmd.append("while [ ! -z \"$RUNNING_PIDS\" ]; ");
        sbStartCmd.append("do sleep 1; ");
        sbStartCmd.append("RUNNING_PIDS=$(ps x | grep $process | grep -v grep | awk '{print $1}'); ");
        sbStartCmd.append("done");
        ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).hostname(this.intpEventServerHost).image(this.containerImage).workingDir("/").env(listEnv).cmd(new String[]{"sh", "-c", sbStartCmd.toString()}).build();
        try {
            LOGGER.info("wait docker pull image {} ...", (Object)this.containerImage);
            this.docker.pull(this.containerImage, new ProgressHandler(){

                public void progress(ProgressMessage message) throws DockerException {
                    if (null != message.error()) {
                        LOGGER.error(message.toString());
                    }
                }
            });
            ContainerCreation containerCreation = this.docker.createContainer(containerConfig, this.containerName);
            this.containerId = containerCreation.id();
            this.docker.startContainer(this.containerId);
            this.copyRunFileToContainer(this.containerId);
            this.execInContainer(this.containerId, dockerCommand, false);
        }
        catch (DockerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        long startTime = System.currentTimeMillis();
        AtomicBoolean atomicBoolean = this.dockerStarted;
        synchronized (atomicBoolean) {
            if (!this.dockerStarted.get()) {
                try {
                    this.dockerStarted.wait(this.getConnectTimeout());
                }
                catch (InterruptedException e) {
                    LOGGER.error("Remote interpreter is not accessible");
                    throw new IOException(e.getMessage());
                }
            }
        }
        if (!this.dockerStarted.get()) {
            LOGGER.info("Interpreter docker creation is time out in {} seconds", (Object)(this.getConnectTimeout() / 1000));
        }
        while (System.currentTimeMillis() - startTime < (long)this.getConnectTimeout() && !RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(int port, String host) {
        this.containerHost = host;
        this.containerPort = port;
        LOGGER.info("Interpreter container created {}:{}", (Object)this.containerHost, (Object)this.containerPort);
        AtomicBoolean atomicBoolean = this.dockerStarted;
        synchronized (atomicBoolean) {
            this.dockerStarted.set(true);
            this.dockerStarted.notify();
        }
    }

    @VisibleForTesting
    Properties getTemplateBindings() throws IOException {
        Properties dockerProperties = new Properties();
        dockerProperties.put("CONTAINER_ZEPPELIN_HOME", this.zeppelinHome);
        dockerProperties.put("zeppelin.interpreter.container.image", this.containerImage);
        dockerProperties.put("zeppelin.interpreter.group.id", this.interpreterGroupId);
        dockerProperties.put("zeppelin.interpreter.group.name", this.interpreterGroupName);
        dockerProperties.put("zeppelin.interpreter.setting.name", this.interpreterSettingName);
        dockerProperties.put("zeppelin.interpreter.localRepo", "/tmp/local-repo");
        dockerProperties.put("zeppelin.interpreter.rpc.portRange", this.dockerIntpServicePort + ":" + this.dockerIntpServicePort);
        dockerProperties.put("zeppelin.server.rpc.host", this.intpEventServerHost);
        dockerProperties.put("zeppelin.server.rpc.portRange", (Object)this.intpEventServerPort);
        dockerProperties.putAll((Map<?, ?>)Maps.fromProperties((Properties)this.properties));
        return dockerProperties;
    }

    @VisibleForTesting
    List<String> getListEnvs() throws SocketException, UnknownHostException {
        this.envs.put("ZEPPELIN_HOME", this.zeppelinHome);
        this.envs.put("ZEPPELIN_CONF_DIR", this.zeppelinHome + "/conf");
        this.envs.put("ZEPPELIN_FORCE_STOP", "true");
        this.envs.put("SPARK_HOME", this.CONTAINER_SPARK_HOME);
        String dockerTimeZone = System.getenv("DOCKER_TIME_ZONE");
        if (StringUtils.isBlank((String)dockerTimeZone)) {
            dockerTimeZone = TimeZone.getDefault().getID();
        }
        this.envs.put("TZ", dockerTimeZone);
        ArrayList<String> listEnv = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.envs.entrySet()) {
            String env = entry.getKey() + "=" + entry.getValue();
            listEnv.add(env);
        }
        return listEnv;
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.info("Kill interpreter process");
            try {
                this.callRemoteFunction(client -> {
                    client.shutdown();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("ignore the exception when shutting down", (Throwable)e);
            }
        }
        try {
            this.docker.killContainer(this.containerName);
            this.docker.removeContainer(this.containerName);
        }
        catch (DockerException | InterruptedException e) {
            LOGGER.error(e.getMessage(), e);
        }
        this.docker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExistContainer(String containerName) {
        boolean isExist = false;
        try {
            List containers = this.docker.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()});
            block11: for (Container container : containers) {
                for (String name : container.names()) {
                    if (!StringUtils.equals((String)name, (String)("/" + containerName))) continue;
                    isExist = true;
                    continue block11;
                }
            }
            if (isExist) {
                LOGGER.info("kill exist container {}", (Object)containerName);
                this.docker.killContainer(containerName);
            }
        }
        catch (DockerException | InterruptedException e) {
            LOGGER.error(e.getMessage(), e);
        }
        finally {
            try {
                if (isExist) {
                    this.docker.removeContainer(containerName);
                }
            }
            catch (DockerException | InterruptedException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public String getHost() {
        return this.containerHost;
    }

    public int getPort() {
        return this.containerPort;
    }

    public boolean isRunning() {
        return RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort());
    }

    public String getErrorMessage() {
        return null;
    }

    private void copyRunFileToContainer(String containerId) throws IOException, DockerException, InterruptedException {
        String zeppelinServerKeytab;
        HashMap<String, String> copyFiles = new HashMap<String, String>();
        this.rmInContainer(containerId, this.zeppelinHome);
        this.mkdirInContainer(containerId, this.zeppelinHome);
        String confPath = "/conf";
        String zeplConfPath = this.getPathByHome(this.zeppelinHome, confPath);
        this.mkdirInContainer(containerId, zeplConfPath);
        copyFiles.put(zeplConfPath + "/zeppelin-site.xml", zeplConfPath + "/zeppelin-site.xml");
        copyFiles.put(zeplConfPath + "/log4j.properties", zeplConfPath + "/log4j.properties");
        copyFiles.put(zeplConfPath + "/log4j_yarn_cluster.properties", zeplConfPath + "/log4j_yarn_cluster.properties");
        String krb5conf = "/etc/krb5.conf";
        File krb5File = new File(krb5conf);
        if (krb5File.exists()) {
            this.rmInContainer(containerId, krb5conf);
            copyFiles.put(krb5conf, krb5conf);
        } else {
            LOGGER.warn("{} file not found, Did not upload the krb5.conf to the container!", (Object)krb5conf);
        }
        String intpKeytab = this.properties.getProperty("zeppelin.shell.keytab.location", "");
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("spark.yarn.keytab", "");
        }
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("submarine.hadoop.keytab", "");
        }
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("zeppelin.livy.keytab", "");
        }
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("zeppelin.jdbc.keytab.location", "");
        }
        if (!StringUtils.isBlank((String)intpKeytab) && !copyFiles.containsKey(intpKeytab)) {
            LOGGER.info("intpKeytab : {}", (Object)intpKeytab);
            copyFiles.put(intpKeytab, intpKeytab);
        }
        if (!StringUtils.isBlank((String)(zeppelinServerKeytab = this.zconf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB))) && !copyFiles.containsKey(zeppelinServerKeytab)) {
            copyFiles.put(zeppelinServerKeytab, zeppelinServerKeytab);
        }
        if (this.envs.containsKey("HADOOP_CONF_DIR")) {
            String hadoopConfDir = this.envs.get("HADOOP_CONF_DIR");
            copyFiles.put(hadoopConfDir, hadoopConfDir);
        }
        if (this.envs.containsKey("SPARK_CONF_DIR")) {
            String sparkConfDir = this.envs.get("SPARK_CONF_DIR");
            this.rmInContainer(containerId, this.CONTAINER_SPARK_HOME + "/conf");
            this.mkdirInContainer(containerId, this.CONTAINER_SPARK_HOME + "/conf");
            copyFiles.put(sparkConfDir, this.CONTAINER_SPARK_HOME + "/conf");
            this.envs.put("SPARK_CONF_DIR", this.CONTAINER_SPARK_HOME + "/conf");
        }
        if (this.uploadLocalLibToContainter) {
            String binPath = "/bin";
            String zeplBinPath = this.getPathByHome(this.zeppelinHome, binPath);
            this.mkdirInContainer(containerId, zeplBinPath);
            this.docker.copyToContainer(new File(zeplBinPath).toPath(), containerId, zeplBinPath);
            String intpGrpPath = "/interpreter/" + this.interpreterGroupName;
            String intpGrpAllPath = this.getPathByHome(this.zeppelinHome, intpGrpPath);
            this.mkdirInContainer(containerId, intpGrpAllPath);
            this.docker.copyToContainer(new File(intpGrpAllPath).toPath(), containerId, intpGrpAllPath);
            String intpPath = "/interpreter";
            String intpAllPath = this.getPathByHome(this.zeppelinHome, intpPath);
            Collection listFiles = FileUtils.listFiles((File)new File(intpAllPath), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)"jar"), null);
            for (File jarfile : listFiles) {
                String jarfilePath = jarfile.getAbsolutePath();
                if (StringUtils.isBlank((String)jarfilePath) || copyFiles.containsKey(jarfilePath)) continue;
                copyFiles.put(jarfilePath, jarfilePath);
            }
        }
        this.deployToContainer(containerId, copyFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployToContainer(String containerId, HashMap<String, String> copyFiles) throws InterruptedException, DockerException, IOException {
        this.mkdirInContainer(containerId, "/tmp/zeppelin-tar");
        String tarFile = this.file2Tar(copyFiles);
        try (FileInputStream inputStream = new FileInputStream(tarFile);){
            this.docker.copyToContainer((InputStream)inputStream, containerId, "/tmp/zeppelin-tar");
        }
        this.cpdirInContainer(containerId, "/tmp/zeppelin-tar/*", "/");
        File fileTar = new File(tarFile);
        fileTar.delete();
    }

    private void mkdirInContainer(String containerId, String path) throws DockerException, InterruptedException {
        String execCommand = "mkdir " + path + " -p";
        this.execInContainer(containerId, execCommand, true);
    }

    private void rmInContainer(String containerId, String path) throws DockerException, InterruptedException {
        String execCommand = "rm " + path + " -R";
        this.execInContainer(containerId, execCommand, true);
    }

    private void cpdirInContainer(String containerId, String from, String to) throws DockerException, InterruptedException {
        String execCommand = "cp " + from + " " + to + " -R";
        this.execInContainer(containerId, execCommand, true);
    }

    private void execInContainer(String containerId, String execCommand, boolean logout) throws DockerException, InterruptedException {
        LOGGER.info("exec container commmand: " + execCommand);
        String[] command = new String[]{"sh", "-c", execCommand};
        ExecCreation execCreation = this.docker.execCreate(containerId, command, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr()});
        LogStream logStream = this.docker.execStart(execCreation.id(), new DockerClient.ExecStartParameter[0]);
        while (logStream.hasNext() && logout) {
            String log = StandardCharsets.UTF_8.decode(((LogMessage)logStream.next()).content()).toString();
            LOGGER.info(log);
        }
    }

    private String file2Tar(HashMap<String, String> copyFiles) throws IOException {
        File tmpDir = Files.createTempDir();
        Date date = new Date();
        String tarFileName = tmpDir.getPath() + date.getTime() + ".tar";
        ArrayList<TarFileEntry> tarFileEntries = new ArrayList<TarFileEntry>();
        for (Map.Entry<String, String> entry : copyFiles.entrySet()) {
            String filePath = entry.getKey();
            String archivePath = entry.getValue();
            TarFileEntry tarFileEntry = new TarFileEntry(new File(filePath), archivePath);
            tarFileEntries.add(tarFileEntry);
        }
        TarUtils.compress(tarFileName, tarFileEntries);
        return tarFileName;
    }

    @VisibleForTesting
    boolean isSpark() {
        return "spark".equalsIgnoreCase(this.interpreterGroupName);
    }

    private String getZeppelinHome() throws IOException {
        File fileZeppelinHome;
        String zeppelinHome = this.zconf.getZeppelinHome();
        if (System.getenv("ZEPPELIN_HOME") != null) {
            zeppelinHome = System.getenv("ZEPPELIN_HOME");
        }
        if ((fileZeppelinHome = new File(zeppelinHome)).exists() && fileZeppelinHome.isDirectory()) {
            return zeppelinHome;
        }
        throw new IOException("Can't find zeppelin home path!");
    }

    private String getPathByHome(String homeDir, String path) throws IOException {
        File file = null;
        file = null == homeDir || StringUtils.isEmpty((String)homeDir) ? new File(path) : new File(homeDir, path);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new IOException("Can't find directory in " + homeDir + path + "!");
    }
}

