/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.markdown.ParamVar;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.support.StringBuilderVar;
import org.pegdown.Parser;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.TextNode;
import org.pegdown.plugins.BlockPluginParser;
import org.pegdown.plugins.PegDownPlugins;

public class PegdownYumlPlugin
extends Parser
implements BlockPluginParser {
    public static final String TAG = "%%%";

    public PegdownYumlPlugin() {
        super(3472383, 10000L, DefaultParseRunnerProvider);
    }

    public PegdownYumlPlugin(Integer options, Long maxParsingTimeInMillis, Parser.ParseRunnerProvider parseRunnerProvider, PegDownPlugins plugins) {
        super(options, maxParsingTimeInMillis, parseRunnerProvider, plugins);
    }

    Rule startMarker() {
        return this.Sequence(this.Spn1(), TAG, this.Sp(), "yuml", this.Sp());
    }

    String endMarker() {
        return TAG;
    }

    Rule parameterName() {
        return this.FirstOf("type", "style", "scale", "format", "dir");
    }

    Rule body() {
        return this.OneOrMore(this.TestNot(TAG), BaseParser.ANY, new Object[0]);
    }

    Rule blockRule() {
        ParamVar<String, String> params = new ParamVar<String, String>();
        StringBuilderVar name = new StringBuilderVar();
        StringBuilderVar value = new StringBuilderVar();
        StringBuilderVar body = new StringBuilderVar();
        return this.NodeSequence(this.startMarker(), this.ZeroOrMore(this.Sequence(this.parameterName(), name.append(this.match()), this.String("="), this.OneOrMore(this.Alphanumeric()), value.append(this.match())), this.Sp(), params.put(name.getString(), value.getString()), name.clear(), value.clear()), this.body(), body.append(this.match()), this.endMarker(), this.push(new ExpImageNode("title", PegdownYumlPlugin.createYumlUrl((Map)params.get(), body.getString()), new TextNode(""))));
    }

    public static String createYumlUrl(Map<String, String> params, String body) {
        StringBuilder inlined = new StringBuilder();
        for (String line : body.split("\\r?\\n")) {
            if ((line = line.trim()).length() <= 0) continue;
            if (inlined.length() > 0) {
                inlined.append(", ");
            }
            inlined.append(line);
        }
        String encodedBody = null;
        try {
            encodedBody = URLEncoder.encode(inlined.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException("Failed to encode YUML markdown body", e);
        }
        StringBuilder mergedStyle = new StringBuilder();
        String style = StringUtils.defaultString(params.get("style"), "scruffy");
        String type = StringUtils.defaultString(params.get("type"), "class");
        String format = StringUtils.defaultString(params.get("format"), "svg");
        mergedStyle.append(style);
        if (null != params.get("dir")) {
            mergedStyle.append(";dir:" + params.get("dir"));
        }
        if (null != params.get("scale")) {
            mergedStyle.append(";scale:" + params.get("scale"));
        }
        return "http://yuml.me/diagram/" + (mergedStyle.toString() + "/") + (type + "/") + encodedBody + ("." + format);
    }

    @Override
    public Rule[] blockPluginRules() {
        return new Rule[]{this.blockRule()};
    }
}

