/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notebook {
    private static final Logger LOGGER = LoggerFactory.getLogger(Notebook.class);
    private AuthorizationService authorizationService;
    private NoteManager noteManager;
    private InterpreterFactory replFactory;
    private InterpreterSettingManager interpreterSettingManager;
    private ZeppelinConfiguration conf;
    private ParagraphJobListener paragraphJobListener;
    private NotebookRepo notebookRepo;
    private SearchService noteSearchService;
    private List<NoteEventListener> noteEventListeners = new ArrayList<NoteEventListener>();
    private Credentials credentials;

    public Notebook(ZeppelinConfiguration conf, AuthorizationService authorizationService, NotebookRepo notebookRepo, NoteManager noteManager, InterpreterFactory replFactory, InterpreterSettingManager interpreterSettingManager, SearchService noteSearchService, Credentials credentials) throws IOException {
        this.conf = conf;
        this.authorizationService = authorizationService;
        this.noteManager = noteManager;
        this.notebookRepo = notebookRepo;
        this.replFactory = replFactory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.interpreterSettingManager.setNotebook(this);
        this.noteSearchService = noteSearchService;
        this.credentials = credentials;
        this.noteEventListeners.add(this.noteSearchService);
        this.noteEventListeners.add(this.interpreterSettingManager);
        if (conf.isIndexRebuild()) {
            noteSearchService.startRebuildIndex(this.getNoteStream());
        }
    }

    public void recoveryIfNecessary() {
        if (this.conf.isRecoveryEnabled()) {
            this.recoverRunningParagraphs();
        }
    }

    private void recoverRunningParagraphs() {
        Thread thread = new Thread(() -> this.getNoteStream().forEach(note -> {
            try {
                boolean hasRecoveredParagraph = false;
                for (Paragraph paragraph : note.getParagraphs()) {
                    if (paragraph.getStatus() != Job.Status.RUNNING) continue;
                    paragraph.recover();
                    hasRecoveredParagraph = true;
                }
                if (!hasRecoveredParagraph) {
                    note.unLoad();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Fail to recovery note: {}", (Object)note.getPath(), (Object)e);
            }
        }));
        thread.setName("Recovering-Thread");
        thread.start();
        LOGGER.info("Start paragraph recovering thread");
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public Notebook(ZeppelinConfiguration conf, AuthorizationService authorizationService, NotebookRepo notebookRepo, NoteManager noteManager, InterpreterFactory replFactory, InterpreterSettingManager interpreterSettingManager, SearchService noteSearchService, Credentials credentials, NoteEventListener noteEventListener) throws IOException {
        this(conf, authorizationService, notebookRepo, noteManager, replFactory, interpreterSettingManager, noteSearchService, credentials);
        if (null != noteEventListener) {
            this.noteEventListeners.add(noteEventListener);
        }
        this.paragraphJobListener = (ParagraphJobListener)((Object)noteEventListener);
    }

    public NoteManager getNoteManager() {
        return this.noteManager;
    }

    public void setParagraphJobListener(ParagraphJobListener paragraphJobListener) {
        this.paragraphJobListener = paragraphJobListener;
    }

    public Note createNote(String notePath, AuthenticationInfo subject) throws IOException {
        return this.createNote(notePath, this.interpreterSettingManager.getDefaultInterpreterSetting().getName(), subject);
    }

    public Note createNote(String notePath, AuthenticationInfo subject, boolean save) throws IOException {
        return this.createNote(notePath, this.interpreterSettingManager.getDefaultInterpreterSetting().getName(), subject, save);
    }

    public Note createNote(String notePath, String defaultInterpreterGroup, AuthenticationInfo subject) throws IOException {
        return this.createNote(notePath, defaultInterpreterGroup, subject, true);
    }

    public Note createNote(String notePath, String defaultInterpreterGroup, AuthenticationInfo subject, boolean save) throws IOException {
        Note note = new Note(notePath, defaultInterpreterGroup, this.replFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListeners);
        this.noteManager.addNote(note, subject);
        this.authorizationService.createNoteAuth(note.getId(), subject);
        this.authorizationService.saveNoteAuth(note.getId(), subject);
        if (save) {
            this.noteManager.saveNote(note, subject);
        }
        this.fireNoteCreateEvent(note, subject);
        return note;
    }

    public String exportNote(String noteId) throws IOException {
        try {
            Note note = this.getNote(noteId);
            if (note == null) {
                throw new IOException("Note " + noteId + " not found");
            }
            return note.toJson();
        }
        catch (IOException e) {
            throw new IOException(noteId + " not found");
        }
    }

    public Note importNote(String sourceJson, String notePath, AuthenticationInfo subject) throws IOException {
        Note oldNote = Note.fromJson(null, sourceJson);
        if (notePath == null) {
            notePath = oldNote.getName();
        }
        Note newNote = this.createNote(notePath, subject);
        CopyOnWriteArrayList<Paragraph> paragraphs = oldNote.getParagraphs();
        for (Paragraph p : paragraphs) {
            newNote.addCloneParagraph(p, subject);
        }
        this.noteManager.saveNote(newNote, subject);
        return newNote;
    }

    public Note cloneNote(String sourceNoteId, String newNotePath, AuthenticationInfo subject) throws IOException {
        Note sourceNote = this.getNote(sourceNoteId);
        if (sourceNote == null) {
            throw new IOException("Source note: " + sourceNoteId + " not found");
        }
        Note newNote = this.createNote(newNotePath, subject, false);
        CopyOnWriteArrayList<Paragraph> paragraphs = sourceNote.getParagraphs();
        for (Paragraph p : paragraphs) {
            newNote.addCloneParagraph(p, subject);
        }
        newNote.setConfig(new HashMap<String, Object>(sourceNote.getConfig()));
        newNote.setInfo(new HashMap<String, Object>(sourceNote.getInfo()));
        newNote.setDefaultInterpreterGroup(sourceNote.getDefaultInterpreterGroup());
        newNote.setNoteForms(new HashMap<String, Input>(sourceNote.getNoteForms()));
        newNote.setNoteParams(new HashMap<String, Object>(sourceNote.getNoteParams()));
        newNote.setRunning(false);
        this.saveNote(newNote, subject);
        this.authorizationService.cloneNoteMeta(newNote.getId(), sourceNoteId, subject);
        return newNote;
    }

    public void removeNote(Note note, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove note: {}", (Object)note.getId());
        note.setRemoved(true);
        this.noteManager.removeNote(note.getId(), subject);
        this.authorizationService.removeNoteAuth(note.getId());
        this.fireNoteRemoveEvent(note, subject);
    }

    public void removeCorruptedNote(String noteId, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove corrupted note: {}", (Object)noteId);
        this.noteManager.removeNote(noteId, subject);
        this.authorizationService.removeNoteAuth(noteId);
    }

    public void removeNote(String noteId, AuthenticationInfo subject) throws IOException {
        Note note = this.getNote(noteId);
        this.removeNote(note, subject);
    }

    public Note getNote(String noteId) throws IOException {
        return this.getNote(noteId, false);
    }

    public Note getNote(String noteId, boolean reload) throws IOException {
        Note note = this.noteManager.getNote(noteId, reload);
        if (note == null) {
            return null;
        }
        note.setInterpreterFactory(this.replFactory);
        note.setInterpreterSettingManager(this.interpreterSettingManager);
        note.setParagraphJobListener(this.paragraphJobListener);
        note.setNoteEventListeners(this.noteEventListeners);
        note.setCredentials(this.credentials);
        for (Paragraph p : note.getParagraphs()) {
            p.setNote(note);
        }
        return note;
    }

    public void saveNote(Note note, AuthenticationInfo subject) throws IOException {
        this.noteManager.saveNote(note, subject);
    }

    public void updateNote(Note note, AuthenticationInfo subject) throws IOException {
        this.noteManager.saveNote(note, subject);
        this.fireNoteUpdateEvent(note, subject);
    }

    public boolean containsNote(String notePath) {
        return this.noteManager.containsNote(notePath);
    }

    public boolean containsFolder(String folderPath) {
        return this.noteManager.containsFolder(folderPath);
    }

    public void moveNote(String noteId, String newNotePath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move note {} to {}", (Object)noteId, (Object)newNotePath);
        this.noteManager.moveNote(noteId, newNotePath, subject);
    }

    public void moveFolder(String folderPath, String newFolderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move folder from {} to {}", (Object)folderPath, (Object)newFolderPath);
        this.noteManager.moveFolder(folderPath, newFolderPath, subject);
    }

    public void removeFolder(String folderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove folder {}", (Object)folderPath);
        List<Note> notes = this.noteManager.removeFolder(folderPath, subject);
        for (Note note : notes) {
            this.fireNoteRemoveEvent(note, subject);
        }
    }

    public void emptyTrash(AuthenticationInfo subject) throws IOException {
        LOGGER.info("Empty Trash");
        this.removeFolder("/~Trash", subject);
    }

    public void restoreAll(AuthenticationInfo subject) throws IOException {
        NoteManager.Folder trash = this.noteManager.getTrashFolder();
        List notes = trash.getNotes().values().stream().collect(Collectors.toList());
        for (NoteManager.NoteNode noteNode : notes) {
            this.moveNote(noteNode.getNoteId(), noteNode.getNotePath().replace("/~Trash", ""), subject);
        }
        List folders = trash.getFolders().values().stream().collect(Collectors.toList());
        for (NoteManager.Folder folder : folders) {
            this.moveFolder(folder.getPath(), folder.getPath().replace("/~Trash", ""), subject);
        }
    }

    public NotebookRepoWithVersionControl.Revision checkpointNote(String noteId, String notePath, String checkpointMessage, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).checkpoint(noteId, notePath, checkpointMessage, subject);
        }
        return null;
    }

    public List<NotebookRepoWithVersionControl.Revision> listRevisionHistory(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).revisionHistory(noteId, notePath, subject);
        }
        return null;
    }

    public Note setNoteRevision(String noteId, String notePath, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            Note note = ((NotebookRepoWithVersionControl)this.notebookRepo).setNoteRevision(noteId, notePath, revisionId, subject);
            this.noteManager.saveNote(note);
            return note;
        }
        return null;
    }

    public Note getNoteByRevision(String noteId, String noteName, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).get(noteId, noteName, revisionId, subject);
        }
        return null;
    }

    public Note loadNoteFromRepo(String id, AuthenticationInfo subject) {
        Note note = null;
        try {
            note = this.noteManager.getNote(id);
        }
        catch (IOException e) {
            LOGGER.error("Fail to get note: {}", (Object)id, (Object)e);
            return null;
        }
        if (note == null) {
            return null;
        }
        note.setCredentials(this.credentials);
        note.setInterpreterFactory(this.replFactory);
        note.setInterpreterSettingManager(this.interpreterSettingManager);
        note.setParagraphJobListener(this.paragraphJobListener);
        note.setCronSupported(this.getConf());
        if (note.getDefaultInterpreterGroup() == null) {
            note.setDefaultInterpreterGroup(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT));
        }
        HashMap<String, SnapshotAngularObject> angularObjectSnapshot = new HashMap<String, SnapshotAngularObject>();
        Date lastUpdatedDate = new Date(0L);
        for (Paragraph p : note.getParagraphs()) {
            p.setNote(note);
            if (p.getDateFinished() == null || !lastUpdatedDate.before(p.getDateFinished())) continue;
            lastUpdatedDate = p.getDateFinished();
        }
        Map<String, List<AngularObject>> savedObjects = note.getAngularObjects();
        if (savedObjects != null) {
            for (Map.Entry<String, List<AngularObject>> entry : savedObjects.entrySet()) {
                String intpGroupName = entry.getKey();
                List<AngularObject> objectList = entry.getValue();
                for (AngularObject object : objectList) {
                    SnapshotAngularObject snapshot = (SnapshotAngularObject)angularObjectSnapshot.get(object.getName());
                    if (snapshot != null && !snapshot.getLastUpdate().before(lastUpdatedDate)) continue;
                    angularObjectSnapshot.put(object.getName(), new SnapshotAngularObject(intpGroupName, object, lastUpdatedDate));
                }
            }
        }
        note.setNoteEventListeners(this.noteEventListeners);
        for (Map.Entry<String, List<Object>> entry : angularObjectSnapshot.entrySet()) {
            String name = entry.getKey();
            SnapshotAngularObject snapshot = (SnapshotAngularObject)((Object)entry.getValue());
            List<InterpreterSetting> settings = this.interpreterSettingManager.get();
            for (InterpreterSetting setting : settings) {
                ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(note.getExecutionContext());
                if (intpGroup == null || !intpGroup.getId().equals(snapshot.getIntpGroupId())) continue;
                AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
                String noteId = snapshot.getAngularObject().getNoteId();
                String paragraphId = snapshot.getAngularObject().getParagraphId();
                registry.add(name, snapshot.getAngularObject().get(), noteId, paragraphId);
            }
        }
        return note;
    }

    public void reloadAllNotes(AuthenticationInfo subject) throws IOException {
        NotebookRepoSync mainRepo;
        this.noteManager.reloadNotes();
        if (this.notebookRepo instanceof NotebookRepoSync && (mainRepo = (NotebookRepoSync)this.notebookRepo).getRepoCount() > 1) {
            mainRepo.sync(subject);
        }
    }

    public List<NoteInfo> getNotesInfo() {
        return this.noteManager.getNotesInfo().entrySet().stream().map(entry -> new NoteInfo((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public Stream<Note> getNoteStream() {
        return this.noteManager.getNotesStream().map(note -> {
            note.setInterpreterFactory(this.replFactory);
            note.setInterpreterSettingManager(this.interpreterSettingManager);
            note.setParagraphJobListener(this.paragraphJobListener);
            note.setNoteEventListeners(this.noteEventListeners);
            note.setCredentials(this.credentials);
            for (Paragraph p : note.getParagraphs()) {
                p.setNote((Note)note);
                p.setListener(this.paragraphJobListener);
            }
            return note;
        });
    }

    @VisibleForTesting
    public List<Note> getAllNotes(Function<Note, Boolean> func) {
        return this.getAllNotes().stream().filter(note -> (Boolean)func.apply((Note)note)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public List<Note> getAllNotes() {
        List<Note> notes = this.getNoteStream().collect(Collectors.toList());
        Collections.sort(notes, Comparator.comparing(Note::getPath));
        return notes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NoteInfo> getNotesInfo(Function<String, Boolean> func) {
        String homescreenNoteId = this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        boolean hideHomeScreenNotebookFromList = this.conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN_HIDE);
        Map<String, String> map = this.noteManager.getNotesInfo();
        synchronized (map) {
            List<NoteInfo> notesInfo = this.noteManager.getNotesInfo().entrySet().stream().filter(entry -> (Boolean)func.apply((String)entry.getKey()) != false && (!hideHomeScreenNotebookFromList || hideHomeScreenNotebookFromList && !((String)entry.getKey()).equals(homescreenNoteId))).map(entry -> new NoteInfo((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            notesInfo.sort((note1, note2) -> {
                String name1 = note1.getId();
                if (note1.getPath() != null) {
                    name1 = note1.getPath();
                }
                String name2 = note2.getId();
                if (note2.getPath() != null) {
                    name2 = note2.getPath();
                }
                return name1.compareTo(name2);
            });
            return notesInfo;
        }
    }

    public List<InterpreterSetting> getBindedInterpreterSettings(String noteId) throws IOException {
        Note note = this.getNote(noteId);
        if (note == null) {
            return new ArrayList<InterpreterSetting>();
        }
        HashSet<InterpreterSetting> settings = new HashSet<InterpreterSetting>();
        for (Paragraph p : note.getParagraphs()) {
            try {
                Interpreter intp = p.getBindedInterpreter();
                settings.add(((ManagedInterpreterGroup)intp.getInterpreterGroup()).getInterpreterSetting());
            }
            catch (InterpreterNotFoundException interpreterNotFoundException) {}
        }
        InterpreterSetting defaultIntpSetting = this.interpreterSettingManager.getByName(note.getDefaultInterpreterGroup());
        if (defaultIntpSetting != null) {
            settings.add(defaultIntpSetting);
        }
        return new ArrayList<InterpreterSetting>(settings);
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.replFactory;
    }

    public InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    public ZeppelinConfiguration getConf() {
        return this.conf;
    }

    public void close() {
        this.notebookRepo.close();
        this.noteSearchService.close();
    }

    public void addNotebookEventListener(NoteEventListener listener) {
        this.noteEventListeners.add(listener);
    }

    private void fireNoteCreateEvent(Note note, AuthenticationInfo subject) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteCreate(note, subject);
        }
    }

    private void fireNoteUpdateEvent(Note note, AuthenticationInfo subject) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteUpdate(note, subject);
        }
    }

    private void fireNoteRemoveEvent(Note note, AuthenticationInfo subject) throws IOException {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteRemove(note, subject);
        }
    }

    public Boolean isRevisionSupported() {
        if (this.notebookRepo instanceof NotebookRepoSync) {
            return ((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo();
        }
        if (this.notebookRepo instanceof NotebookRepoWithVersionControl) {
            return true;
        }
        return false;
    }

    private class SnapshotAngularObject {
        String intpGroupId;
        AngularObject angularObject;
        Date lastUpdate;

        SnapshotAngularObject(String intpGroupId, AngularObject angularObject, Date lastUpdate) {
            this.intpGroupId = intpGroupId;
            this.angularObject = angularObject;
            this.lastUpdate = lastUpdate;
        }

        String getIntpGroupId() {
            return this.intpGroupId;
        }

        AngularObject getAngularObject() {
            return this.angularObject;
        }

        Date getLastUpdate() {
            return this.lastUpdate;
        }
    }
}

