/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.event.ClusterEvent;
import org.apache.zeppelin.cluster.event.ClusterEventListener;
import org.apache.zeppelin.cluster.event.ClusterMessage;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.ExecutionContext;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.RemoteInterpreterEventServer;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphTextParser;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.ReflectionUtils;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="interpreterSettingManager")
public class InterpreterSettingManager
implements NoteEventListener,
ClusterEventListener {
    private static final Pattern VALID_INTERPRETER_NAME = Pattern.compile("^[-_a-zA-Z0-9]+$");
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterSettingManager.class);
    private static final Map<String, Object> DEFAULT_EDITOR = ImmutableMap.of((Object)"language", (Object)"text", (Object)"editOnDblClick", (Object)false);
    private final ZeppelinConfiguration conf;
    private final Path interpreterDirPath;
    private final Map<String, InterpreterSetting> interpreterSettingTemplates = Maps.newConcurrentMap();
    private final Map<String, InterpreterSetting> interpreterSettings = Metrics.gaugeMapSize((String)"interpreter.amount", (Iterable)Tags.empty(), (Map)Maps.newConcurrentMap());
    private final Map<String, List<Meter>> interpreterSettingsMeters = Maps.newConcurrentMap();
    private final List<RemoteRepository> interpreterRepositories;
    private InterpreterOption defaultOption;
    private String defaultInterpreterGroup;
    private final Gson gson;
    private Notebook notebook;
    private AngularObjectRegistryListener angularObjectRegistryListener;
    private RemoteInterpreterProcessListener remoteInterpreterProcessListener;
    private ApplicationEventListener appEventListener;
    private DependencyResolver dependencyResolver;
    private RecoveryStorage recoveryStorage;
    private ConfigStorage configStorage;
    private RemoteInterpreterEventServer interpreterEventServer;
    private Map<String, String> jupyterKernelLanguageMap = new HashMap<String, String>();
    private List<String> includesInterpreters;
    private List<String> excludesInterpreters;

    @Inject
    public InterpreterSettingManager(ZeppelinConfiguration zeppelinConfiguration, AngularObjectRegistryListener angularObjectRegistryListener, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appEventListener) throws IOException {
        this(zeppelinConfiguration, new InterpreterOption(), angularObjectRegistryListener, remoteInterpreterProcessListener, appEventListener, ConfigStorage.getInstance(zeppelinConfiguration));
    }

    public InterpreterSettingManager(ZeppelinConfiguration conf, InterpreterOption defaultOption, AngularObjectRegistryListener angularObjectRegistryListener, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appEventListener, ConfigStorage configStorage) throws IOException {
        this.conf = conf;
        this.defaultOption = defaultOption;
        this.interpreterDirPath = Paths.get(conf.getInterpreterDir(), new String[0]);
        LOGGER.debug("InterpreterRootPath: {}", (Object)this.interpreterDirPath);
        this.dependencyResolver = new DependencyResolver(conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LOCALREPO));
        this.interpreterRepositories = this.dependencyResolver.getRepos();
        this.defaultInterpreterGroup = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.angularObjectRegistryListener = angularObjectRegistryListener;
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        this.appEventListener = appEventListener;
        this.interpreterEventServer = new RemoteInterpreterEventServer(conf, this);
        this.interpreterEventServer.start();
        this.recoveryStorage = (RecoveryStorage)ReflectionUtils.createClazzInstance(conf.getRecoveryStorageClass(), new Class[]{ZeppelinConfiguration.class, InterpreterSettingManager.class}, new Object[]{conf, this});
        LOGGER.info("Using RecoveryStorage: {}", (Object)this.recoveryStorage.getClass().getName());
        this.configStorage = configStorage;
        this.init();
    }

    public RemoteInterpreterEventServer getInterpreterEventServer() {
        return this.interpreterEventServer;
    }

    public void refreshInterpreterTemplates() {
        HashSet installedInterpreters = Sets.newHashSet(this.interpreterSettingTemplates.keySet());
        try {
            LOGGER.info("Refreshing interpreter list");
            this.loadInterpreterSettingFromDefaultDir(false);
            HashSet newlyAddedInterpreters = Sets.newHashSet(this.interpreterSettingTemplates.keySet());
            newlyAddedInterpreters.removeAll(installedInterpreters);
            if (!newlyAddedInterpreters.isEmpty()) {
                this.saveToFile();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while saving interpreter settings.");
        }
    }

    private void initInterpreterSetting(InterpreterSetting interpreterSetting) {
        interpreterSetting.setConf(this.conf).setInterpreterSettingManager(this).setAngularObjectRegistryListener(this.angularObjectRegistryListener).setRemoteInterpreterProcessListener(this.remoteInterpreterProcessListener).setAppEventListener(this.appEventListener).setDependencyResolver(this.dependencyResolver).setRecoveryStorage(this.recoveryStorage).setInterpreterEventServer(this.interpreterEventServer).postProcessing();
    }

    private void loadFromFile() throws IOException {
        InterpreterInfoSaving infoSaving = this.configStorage.loadInterpreterSettings();
        if (infoSaving == null) {
            for (InterpreterSetting interpreterSettingTemplate : this.interpreterSettingTemplates.values()) {
                InterpreterSetting interpreterSetting = new InterpreterSetting(interpreterSettingTemplate);
                this.initInterpreterSetting(interpreterSetting);
                if (!this.shouldRegister(interpreterSetting.getGroup())) continue;
                this.addInterpreterSetting(interpreterSetting);
            }
            return;
        }
        for (InterpreterSetting savedInterpreterSetting : infoSaving.interpreterSettings.values()) {
            if (!this.shouldRegister(savedInterpreterSetting.getGroup())) continue;
            savedInterpreterSetting.setProperties(InterpreterSetting.convertInterpreterProperties(savedInterpreterSetting.getProperties()));
            this.initInterpreterSetting(savedInterpreterSetting);
            InterpreterSetting interpreterSettingTemplate = this.interpreterSettingTemplates.get(savedInterpreterSetting.getGroup());
            if (interpreterSettingTemplate == null) {
                LOGGER.warn("No InterpreterSetting Template found for InterpreterSetting: {}, but it is found in interpreter.json, it would be skipped.", (Object)savedInterpreterSetting.getGroup());
                continue;
            }
            savedInterpreterSetting.sortPropertiesByTemplate(interpreterSettingTemplate.getProperties());
            savedInterpreterSetting.fillPropertyDescription(interpreterSettingTemplate.getProperties());
            savedInterpreterSetting.setInterpreterDir(interpreterSettingTemplate.getInterpreterDir());
            savedInterpreterSetting.setInterpreterInfos(interpreterSettingTemplate.getInterpreterInfos());
            savedInterpreterSetting.setInterpreterRunner(interpreterSettingTemplate.getInterpreterRunner());
            for (InterpreterSetting setting : this.interpreterSettings.values()) {
                if (!setting.getName().equals(savedInterpreterSetting.getName())) continue;
                this.removeInterpreterSetting(setting.getId());
            }
            savedInterpreterSetting.postProcessing();
            LOGGER.info("Create interpreter setting {} from interpreter.json", (Object)savedInterpreterSetting.getName());
            this.addInterpreterSetting(savedInterpreterSetting);
        }
        for (InterpreterSetting interpreterSettingTemplate : this.interpreterSettingTemplates.values()) {
            InterpreterSetting interpreterSetting = new InterpreterSetting(interpreterSettingTemplate);
            this.initInterpreterSetting(interpreterSetting);
            if (this.interpreterSettings.containsKey(interpreterSetting.getId())) continue;
            LOGGER.info("Create interpreter setting: {} from interpreter setting template", (Object)interpreterSetting.getId());
            this.addInterpreterSetting(interpreterSetting);
        }
        if (infoSaving.interpreterRepositories != null) {
            for (RemoteRepository repo : infoSaving.interpreterRepositories) {
                if (this.dependencyResolver.getRepos().contains(repo)) continue;
                this.interpreterRepositories.add(repo);
            }
            for (InterpreterSetting setting : this.interpreterSettings.values()) {
                setting.setDependencies(setting.getDependencies());
            }
        }
    }

    private void addInterpreterSetting(InterpreterSetting interpreterSetting) {
        this.interpreterSettings.put(interpreterSetting.getId(), interpreterSetting);
        LinkedList<Gauge> meters = new LinkedList<Gauge>();
        Gauge size = Gauge.builder((String)"interpreter.group.size", () -> interpreterSetting.getAllInterpreterGroups().size()).description("Size of all interpreter groups").tags((Iterable)Tags.of((String)"name", (String)interpreterSetting.getId())).tags((Iterable)Tags.of((String)"group", (String)interpreterSetting.getGroup())).register((MeterRegistry)Metrics.globalRegistry);
        meters.add(size);
        this.interpreterSettingsMeters.put(interpreterSetting.getId(), meters);
    }

    private void removeInterpreterSetting(String id) {
        this.interpreterSettings.remove(id);
        List<Meter> meters = this.interpreterSettingsMeters.remove(id);
        for (Meter meter : meters) {
            Metrics.globalRegistry.remove(meter);
        }
    }

    public void saveToFile() throws IOException {
        InterpreterInfoSaving info = new InterpreterInfoSaving();
        info.interpreterSettings = Maps.newHashMap(this.interpreterSettings);
        info.interpreterRepositories = this.interpreterRepositories;
        this.configStorage.save(info);
    }

    private void initMetrics() {
        Gauge.builder((String)"interpreter.group.size.total", () -> this.getAllInterpreterGroup().size()).description("Size of all interpreter groups").tags(new String[0]).register((MeterRegistry)Metrics.globalRegistry);
    }

    private void init() throws IOException {
        this.includesInterpreters = Arrays.asList(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES).split(",")).stream().filter(t -> !t.isEmpty()).collect(Collectors.toList());
        this.excludesInterpreters = Arrays.asList(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES).split(",")).stream().filter(t -> !t.isEmpty()).collect(Collectors.toList());
        if (!this.includesInterpreters.isEmpty() && !this.excludesInterpreters.isEmpty()) {
            throw new IOException(String.format("%s and %s can not be specified together, only one can be set.", ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_INCLUDES.getVarName(), ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_EXCLUDES.getVarName()));
        }
        this.loadJupyterKernelLanguageMap();
        this.loadInterpreterSettingFromDefaultDir(true);
        this.loadFromFile();
        this.saveToFile();
        this.initMetrics();
        this.recoveryStorage.init();
    }

    private boolean shouldRegister(String group) {
        return this.includesInterpreters.isEmpty() && this.excludesInterpreters.isEmpty() || !this.includesInterpreters.isEmpty() && this.includesInterpreters.contains(group) || !this.excludesInterpreters.isEmpty() && !this.excludesInterpreters.contains(group);
    }

    private void loadJupyterKernelLanguageMap() throws IOException {
        String kernels = this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_JUPYTER_KERNELS);
        for (String kernel : kernels.split(",")) {
            String[] tokens = kernel.split(":");
            if (tokens.length != 2) {
                throw new IOException("Invalid kernel specified in " + ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_JUPYTER_KERNELS.getVarName() + ", Invalid kernel: " + kernel + ", please use format kernel_name:language");
            }
            this.jupyterKernelLanguageMap.put(tokens[0].trim(), tokens[1].trim());
        }
    }

    private void loadInterpreterSettingFromDefaultDir(boolean override) throws IOException {
        String interpreterJson = this.conf.getInterpreterJson();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (Files.exists(this.interpreterDirPath, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryPaths = Files.newDirectoryStream(this.interpreterDirPath, entry -> Files.exists(entry, new LinkOption[0]) && Files.isDirectory(entry, new LinkOption[0]) && this.shouldRegister(entry.toFile().getName()));){
                for (Path interpreterDir : directoryPaths) {
                    String interpreterDirString = interpreterDir.toString();
                    if (this.registerInterpreterFromPath(interpreterDirString, interpreterJson, override) || this.registerInterpreterFromResource(cl, interpreterDirString, interpreterJson, override)) continue;
                    LOGGER.warn("No interpreter-setting.json found in {}", (Object)interpreterDirString);
                }
            }
        } else {
            LOGGER.warn("InterpreterDir {} doesn't exist", (Object)this.interpreterDirPath);
        }
    }

    public void setNotebook(Notebook notebook) {
        this.notebook = notebook;
    }

    public Notebook getNotebook() {
        return this.notebook;
    }

    public RemoteInterpreterProcessListener getRemoteInterpreterProcessListener() {
        return this.remoteInterpreterProcessListener;
    }

    public ApplicationEventListener getAppEventListener() {
        return this.appEventListener;
    }

    private boolean registerInterpreterFromResource(ClassLoader cl, String interpreterDir, String interpreterJson, boolean override) throws IOException {
        URL[] urls = this.recursiveBuildLibList(new File(interpreterDir));
        URLClassLoader tempClassLoader = new URLClassLoader(urls, null);
        URL url = tempClassLoader.getResource(interpreterJson);
        if (url == null) {
            return false;
        }
        LOGGER.debug("Reading interpreter-setting.json from {} as Resource", (Object)url);
        List<Interpreter.RegisteredInterpreter> registeredInterpreterList = this.getInterpreterListFromJson(url.openStream());
        this.registerInterpreterSetting(registeredInterpreterList, interpreterDir, override);
        return true;
    }

    private boolean registerInterpreterFromPath(String interpreterDir, String interpreterJson, boolean override) throws IOException {
        Path interpreterJsonPath = Paths.get(interpreterDir, interpreterJson);
        if (Files.exists(interpreterJsonPath, new LinkOption[0])) {
            LOGGER.debug("Reading interpreter-setting.json from file {}", (Object)interpreterJsonPath);
            List<Interpreter.RegisteredInterpreter> registeredInterpreterList = this.getInterpreterListFromJson(new FileInputStream(interpreterJsonPath.toFile()));
            this.registerInterpreterSetting(registeredInterpreterList, interpreterDir, override);
            return true;
        }
        return false;
    }

    private List<Interpreter.RegisteredInterpreter> getInterpreterListFromJson(InputStream stream) {
        Type registeredInterpreterListType = new TypeToken<List<Interpreter.RegisteredInterpreter>>(){}.getType();
        return (List)this.gson.fromJson((Reader)new InputStreamReader(stream), registeredInterpreterListType);
    }

    private void registerInterpreterSetting(List<Interpreter.RegisteredInterpreter> registeredInterpreters, String interpreterDir, boolean override) {
        LinkedHashMap properties = new LinkedHashMap();
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        InterpreterOption option = this.defaultOption;
        String group = null;
        InterpreterRunner runner = null;
        for (Interpreter.RegisteredInterpreter registeredInterpreter : registeredInterpreters) {
            InterpreterInfo interpreterInfo = new InterpreterInfo(registeredInterpreter.getClassName(), registeredInterpreter.getName(), registeredInterpreter.isDefaultInterpreter(), registeredInterpreter.getEditor(), registeredInterpreter.getConfig());
            interpreterInfo.setConfig(registeredInterpreter.getConfig());
            group = registeredInterpreter.getGroup();
            runner = registeredInterpreter.getRunner();
            if (registeredInterpreter.getOption() != null) {
                option = registeredInterpreter.getOption();
            }
            properties.putAll(registeredInterpreter.getProperties());
            interpreterInfos.add(interpreterInfo);
        }
        InterpreterSetting interpreterSettingTemplate = new InterpreterSetting.Builder().setGroup(group).setName(group).setInterpreterInfos(interpreterInfos).setProperties(properties).setDependencies(new ArrayList<Dependency>()).setOption(option).setRunner(runner).setInterpreterDir(interpreterDir).setRunner(runner).setConf(this.conf).setIntepreterSettingManager(this).create();
        String key = interpreterSettingTemplate.getName();
        if (override || !this.interpreterSettingTemplates.containsKey(key)) {
            LOGGER.info("Register InterpreterSettingTemplate: {}", (Object)key);
            this.interpreterSettingTemplates.put(key, interpreterSettingTemplate);
        }
    }

    public InterpreterSetting getDefaultInterpreterSetting(String noteId) {
        try {
            Note note = this.notebook.getNote(noteId);
            InterpreterSetting interpreterSetting = this.interpreterSettings.get(note.getDefaultInterpreterGroup());
            if (interpreterSetting == null) {
                interpreterSetting = this.get().get(0);
            }
            return interpreterSetting;
        }
        catch (Exception e) {
            LOGGER.warn("Fail to get note: {}", (Object)noteId, (Object)e);
            return this.get().get(0);
        }
    }

    public InterpreterSetting getInterpreterSettingByName(String name) {
        for (InterpreterSetting setting : this.interpreterSettings.values()) {
            if (!setting.getName().equals(name)) continue;
            return setting;
        }
        return null;
    }

    public ManagedInterpreterGroup getInterpreterGroupById(String groupId) {
        for (InterpreterSetting setting : this.interpreterSettings.values()) {
            ManagedInterpreterGroup interpreterGroup = setting.getInterpreterGroup(groupId);
            if (interpreterGroup == null) continue;
            return interpreterGroup;
        }
        return null;
    }

    public Map<String, Object> getEditorSetting(String paragraphText, String noteId) {
        ParagraphTextParser.ParseResult parseResult = ParagraphTextParser.parse(paragraphText);
        if (StringUtils.isBlank((CharSequence)parseResult.getIntpText())) {
            InterpreterSetting interpreterSetting = this.getDefaultInterpreterSetting(noteId);
            try {
                return interpreterSetting.getDefaultInterpreterInfo().getEditor();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                return DEFAULT_EDITOR;
            }
        }
        String[] replNameSplit = parseResult.getIntpText().split("\\.");
        if (replNameSplit.length == 1) {
            String intpName = replNameSplit[0];
            InterpreterSetting defaultInterpreterSetting = this.getDefaultInterpreterSetting(noteId);
            InterpreterInfo interpreterInfo = defaultInterpreterSetting.getInterpreterInfo(intpName);
            if (interpreterInfo != null) {
                return interpreterInfo.getEditor();
            }
            String intpGroupName = replNameSplit[0];
            if (intpGroupName.equals("jupyter")) {
                String language;
                InterpreterSetting interpreterSetting = this.interpreterSettings.get("jupyter");
                Map<String, Object> jupyterEditorSetting = interpreterSetting.getInterpreterInfos().get(0).getEditor();
                String kernel = parseResult.getLocalProperties().get("kernel");
                if (kernel != null && (language = this.jupyterKernelLanguageMap.get(kernel)) != null) {
                    jupyterEditorSetting.put("language", language);
                }
                return jupyterEditorSetting;
            }
            try {
                InterpreterSetting interpreterSetting = this.getInterpreterSettingByName(intpGroupName);
                if (interpreterSetting == null) {
                    return DEFAULT_EDITOR;
                }
                return interpreterSetting.getDefaultInterpreterInfo().getEditor();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                return DEFAULT_EDITOR;
            }
        }
        String intpGroupName = replNameSplit[0];
        String intpName = replNameSplit[1];
        try {
            InterpreterSetting interpreterSetting = this.getInterpreterSettingByName(intpGroupName);
            return interpreterSetting.getInterpreterInfo(intpName).getEditor();
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            return DEFAULT_EDITOR;
        }
    }

    public Map<String, Object> getConfigSetting(String interpreterGroupId) {
        InterpreterSetting interpreterSetting = this.get(interpreterGroupId);
        if (null != interpreterSetting) {
            List<InterpreterInfo> interpreterInfos = interpreterSetting.getInterpreterInfos();
            int infoSize = interpreterInfos.size();
            for (InterpreterInfo intpInfo : interpreterInfos) {
                if (!intpInfo.isDefaultInterpreter() && infoSize != 1 || intpInfo.getConfig() == null) continue;
                return intpInfo.getConfig();
            }
        }
        return new HashMap<String, Object>();
    }

    public List<ManagedInterpreterGroup> getAllInterpreterGroup() {
        ArrayList<ManagedInterpreterGroup> interpreterGroups = new ArrayList<ManagedInterpreterGroup>();
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            interpreterGroups.addAll(interpreterSetting.getAllInterpreterGroups());
        }
        return interpreterGroups;
    }

    public void removeInterpreterGroup(String intpGroupId) {
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            interpreterSetting.removeInterpreterGroup(intpGroupId);
        }
    }

    public ResourceSet getAllResources() {
        return this.getAllResourcesExcept(null);
    }

    private ResourceSet getAllResourcesExcept(String interpreterGroupExcludsion) {
        ResourceSet resourceSet = new ResourceSet();
        for (ManagedInterpreterGroup intpGroup : this.getAllInterpreterGroup()) {
            List resourceList;
            if (interpreterGroupExcludsion != null && intpGroup.getId().equals(interpreterGroupExcludsion)) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll((Collection)localPool.getAll());
                continue;
            }
            if (!remoteInterpreterProcess.isRunning() || (resourceList = (List)remoteInterpreterProcess.callRemoteFunction(client -> client.resourcePoolGetAll())) == null) continue;
            for (String res : resourceList) {
                resourceSet.add((Object)Resource.fromJson((String)res));
            }
        }
        return resourceSet;
    }

    public RecoveryStorage getRecoveryStorage() {
        return this.recoveryStorage;
    }

    public void removeResourcesBelongsToParagraph(String noteId, String paragraphId) {
        for (ManagedInterpreterGroup intpGroup : this.getAllInterpreterGroup()) {
            ResourceSet resourceSet = new ResourceSet();
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool != null) {
                    resourceSet.addAll((Collection)localPool.getAll());
                }
                if (noteId != null) {
                    resourceSet = resourceSet.filterByNoteId(noteId);
                }
                if (paragraphId != null) {
                    resourceSet = resourceSet.filterByParagraphId(paragraphId);
                }
                for (Resource r : resourceSet) {
                    localPool.remove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                }
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            try {
                List resourceList = (List)remoteInterpreterProcess.callRemoteFunction(client -> client.resourcePoolGetAll());
                for (String res : resourceList) {
                    resourceSet.add((Object)Resource.fromJson((String)res));
                }
                if (noteId != null) {
                    resourceSet = resourceSet.filterByNoteId(noteId);
                }
                if (paragraphId != null) {
                    resourceSet = resourceSet.filterByParagraphId(paragraphId);
                }
                for (Resource r : resourceSet) {
                    remoteInterpreterProcess.callRemoteFunction(client -> {
                        client.resourceRemove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                        return null;
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public void removeResourcesBelongsToNote(String noteId) {
        try {
            this.removeResourcesBelongsToParagraph(noteId, null);
        }
        catch (Exception e) {
            LOGGER.warn("Fail to remove resources", (Throwable)e);
        }
    }

    private void copyDependenciesFromLocalPath(InterpreterSetting setting) {
        try {
            List<Dependency> deps = setting.getDependencies();
            if (deps != null) {
                LOGGER.info("Start to copy dependencies for interpreter: {}", (Object)setting.getName());
                for (Dependency d : deps) {
                    File destDir = new File(this.conf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO));
                    int numSplits = d.getGroupArtifactVersion().split(":").length;
                    if (numSplits >= 3 && numSplits <= 6) continue;
                    this.dependencyResolver.copyLocalDependency(d.getGroupArtifactVersion(), new File(destDir, setting.getId()));
                }
                LOGGER.info("Finish copy dependencies for interpreter: {}", (Object)setting.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error while copying deps for interpreter group : %s, go to interpreter setting page click on edit and save it again to make this interpreter work properly.", setting.getGroup()), (Throwable)e);
            setting.setErrorReason(e.getLocalizedMessage());
            setting.setStatus(InterpreterSetting.Status.ERROR);
        }
    }

    public List<String> getInterpreterSettingIds() {
        ArrayList<String> settingIdList = new ArrayList<String>();
        for (InterpreterSetting interpreterSetting : this.get()) {
            settingIdList.add(interpreterSetting.getId());
        }
        return settingIdList;
    }

    public InterpreterSetting createNewSetting(String name, String group, List<Dependency> dependencies, InterpreterOption option, Map<String, InterpreterProperty> properties) throws IOException {
        InterpreterSetting interpreterSetting = null;
        try {
            interpreterSetting = this.inlineCreateNewSetting(name, group, dependencies, option, properties);
            this.broadcastClusterEvent(ClusterEvent.CREATE_INTP_SETTING, interpreterSetting);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return interpreterSetting;
    }

    private InterpreterSetting inlineCreateNewSetting(String name, String group, List<Dependency> dependencies, InterpreterOption option, Map<String, InterpreterProperty> properties) throws IOException {
        if (name == null) {
            throw new IOException("Interpreter name shouldn't be empty.");
        }
        Matcher matcher = VALID_INTERPRETER_NAME.matcher(name);
        if (!matcher.find()) {
            throw new IOException("Interpreter name shouldn't be empty, and can consist only of: -_a-zA-Z0-9");
        }
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            if (!interpreterSetting.getName().equals(name)) continue;
            throw new IOException("Interpreter " + name + " already existed");
        }
        InterpreterSetting setting = new InterpreterSetting(this.interpreterSettingTemplates.get(group));
        setting.setName(name);
        setting.setGroup(group);
        setting.appendDependencies(dependencies);
        setting.setInterpreterOption(option);
        setting.setProperties(properties);
        this.initInterpreterSetting(setting);
        this.addInterpreterSetting(setting);
        this.saveToFile();
        return setting;
    }

    public Map<String, InterpreterSetting> getInterpreterSettingTemplates() {
        return this.interpreterSettingTemplates;
    }

    private URL[] recursiveBuildLibList(File path) throws MalformedURLException {
        Object[] urls = new URL[]{};
        if (path == null || !path.exists()) {
            return urls;
        }
        if (path.getName().startsWith(".")) {
            return urls;
        }
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])this.recursiveBuildLibList(f));
                }
            }
            return urls;
        }
        return new URL[]{path.toURI().toURL()};
    }

    public List<RemoteRepository> getRepositories() {
        return this.interpreterRepositories;
    }

    public void addRepository(String id, String url, boolean snapshot, Authentication auth, Proxy proxy) throws IOException {
        this.dependencyResolver.addRepo(id, url, snapshot, auth, proxy);
        this.saveToFile();
    }

    public void removeRepository(String id) throws IOException {
        this.dependencyResolver.delRepo(id);
        this.saveToFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterpreterSetting inlineSetPropertyAndRestart(String id, InterpreterOption option, Map<String, InterpreterProperty> properties, List<Dependency> dependencies, boolean initiator) throws InterpreterException, IOException {
        InterpreterSetting intpSetting = this.interpreterSettings.get(id);
        if (intpSetting == null) throw new InterpreterException("Interpreter setting id " + id + " not found");
        try {
            intpSetting.close();
            intpSetting.setOption(option);
            intpSetting.setProperties(properties);
            intpSetting.setDependencies(dependencies);
            intpSetting.postProcessing();
            if (!initiator) return intpSetting;
            this.saveToFile();
            return intpSetting;
        }
        catch (Exception e) {
            this.loadFromFile();
            throw new IOException(e);
        }
    }

    public void setPropertyAndRestart(String id, InterpreterOption option, Map<String, InterpreterProperty> properties, List<Dependency> dependencies) throws InterpreterException, IOException {
        InterpreterSetting intpSetting = this.inlineSetPropertyAndRestart(id, option, properties, dependencies, true);
        this.broadcastClusterEvent(ClusterEvent.UPDATE_INTP_SETTING, intpSetting);
    }

    public void restart(String settingId, String user, String noteId) throws InterpreterException {
        try {
            Note note = this.notebook.getNote(noteId);
            if (note == null) {
                throw new InterpreterException("No such note: " + noteId);
            }
            ExecutionContext executionContext = note.getExecutionContext();
            executionContext.setUser(user);
            this.restart(settingId, executionContext);
        }
        catch (IOException e) {
            LOGGER.warn("Fail to restart interpreter", (Throwable)e);
        }
    }

    public void restart(String settingId, ExecutionContext executionContext) throws InterpreterException {
        InterpreterSetting intpSetting = this.interpreterSettings.get(settingId);
        Preconditions.checkNotNull((Object)intpSetting);
        intpSetting = this.interpreterSettings.get(settingId);
        if (intpSetting == null) {
            throw new InterpreterException("Interpreter setting id " + settingId + " not found");
        }
        this.copyDependenciesFromLocalPath(intpSetting);
        intpSetting.closeInterpreters(executionContext);
    }

    @VisibleForTesting
    public void restart(String id) throws InterpreterException {
        InterpreterSetting setting = this.interpreterSettings.get(id);
        this.copyDependenciesFromLocalPath(setting);
        setting.close();
    }

    public InterpreterSetting get(String id) {
        return this.interpreterSettings.get(id);
    }

    @VisibleForTesting
    public InterpreterSetting getByName(String name) {
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            if (!interpreterSetting.getName().equals(name)) continue;
            return interpreterSetting;
        }
        return null;
    }

    public void remove(String id) throws IOException {
        boolean removed = this.inlineRemove(id, true);
        if (removed) {
            InterpreterSetting intpSetting = new InterpreterSetting();
            intpSetting.setId(id);
            this.broadcastClusterEvent(ClusterEvent.DELETE_INTP_SETTING, intpSetting);
        }
    }

    private boolean inlineRemove(String id, boolean initiator) throws IOException {
        boolean removed = false;
        LOGGER.info("Remove interpreter setting: {}", (Object)id);
        if (this.interpreterSettings.containsKey(id)) {
            InterpreterSetting intp = this.interpreterSettings.get(id);
            intp.close();
            this.removeInterpreterSetting(id);
            if (initiator) {
                this.saveToFile();
            }
            removed = true;
        }
        File localRepoDir = new File(this.conf.getInterpreterLocalRepoPath() + "/" + id);
        FileUtils.deleteDirectory((File)localRepoDir);
        return removed;
    }

    public List<InterpreterSetting> get() {
        ArrayList<InterpreterSetting> orderedSettings = new ArrayList<InterpreterSetting>(this.interpreterSettings.values());
        Collections.sort(orderedSettings, new Comparator<InterpreterSetting>(){

            @Override
            public int compare(InterpreterSetting o1, InterpreterSetting o2) {
                if (o1.getName().equals(InterpreterSettingManager.this.defaultInterpreterGroup)) {
                    return -1;
                }
                if (o2.getName().equals(InterpreterSettingManager.this.defaultInterpreterGroup)) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return orderedSettings;
    }

    public InterpreterSetting getDefaultInterpreterSetting() {
        InterpreterSetting setting = this.getByName(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT));
        if (setting != null) {
            return setting;
        }
        return this.get().get(0);
    }

    @VisibleForTesting
    public List<String> getSettingIds() {
        ArrayList<String> settingIds = new ArrayList<String>();
        for (InterpreterSetting interpreterSetting : this.get()) {
            settingIds.add(interpreterSetting.getId());
        }
        return settingIds;
    }

    public void close(String settingId) {
        this.get(settingId).close();
    }

    public void close() {
        List closeThreads = this.interpreterSettings.values().stream().map(intpSetting -> new Thread(intpSetting::close, intpSetting.getId() + "-close")).peek(t -> t.setUncaughtExceptionHandler((th, e) -> LOGGER.error("interpreterGroup close error", e))).peek(Thread::start).collect(Collectors.toList());
        for (Thread t2 : closeThreads) {
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Can't wait close interpreterGroup threads", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @ManagedAttribute
    public Set<String> getRunningInterpreters() {
        HashSet runningInterpreters = Sets.newHashSet();
        for (Map.Entry<String, InterpreterSetting> entry : this.interpreterSettings.entrySet()) {
            for (ManagedInterpreterGroup mig : entry.getValue().getAllInterpreterGroups()) {
                if (null == mig.getRemoteInterpreterProcess()) continue;
                runningInterpreters.add(entry.getKey());
            }
        }
        return runningInterpreters;
    }

    @Override
    public void onNoteRemove(Note note, AuthenticationInfo subject) throws IOException {
        if (note.getParagraphs() != null) {
            for (Paragraph paragraph : note.getParagraphs()) {
                try {
                    Interpreter interpreter = paragraph.getInterpreter();
                    if (interpreter == null) continue;
                    InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)interpreter.getInterpreterGroup()).getInterpreterSetting();
                    ExecutionContext executionContext = note.getExecutionContext();
                    executionContext.setUser(subject.getUser());
                    this.restart(interpreterSetting.getId(), executionContext);
                }
                catch (InterpreterNotFoundException interpreter) {
                }
                catch (InterpreterException e) {
                    LOGGER.warn("Fail to stop interpreter setting", (Throwable)e);
                }
            }
        }
        for (InterpreterSetting settings : this.interpreterSettings.values()) {
            List<ApplicationState> appStates;
            ManagedInterpreterGroup interpreterGroup = settings.getInterpreterGroup(note.getExecutionContext());
            if (interpreterGroup == null) continue;
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                for (Paragraph p : note.getParagraphs()) {
                    ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(note.getId(), p.getId());
                    appStates = p.getAllApplicationStates();
                    if (appStates == null) continue;
                    for (ApplicationState app : appStates) {
                        ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(note.getId(), app.getId());
                    }
                }
                ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(note.getId(), null);
                continue;
            }
            for (Paragraph p : note.getParagraphs()) {
                registry.removeAll(note.getId(), p.getId());
                appStates = p.getAllApplicationStates();
                if (appStates == null) continue;
                for (ApplicationState app : appStates) {
                    registry.removeAll(note.getId(), app.getId());
                }
            }
            registry.removeAll(note.getId(), null);
        }
        this.removeResourcesBelongsToNote(note.getId());
    }

    @Override
    public void onNoteCreate(Note note, AuthenticationInfo subject) throws IOException {
    }

    @Override
    public void onNoteUpdate(Note note, AuthenticationInfo subject) throws IOException {
    }

    @Override
    public void onParagraphRemove(Paragraph p) throws IOException {
    }

    @Override
    public void onParagraphCreate(Paragraph p) throws IOException {
    }

    @Override
    public void onParagraphUpdate(Paragraph p) throws IOException {
    }

    @Override
    public void onParagraphStatusChange(Paragraph p, Job.Status status) throws IOException {
    }

    public void onClusterEvent(String msg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onClusterEvent : {}", (Object)msg);
        }
        try {
            ClusterMessage message = ClusterMessage.deserializeMessage((String)msg);
            String jsonIntpSetting = message.get("intpSetting");
            InterpreterSetting intpSetting = InterpreterSetting.fromJson(jsonIntpSetting);
            String id = intpSetting.getId();
            String name = intpSetting.getName();
            String group = intpSetting.getGroup();
            InterpreterOption option = intpSetting.getOption();
            HashMap properties = (HashMap)InterpreterSetting.convertInterpreterProperties(intpSetting.getProperties());
            List<Dependency> dependencies = intpSetting.getDependencies();
            switch (message.clusterEvent) {
                case CREATE_INTP_SETTING: {
                    this.inlineCreateNewSetting(name, group, dependencies, option, properties);
                    break;
                }
                case UPDATE_INTP_SETTING: {
                    this.inlineSetPropertyAndRestart(id, option, properties, dependencies, false);
                    break;
                }
                case DELETE_INTP_SETTING: {
                    this.inlineRemove(id, false);
                    break;
                }
                default: {
                    LOGGER.error("Unknown clusterEvent:{}, msg:{} ", (Object)message.clusterEvent, (Object)msg);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (InterpreterException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void broadcastClusterEvent(ClusterEvent event, InterpreterSetting intpSetting) {
        if (!this.conf.isClusterMode()) {
            return;
        }
        String jsonIntpSetting = InterpreterSetting.toJson(intpSetting);
        ClusterMessage message = new ClusterMessage(event);
        message.put("intpSetting", jsonIntpSetting);
        String msg = ClusterMessage.serializeMessage((ClusterMessage)message);
        ClusterManagerServer.getInstance((ZeppelinConfiguration)this.conf).broadcastClusterEvent(ClusterManagerServer.CLUSTER_INTP_SETTING_EVENT_TOPIC, msg);
    }
}

