/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.roles;

import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.impl.DefaultBackupOutput;
import io.atomix.primitive.service.impl.DefaultCommit;
import io.atomix.primitive.session.Session;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import io.atomix.protocols.backup.protocol.CloseOperation;
import io.atomix.protocols.backup.protocol.ExecuteOperation;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.ExpireOperation;
import io.atomix.protocols.backup.protocol.HeartbeatOperation;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.roles.AsynchronousReplicator;
import io.atomix.protocols.backup.roles.PrimaryBackupRole;
import io.atomix.protocols.backup.roles.Replicator;
import io.atomix.protocols.backup.roles.SynchronousReplicator;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.storage.buffer.BufferOutput;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class PrimaryRole
extends PrimaryBackupRole {
    private static final long HEARTBEAT_FREQUENCY = 1000L;
    private final Replicator replicator;
    private Scheduled heartbeatTimer;

    public PrimaryRole(PrimaryBackupServiceContext context) {
        super(PrimaryBackupServer.Role.PRIMARY, context);
        this.heartbeatTimer = context.threadContext().schedule(Duration.ofMillis(1000L), Duration.ofMillis(1000L), this::heartbeat);
        switch (context.descriptor().replication()) {
            case SYNCHRONOUS: {
                this.replicator = new SynchronousReplicator(context, this.log);
                break;
            }
            case ASYNCHRONOUS: {
                this.replicator = new AsynchronousReplicator(context, this.log);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void heartbeat() {
        long index = this.context.nextIndex();
        long timestamp = System.currentTimeMillis();
        this.replicator.replicate(new HeartbeatOperation(index, timestamp)).thenRun(() -> this.context.setTimestamp(timestamp));
    }

    @Override
    public CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        this.logRequest(request);
        if (request.operation().id().type() == OperationType.COMMAND) {
            return this.executeCommand(request).thenApply(this::logResponse);
        }
        if (request.operation().id().type() == OperationType.QUERY) {
            return this.executeQuery(request).thenApply(this::logResponse);
        }
        return Futures.exceptionalFuture((Throwable)new IllegalArgumentException("Unknown operation type"));
    }

    private CompletableFuture<ExecuteResponse> executeCommand(ExecuteRequest request) {
        PrimaryBackupSession session = this.context.getOrCreateSession(request.session(), request.node());
        long index = this.context.nextIndex();
        long timestamp = System.currentTimeMillis();
        return this.replicator.replicate(new ExecuteOperation(index, timestamp, (Long)session.sessionId().id(), session.memberId(), request.operation())).thenApply(v -> {
            try {
                byte[] result = this.context.service().apply((Commit)new DefaultCommit(this.context.setIndex(index), request.operation().id(), (Object)request.operation().value(), this.context.setSession((Session)session), this.context.setTimestamp(timestamp)));
                ExecuteResponse executeResponse = ExecuteResponse.ok(result);
                return executeResponse;
            }
            catch (Exception e) {
                ExecuteResponse executeResponse = ExecuteResponse.error();
                return executeResponse;
            }
            finally {
                this.context.setSession(null);
            }
        });
    }

    private CompletableFuture<ExecuteResponse> executeQuery(ExecuteRequest request) {
        PrimaryBackupSession session = this.context.getSession(request.session());
        if (session == null) {
            PrimaryBackupSession newSession = this.context.createSession(request.session(), request.node());
            long index = this.context.nextIndex();
            long timestamp = System.currentTimeMillis();
            return this.replicator.replicate(new ExecuteOperation(index, timestamp, (Long)newSession.sessionId().id(), newSession.memberId(), null)).thenApply(arg_0 -> this.lambda$executeQuery$2(index, timestamp, request, (Session)newSession, arg_0));
        }
        return CompletableFuture.completedFuture(this.applyQuery(request, (Session)session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteResponse applyQuery(ExecuteRequest request, Session session) {
        try {
            byte[] result = this.context.service().apply((Commit)new DefaultCommit(this.context.getIndex(), request.operation().id(), (Object)request.operation().value(), this.context.setSession(session), this.context.currentTimestamp()));
            ExecuteResponse executeResponse = ExecuteResponse.ok(result);
            return executeResponse;
        }
        catch (Exception e) {
            ExecuteResponse executeResponse = ExecuteResponse.error();
            return executeResponse;
        }
        finally {
            this.context.setSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        this.logRequest(request);
        if (request.term() != this.context.currentTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(RestoreResponse.error()));
        }
        HeapBuffer buffer = HeapBuffer.allocate();
        try {
            Collection<PrimaryBackupSession> sessions = this.context.getSessions();
            buffer.writeInt(sessions.size());
            for (Session completionStage : sessions) {
                buffer.writeLong(((Long)completionStage.sessionId().id()).longValue());
                buffer.writeString((String)((Object)completionStage.memberId().id()));
            }
            this.context.service().backup((BackupOutput)new DefaultBackupOutput((BufferOutput)buffer, this.context.service().serializer()));
            buffer.flip();
            byte[] bytes = buffer.readBytes(buffer.remaining());
            CompletionStage completionStage = CompletableFuture.completedFuture(RestoreResponse.ok(this.context.currentIndex(), this.context.currentTimestamp(), bytes)).thenApply(this::logResponse);
            return completionStage;
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public CompletableFuture<Void> expire(PrimaryBackupSession session) {
        long index = this.context.nextIndex();
        long timestamp = System.currentTimeMillis();
        return this.replicator.replicate(new ExpireOperation(index, timestamp, (long)((Long)session.sessionId().id()))).thenRun(() -> {
            this.context.setTimestamp(timestamp);
            this.context.expireSession((Long)session.sessionId().id());
        });
    }

    @Override
    public CompletableFuture<Void> close(PrimaryBackupSession session) {
        long index = this.context.nextIndex();
        long timestamp = System.currentTimeMillis();
        return this.replicator.replicate(new CloseOperation(index, timestamp, (long)((Long)session.sessionId().id()))).thenRun(() -> {
            this.context.setTimestamp(timestamp);
            this.context.closeSession((Long)session.sessionId().id());
        });
    }

    @Override
    public void close() {
        this.replicator.close();
        this.heartbeatTimer.cancel();
    }

    private /* synthetic */ ExecuteResponse lambda$executeQuery$2(long index, long timestamp, ExecuteRequest request, Session newSession, Void v) {
        this.context.setIndex(index);
        this.context.setTimestamp(timestamp);
        return this.applyQuery(request, newSession);
    }
}

