/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getCaptureKind", "Lorg/jetbrains/kotlin/types/expressions/CaptureKind;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "variableParent", "isCapturedVariable", "", "isExactlyOnceContract", "bindingContext", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "frontend"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        VariableDescriptor variableDescriptor;
        Object obj;
        ResolvedCall<?> variableResolvedCall;
        ResolvedCall<?> resolvedCall3;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<?> resolvedCall4 = resolvedCall2;
        if (!(resolvedCall4 instanceof VariableAsFunctionResolvedCall)) {
            resolvedCall4 = null;
        }
        if ((resolvedCall3 = (VariableAsFunctionResolvedCall)((Object)resolvedCall4)) == null || (resolvedCall3 = resolvedCall3.getVariableCall()) == null) {
            resolvedCall3 = variableResolvedCall = resolvedCall2;
        }
        if (!((obj = variableResolvedCall.getResultingDescriptor()) instanceof VariableDescriptor)) {
            obj = null;
        }
        if ((variableDescriptor = (VariableDescriptor)obj) != null) {
            this.checkCapturingInClosure(variableDescriptor, context2.getTrace(), context2.getScope());
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable2, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor declarationDescriptor = variable2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variable.containingDeclaration");
        DeclarationDescriptor variableParent = declarationDescriptor;
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        if (this.isCapturedVariable(variableParent, scopeContainer) && (CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2)) != CaptureKind.NOT_INLINE) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, this.getCaptureKind(bindingContext, scopeContainer, variableParent));
        }
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "variableParent.containingDeclaration");
            ClassifierDescriptorWithTypeParameters classDescriptor2 = classifierDescriptorWithTypeParameters;
            if (Intrinsics.areEqual(scopeContainer, classDescriptor2)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    private final CaptureKind getCaptureKind(BindingContext context2, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return CaptureKind.NOT_INLINE;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        boolean exactlyOnceContract = this.isExactlyOnceContract(context2, (KtFunction)psiElement);
        if (InlineUtil.isInlinedArgument((KtFunction)scopeDeclaration, context2, exactlyOnceContract)) {
            DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
            if (declarationDescriptor == null) {
                String string = "parent is null for " + scopeContainer;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "scopeContainer.containin\u2026ull for $scopeContainer\")");
            DeclarationDescriptor scopeContainerParent = declarationDescriptor;
            return !this.isCapturedVariable(variableParent, scopeContainerParent) || this.getCaptureKind(context2, scopeContainerParent, variableParent) == CaptureKind.INLINE_ONLY ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE;
        }
        if (exactlyOnceContract) {
            return CaptureKind.EXACTLY_ONCE_EFFECT;
        }
        return CaptureKind.NOT_INLINE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceContract(BindingContext bindingContext, KtFunction argument) {
        Iterator iterator2;
        block9: {
            void $this$filterIsInstanceTo$iv$iv;
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent(argument);
            if (ktExpression == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "KtPsiUtil.getParentCallI\u2026argument) ?: return false");
            KtExpression call2 = ktExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
            Call call3 = resolvedCall3.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call3, argument);
            if (valueArgument == null) {
                return false;
            }
            ValueArgument valueArgument2 = valueArgument;
            ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument2);
            if (!(argumentMapping instanceof ArgumentMatch)) {
                argumentMapping = null;
            }
            ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
            if (argumentMatch == null) {
                return false;
            }
            ArgumentMatch mapping2 = argumentMatch;
            ValueParameterDescriptor parameter = mapping2.getValueParameter();
            Object object = (AbstractContractProvider)descriptor2.getUserData(ContractProviderKey.INSTANCE);
            if (object == null || (object = ((AbstractContractProvider)object).getContractDescription()) == null) {
                return false;
            }
            Object contractDescription = object;
            Iterable $this$filterIsInstance$iv = ((ContractDescription)contractDescription).getEffects();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallsEffectDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator3 : iterable) {
                CallsEffectDeclaration it = (CallsEffectDeclaration)((Object)iterator3);
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getVariableReference().getDescriptor(), parameter)) continue;
                iterator2 = iterator3;
                break block9;
            }
            iterator2 = null;
        }
        CallsEffectDeclaration callsEffectDeclaration = (CallsEffectDeclaration)((Object)iterator2);
        if (callsEffectDeclaration == null) {
            return false;
        }
        CallsEffectDeclaration effect = callsEffectDeclaration;
        return effect.getKind() == InvocationKind.EXACTLY_ONCE;
    }
}

