/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"BUILT_IN_FUNCTION_ARITY_COUNT", "", "BUILT_IN_FUNCTION_CLASS_COUNT", "BUILT_IN_UNIQ_ID_CLASS_OFFSET", "BUILT_IN_UNIQ_ID_GAP", "PUBLIC_LOCAL_UNIQ_ID_EDGE", "", "functionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "functionalPackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinFqn", "builtInFunctionId", "value", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "builtInOffset", "function", "Lorg/jetbrains/kotlin/builtins/functions/FunctionInvokeDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isBuiltInFunction", "", "ir.serialization.js"})
public final class JsDeclarationTableUtilsKt {
    private static final Pattern functionPattern = Pattern.compile("^K?(Suspend)?Function\\d+$");
    private static final FqName kotlinFqn = new FqName("kotlin");
    private static final List<FqName> functionalPackages;
    public static final long PUBLIC_LOCAL_UNIQ_ID_EDGE = Long.MIN_VALUE;
    public static final int BUILT_IN_FUNCTION_CLASS_COUNT = 4;
    public static final int BUILT_IN_FUNCTION_ARITY_COUNT = 256;
    public static final int BUILT_IN_UNIQ_ID_GAP = 2048;
    public static final int BUILT_IN_UNIQ_ID_CLASS_OFFSET = 1024;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull IrDeclaration value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        IrDeclaration irDeclaration = value;
        if (irDeclaration instanceof IrSimpleFunction) {
            if (!Intrinsics.areEqual(((IrSimpleFunction)value).getName().asString(), "invoke")) return false;
            IrDeclarationParent irDeclarationParent = value.getParent();
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) return false;
            IrClass irClass2 = irClass;
            boolean bl = false;
            boolean bl2 = false;
            IrClass it = irClass2;
            boolean bl3 = false;
            if (!JsDeclarationTableUtilsKt.isBuiltInFunction(it)) return false;
            return true;
        }
        if (!(irDeclaration instanceof IrClass)) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)value);
        if (!CollectionsKt.contains((Iterable)functionalPackages, fqName2 != null ? fqName2.parent() : null)) return false;
        String string = ((IrClass)value).getName().asString();
        boolean bl = false;
        boolean bl4 = false;
        String it = string;
        boolean bl5 = false;
        if (!functionPattern.matcher(it).find()) return false;
        return true;
    }

    private static final long builtInOffset(IrSimpleFunction function2) {
        String string = IrUtilsKt.getParentAsClass(function2).getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "function.parentAsClass.name.asString()");
        boolean isK = StringsKt.startsWith$default(string, "K", false, 2, null);
        return isK && function2.isSuspend() ? 3L : (isK ? 2L : (function2.isSuspend() ? 1L : 0L));
    }

    /*
     * WARNING - void declaration
     */
    public static final long builtInFunctionId(@NotNull IrDeclaration value) {
        long l;
        Intrinsics.checkParameterIsNotNull(value, "value");
        IrDeclaration irDeclaration = value;
        if (irDeclaration instanceof IrSimpleFunction) {
            IrDeclaration irDeclaration2 = value;
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleFunction $this$run = (IrSimpleFunction)irDeclaration2;
            boolean bl3 = false;
            l = (long)$this$run.getValueParameters().size() + JsDeclarationTableUtilsKt.builtInOffset((IrSimpleFunction)value) * (long)256;
        } else if (irDeclaration instanceof IrClass) {
            Object element$iv2;
            long l2;
            block5: {
                void $this$first$iv;
                Iterable iterable = ((IrClass)value).getDeclarations();
                l2 = 1024;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), "invoke")) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            l = l2 + JsDeclarationTableUtilsKt.builtInFunctionId((IrDeclaration)t);
        } else {
            String string = "Only class or function is expected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuiltInFunction(@NotNull DeclarationDescriptor value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        DeclarationDescriptor declarationDescriptor = value;
        if (!(declarationDescriptor instanceof FunctionInvokeDescriptor)) {
            FqName it;
            if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
            DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)value).getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor2 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor2;
            FqName fqn = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
            Iterable $this$any$iv = functionalPackages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FqName)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual(it, fqn));
            boolean bl = true;
            if (!bl) return false;
            String string = ((ClassDescriptor)value).getName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string;
            boolean bl4 = false;
            if (!functionPattern.matcher(it2).find()) return false;
            return true;
        }
        DeclarationDescriptor declarationDescriptor3 = ((FunctionInvokeDescriptor)value).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "value.containingDeclaration");
        boolean bl = JsDeclarationTableUtilsKt.isBuiltInFunction(declarationDescriptor3);
        return bl;
    }

    private static final long builtInOffset(FunctionInvokeDescriptor function2) {
        DeclarationDescriptor declarationDescriptor = function2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "function.containingDeclaration");
        String string = declarationDescriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "function.containingDeclaration.name.asString()");
        boolean isK = StringsKt.startsWith$default(string, "K", false, 2, null);
        return isK && function2.isSuspend() ? 3L : (isK ? 2L : (function2.isSuspend() ? 1L : 0L));
    }

    /*
     * WARNING - void declaration
     */
    public static final long builtInFunctionId(@NotNull DeclarationDescriptor value) {
        long l;
        Intrinsics.checkParameterIsNotNull(value, "value");
        DeclarationDescriptor declarationDescriptor = value;
        if (declarationDescriptor instanceof FunctionInvokeDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = value;
            boolean bl = false;
            boolean bl2 = false;
            FunctionInvokeDescriptor $this$run = (FunctionInvokeDescriptor)declarationDescriptor2;
            boolean bl3 = false;
            l = (long)$this$run.getValueParameters().size() + JsDeclarationTableUtilsKt.builtInOffset((FunctionInvokeDescriptor)value) * (long)256;
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            Object element$iv$iv$iv2;
            long l2;
            block5: {
                void name$iv;
                void $this$findFirstFunction$iv;
                ClassDescriptor classDescriptor2 = (ClassDescriptor)value;
                String string = "invoke";
                l2 = 1024;
                boolean $i$f$findFirstFunction = false;
                MemberScope memberScope2 = $this$findFirstFunction$iv.getUnsubstitutedMemberScope();
                Intrinsics.checkExpressionValueIsNotNull(memberScope2, "unsubstitutedMemberScope");
                MemberScope $this$findFirstFunction$iv$iv = memberScope2;
                boolean $i$f$findFirstFunction2 = false;
                Name name2 = Name.identifier((String)name$iv);
                Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(name)");
                Iterable $this$first$iv$iv$iv = $this$findFirstFunction$iv$iv.getContributedFunctions(name2, NoLookupLocation.FROM_BACKEND);
                boolean $i$f$first = false;
                for (Object element$iv$iv$iv2 : $this$first$iv$iv$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv$iv2;
                    boolean bl = false;
                    if (!true) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)element$iv$iv$iv2;
            l = l2 + JsDeclarationTableUtilsKt.builtInFunctionId(simpleFunctionDescriptor);
        } else {
            String string = "Only class or function is expected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return l;
    }

    static {
        FqName[] fqNameArray = new FqName[3];
        fqNameArray[0] = kotlinFqn;
        FqName fqName2 = kotlinFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinFqn.child(Name.identifier(\"coroutines\"))");
        fqNameArray[1] = fqName2;
        FqName fqName3 = kotlinFqn.child(Name.identifier("reflect"));
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinFqn.child(Name.identifier(\"reflect\"))");
        fqNameArray[2] = fqName3;
        functionalPackages = CollectionsKt.listOf(fqNameArray);
    }
}

