/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_MULTIFILE_CLASS", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_MULTIFILE_CLASS", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_MULTIFILE_CLASS_SHORT", "", "getJVM_MULTIFILE_CLASS_SHORT", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "JVM_NAME_SHORT", "getJVM_NAME_SHORT", "JVM_PACKAGE_NAME", "getJVM_PACKAGE_NAME", "JVM_PACKAGE_NAME_SHORT", "MULTIFILE_PART_NAME_DELIMITER", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getFacadeClassInternalName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInternalName", "getLiteralStringFromAnnotation", "annotation", "getPartFqNameForDeserialized", "descriptor", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    private static final FqName JVM_NAME;
    @NotNull
    private static final String JVM_NAME_SHORT;
    @NotNull
    private static final FqName JVM_MULTIFILE_CLASS;
    @NotNull
    private static final String JVM_MULTIFILE_CLASS_SHORT;
    @NotNull
    private static final FqName JVM_PACKAGE_NAME;
    private static final String JVM_PACKAGE_NAME_SHORT;
    public static final JvmFileClassUtil INSTANCE;

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getJVM_MULTIFILE_CLASS() {
        return JVM_MULTIFILE_CLASS;
    }

    @NotNull
    public final String getJVM_MULTIFILE_CLASS_SHORT() {
        return JVM_MULTIFILE_CLASS_SHORT;
    }

    @NotNull
    public final FqName getJVM_PACKAGE_NAME() {
        return JVM_PACKAGE_NAME;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (object == null || (object = ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars()) == null) {
            String string = "No implClassName for " + descriptor2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String getFacadeClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName());
    }

    private final String manglePartName(String facadeName, String fileName) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file2.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string = parsedAnnotations.getJvmName();
            if (string == null) {
                String string2 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "file.name");
                string = PackagePartClassUtils.getFilePartShortName(string2);
            }
            String simpleName2 = string;
            FqName fqName2 = ((FqName)packageFqName).child(Name.identifier(simpleName2));
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(Name.identifier(simpleName))");
            FqName facadeClassFqName = fqName2;
            if (parsedAnnotations.isMultifileClass()) {
                String string3 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull(string3, "file.name");
                FqName fqName3 = ((FqName)packageFqName).child(Name.identifier(INSTANCE.manglePartName(simpleName2, string3)));
                Intrinsics.checkExpressionValueIsNotNull(fqName3, "packageFqName.child(Name\u2026(simpleName, file.name)))");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(fqName3, facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            String string = file2.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_NAME_SHORT);
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        var4_3 = v0;
        var5_4 = this;
        var6_7 = false;
        var7_10 = false;
        p1 = var4_3;
        $i$a$-unknown-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v0 = var5_4.getLiteralStringFromAnnotation(p1);
        if (v0 != null) {
            var4_3 = v0;
            var5_5 = false;
            var6_7 = false;
            p1 = var4_3;
            $i$a$-unknown-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v1 = Name.isValidIdentifier((String)p1) ? var4_3 : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 = jvmName = null;
        }
        if ((v2 = (jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_PACKAGE_NAME_SHORT))) == null) ** GOTO lbl-1000
        var6_8 = v2;
        var7_12 = this;
        var8_16 = false;
        $i$a$-unknown-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        p1 = var6_8;
        $i$a$-unknown-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v2 = var7_12.getLiteralStringFromAnnotation(p1);
        if (v2 != null) {
            var6_8 = v2;
            var7_13 = false;
            var8_16 = false;
            p1 = var6_8;
            $i$a$-unknown-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v3 = new FqName((String)p1);
        } else lbl-1000:
        // 2 sources

        {
            v3 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_MULTIFILE_CLASS_SHORT) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(shortName, "shortName");
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v3;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtAnnotationEntry ktAnnotationEntry2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry2, "it");
                    KtExpression ktExpression = ktAnnotationEntry2.getCalleeExpression();
                    if (!Intrinsics.areEqual(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null, shortName)) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            ktAnnotationEntry = v3;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    private final String getLiteralStringFromAnnotation(KtAnnotationEntry annotation2) {
        List<? extends ValueArgument> list2 = annotation2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "annotation.valueArguments");
        Object object = CollectionsKt.firstOrNull(list2);
        if (object == null || (object = object.getArgumentExpression()) == null) {
            return null;
        }
        Object argumentExpression = object;
        Object object2 = argumentExpression;
        if (!(object2 instanceof KtStringTemplateExpression)) {
            object2 = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)object2;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = stringTemplate.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(ktStringTemplateEntryArray, "stringTemplate.entries");
        KtStringTemplateEntry ktStringTemplateEntry = ArraysKt.singleOrNull(ktStringTemplateEntryArray);
        if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
            ktStringTemplateEntry = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry;
        if (ktLiteralStringTemplateEntry == null) {
            return null;
        }
        KtLiteralStringTemplateEntry singleEntry = ktLiteralStringTemplateEntry;
        return singleEntry.getText();
    }

    private JvmFileClassUtil() {
    }

    static {
        JvmFileClassUtil jvmFileClassUtil;
        INSTANCE = jvmFileClassUtil = new JvmFileClassUtil();
        JVM_NAME = new FqName("kotlin.jvm.JvmName");
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
        JVM_MULTIFILE_CLASS = new FqName("kotlin.jvm.JvmMultifileClass");
        String string2 = JVM_MULTIFILE_CLASS.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "JVM_MULTIFILE_CLASS.shortName().asString()");
        JVM_MULTIFILE_CLASS_SHORT = string2;
        JVM_PACKAGE_NAME = new FqName("kotlin.jvm.JvmPackageName");
        String string3 = JVM_PACKAGE_NAME.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "JVM_PACKAGE_NAME.shortName().asString()");
        JVM_PACKAGE_NAME_SHORT = string3;
    }
}

