/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report.experimental;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseAsync;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;
import org.jetbrains.kotlin.daemon.report.experimental.DaemonMessageReporterAsyncAsyncImpl;
import org.jetbrains.kotlin.daemon.report.experimental.DummyDaemonMessageReporterAsync;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"DaemonMessageReporterAsync", "Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBaseAsync;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "kotlin-daemon"})
public final class DaemonMessageReporterAsyncKt {
    @NotNull
    public static final DaemonMessageReporter DaemonMessageReporterAsync(@NotNull CompilerServicesFacadeBaseAsync servicesFacade, @NotNull CompilationOptions compilationOptions) {
        DaemonMessageReporter daemonMessageReporter;
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilationOptions, "compilationOptions");
        if (ArraysKt.contains(compilationOptions.getReportCategories(), Integer.valueOf(ReportCategory.DAEMON_MESSAGE.getCode()))) {
            ReportSeverity reportSeverity = ReportSeverity.Companion.fromCode(compilationOptions.getReportSeverity());
            if (reportSeverity == null) {
                Intrinsics.throwNpe();
            }
            ReportSeverity mySeverity = reportSeverity;
            daemonMessageReporter = new DaemonMessageReporterAsyncAsyncImpl(servicesFacade, mySeverity);
        } else {
            daemonMessageReporter = DummyDaemonMessageReporterAsync.INSTANCE;
        }
        return daemonMessageReporter;
    }
}

