/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.IntStack;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.OutboundSemiGraph;

public class DFSTBuilder<Node> {
    private final OutboundSemiGraph<Node> myGraph;
    private final TObjectIntHashMap<Node> myNodeToNNumber;
    private final Node[] myInvN;
    private Couple<Node> myBackEdge;
    private Comparator<Node> myNComparator;
    private Comparator<Node> myTComparator;
    private final TIntArrayList mySCCs;
    private final TObjectIntHashMap<Node> myNodeToTNumber;
    private final Node[] myInvT;
    private final Node[] myAllNodes;

    public DFSTBuilder(@NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(0);
        }
        this((Graph<Object>)graph2, null);
    }

    public DFSTBuilder(@NotNull Graph<Node> graph2, @Nullable Node entryNode) {
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(1);
        }
        this((OutboundSemiGraph<Node>)graph2, entryNode);
    }

    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph2, @Nullable Node entryNode) {
        int index2;
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(3);
        }
        this.mySCCs = new TIntArrayList();
        this.myNodeToTNumber = new TObjectIntHashMap();
        this.myAllNodes = graph2.getNodes().toArray();
        if (entryNode != null && (index2 = ArrayUtil.indexOf(this.myAllNodes, entryNode)) != -1) {
            ArrayUtil.swap(this.myAllNodes, 0, index2);
        }
        this.myGraph = graph2;
        int size = graph2.getNodes().size();
        this.myNodeToNNumber = new TObjectIntHashMap(size * 2, 0.5f);
        this.myInvN = new Object[size];
        this.myInvT = new Object[size];
        new Tarjan().build();
    }

    @NotNull
    public Comparator<Node> comparator() {
        Comparator<Node> comparator = this.comparator(this.isAcyclic());
        if (comparator == null) {
            DFSTBuilder.$$$reportNull$$$0(4);
        }
        return comparator;
    }

    @NotNull
    public Comparator<Node> comparator(boolean useNNumber) {
        if (useNNumber) {
            if (this.myNComparator == null) {
                this.myNComparator = Comparator.comparingInt(this.myNodeToNNumber::get);
            }
            Comparator<Node> comparator = this.myNComparator;
            if (comparator == null) {
                DFSTBuilder.$$$reportNull$$$0(5);
            }
            return comparator;
        }
        if (this.myTComparator == null) {
            this.myTComparator = Comparator.comparingInt(this.myNodeToTNumber::get);
        }
        Comparator<Node> comparator = this.myTComparator;
        if (comparator == null) {
            DFSTBuilder.$$$reportNull$$$0(6);
        }
        return comparator;
    }

    public Couple<Node> getCircularDependency() {
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    @NotNull
    public Node getNodeByTNumber(int n) {
        Node Node2 = this.myInvT[n];
        if (Node2 == null) {
            DFSTBuilder.$$$reportNull$$$0(8);
        }
        return Node2;
    }

    @NotNull
    public TIntArrayList getSCCs() {
        TIntArrayList tIntArrayList = this.mySCCs;
        if (tIntArrayList == null) {
            DFSTBuilder.$$$reportNull$$$0(9);
        }
        return tIntArrayList;
    }

    @NotNull
    public Collection<Collection<Node>> getComponents() {
        final TIntArrayList componentSizes = this.getSCCs();
        if (componentSizes.isEmpty()) {
            List<Collection<Node>> list2 = Collections.emptyList();
            if (list2 == null) {
                DFSTBuilder.$$$reportNull$$$0(10);
            }
            return list2;
        }
        MyCollection myCollection = new MyCollection<Collection<Node>>(componentSizes.size()){

            @Override
            @NotNull
            public Iterator<Collection<Node>> iterator() {
                MyIterator myIterator = new MyIterator<Collection<Node>>(componentSizes.size()){
                    private int offset;

                    @Override
                    protected Collection<Node> get(int i) {
                        final int cSize = componentSizes.get(i);
                        final int cOffset = this.offset;
                        if (cSize == 0) {
                            return Collections.emptyList();
                        }
                        this.offset += cSize;
                        return new MyCollection<Node>(cSize){

                            @Override
                            @NotNull
                            public Iterator<Node> iterator() {
                                MyIterator myIterator = new MyIterator<Node>(cSize){

                                    @Override
                                    public Node get(int i) {
                                        return DFSTBuilder.this.getNodeByTNumber(cOffset + i);
                                    }
                                };
                                if (myIterator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return myIterator;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/graph/DFSTBuilder$1$1$1", "iterator"));
                            }
                        };
                    }
                };
                if (myIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return myIterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/graph/DFSTBuilder$1", "iterator"));
            }
        };
        if (myCollection == null) {
            DFSTBuilder.$$$reportNull$$$0(11);
        }
        return myCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/graph/DFSTBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/graph/DFSTBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "comparator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeByNNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeByTNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSCCs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyIterator<T>
    implements Iterator<T> {
        private final int size;
        private int i;

        protected MyIterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public T next() {
            if (this.i == this.size) {
                throw new NoSuchElementException();
            }
            return this.get(this.i++);
        }

        protected abstract T get(int var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class MyCollection<T>
    extends AbstractCollection<T> {
        private final int size;

        protected MyCollection(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private class Tarjan {
        private final int[] lowLink;
        private final int[] index;
        private final IntStack nodesOnStack;
        private final boolean[] isOnStack;
        private final Stack<org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder$Tarjan.Frame> frames;
        private final TObjectIntHashMap<Node> nodeIndex;
        private int dfsIndex;
        private int sccsSizeCombined;
        private final TIntArrayList topo;

        private Tarjan() {
            this.lowLink = new int[DFSTBuilder.this.myInvN.length];
            this.index = new int[DFSTBuilder.this.myInvN.length];
            this.nodesOnStack = new IntStack();
            this.isOnStack = new boolean[this.index.length];
            this.frames = new Stack();
            this.nodeIndex = new TObjectIntHashMap();
            this.topo = new TIntArrayList(this.index.length);
        }

        private void build() {
            int i;
            Arrays.fill(this.index, -1);
            for (i = 0; i < DFSTBuilder.this.myAllNodes.length; ++i) {
                Object node = DFSTBuilder.this.myAllNodes[i];
                this.nodeIndex.put(node, i);
            }
            for (i = 0; i < this.index.length; ++i) {
                if (this.index[i] != -1) continue;
                this.frames.push((org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(i));
                ArrayList sccs = new ArrayList();
                this.strongConnect(sccs);
                for (List scc : sccs) {
                    int sccSize = scc.size();
                    DFSTBuilder.this.mySCCs.add(sccSize);
                    int sccBase = this.index.length - this.sccsSizeCombined - sccSize;
                    Object rootNode = DFSTBuilder.this.myAllNodes[i];
                    int rIndex = scc.indexOf(rootNode);
                    if (rIndex != -1) {
                        ContainerUtil.swapElements(scc, rIndex, 0);
                    }
                    for (int j = 0; j < scc.size(); ++j) {
                        Object sccNode = scc.get(j);
                        int tIndex = sccBase + j;
                        ((DFSTBuilder)DFSTBuilder.this).myInvT[tIndex] = sccNode;
                        DFSTBuilder.this.myNodeToTNumber.put(sccNode, tIndex);
                    }
                    this.sccsSizeCombined += sccSize;
                }
            }
            for (i = 0; i < this.topo.size(); ++i) {
                int nodeI = this.topo.get(i);
                Object node = DFSTBuilder.this.myAllNodes[nodeI];
                DFSTBuilder.this.myNodeToNNumber.put(node, this.index.length - 1 - i);
                ((DFSTBuilder)DFSTBuilder.this).myInvN[this.index.length - 1 - i] = node;
            }
            DFSTBuilder.this.mySCCs.reverse();
        }

        private void strongConnect(@NotNull List<? super List<Node>> sccs) {
            if (sccs == null) {
                Tarjan.$$$reportNull$$$0(0);
            }
            int successor = -1;
            block0: while (!this.frames.isEmpty()) {
                int pushedI;
                Frame pair = (Frame)this.frames.peek();
                int i = pair.nodeI;
                if (this.index[i] == -1) {
                    this.index[i] = this.dfsIndex;
                    this.lowLink[i] = this.dfsIndex++;
                    this.nodesOnStack.push(i);
                    this.isOnStack[i] = true;
                }
                if (ArrayUtil.indexOf(pair.out, successor) != -1) {
                    this.lowLink[i] = Math.min(this.lowLink[i], this.lowLink[successor]);
                }
                successor = i;
                while (pair.nextUnexploredIndex < pair.out.length) {
                    int nextI = pair.out[pair.nextUnexploredIndex++];
                    if (this.index[nextI] == -1) {
                        this.frames.push((org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(nextI));
                        continue block0;
                    }
                    if (!this.isOnStack[nextI]) continue;
                    this.lowLink[i] = Math.min(this.lowLink[i], this.index[nextI]);
                    if (DFSTBuilder.this.myBackEdge != null) continue;
                    DFSTBuilder.this.myBackEdge = Couple.of(DFSTBuilder.this.myAllNodes[nextI], DFSTBuilder.this.myAllNodes[i]);
                }
                this.frames.pop();
                this.topo.add(i);
                if (this.lowLink[i] != this.index[i]) continue;
                ArrayList<Object> scc = new ArrayList<Object>();
                do {
                    pushedI = this.nodesOnStack.pop();
                    Object pushed = DFSTBuilder.this.myAllNodes[pushedI];
                    this.isOnStack[pushedI] = false;
                    scc.add(pushed);
                } while (pushedI != i);
                sccs.add(scc);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sccs", "org/jetbrains/kotlin/com/intellij/util/graph/DFSTBuilder$Tarjan", "strongConnect"));
        }

        private class Frame {
            private final int nodeI;
            private final int[] out;
            private int nextUnexploredIndex;

            Frame(int nodeI) {
                this.nodeI = nodeI;
                Iterator<Object> outNodes = DFSTBuilder.this.myGraph.getOut(DFSTBuilder.this.myAllNodes[nodeI]);
                TIntArrayList list2 = new TIntArrayList();
                while (outNodes.hasNext()) {
                    Object node = outNodes.next();
                    list2.add(Tarjan.this.nodeIndex.get(node));
                }
                this.out = list2.toNativeArray();
            }

            public String toString() {
                StringBuilder o = new StringBuilder();
                o.append(DFSTBuilder.this.myAllNodes[this.nodeI]).append(" -> [");
                for (int id : this.out) {
                    o.append(DFSTBuilder.this.myAllNodes[id]).append(", ");
                }
                return o.append(']').toString();
            }
        }
    }
}

