/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl.building;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Unit;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.jvm.BasicJvmScriptEvaluator;
import kotlin.script.experimental.jvm.JvmScriptCompilationConfigurationBuilder;
import kotlin.script.experimental.jvm.JvmScriptCompilationKt;
import kotlin.script.experimental.jvmhost.impl.JvmHostUtilKt;
import kotlin.script.experimental.jvmhost.repl.JvmReplCompiler;
import kotlin.script.experimental.jvmhost.repl.JvmReplEvaluator;
import org.apache.zeppelin.kotlin.context.KotlinReceiver;
import org.apache.zeppelin.kotlin.repl.building.KotlinReplProperties;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.KJvmReplCompilerImpl;

public class ReplBuilding {
    public static JvmReplCompiler buildCompiler(KotlinReplProperties properties2) {
        String receiverClassPath = properties2.getReceiver().getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        properties2.classPath(receiverClassPath);
        KJvmReplCompilerImpl compilerImpl = new KJvmReplCompilerImpl(JvmHostUtilKt.withDefaults(properties2.getHostConf()));
        return new JvmReplCompiler(ReplBuilding.buildCompilationConfiguration(properties2), properties2.getHostConf(), compilerImpl);
    }

    public static JvmReplEvaluator buildEvaluator(KotlinReplProperties properties2) {
        return new JvmReplEvaluator(ReplBuilding.buildEvaluationConfiguration(properties2), new BasicJvmScriptEvaluator());
    }

    private static String buildClassPath(KotlinReplProperties p) {
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (String path2 : p.getClasspath()) {
            if (path2 == null || path2.equals("")) continue;
            joiner.add(path2);
        }
        return joiner.toString();
    }

    private static ScriptCompilationConfiguration buildCompilationConfiguration(KotlinReplProperties p) {
        return new ScriptCompilationConfiguration(b -> {
            b.invoke(ScriptCompilationKt.getHostConfiguration(b), p.getHostConf());
            JvmScriptCompilationConfigurationBuilder jvmBuilder = JvmScriptCompilationKt.getJvm(b);
            JvmScriptCompilationKt.dependenciesFromCurrentContext(jvmBuilder, new String[0], true, false);
            List<String> compilerOptions = Arrays.asList("-classpath", ReplBuilding.buildClassPath(p));
            b.invoke(ScriptCompilationKt.getCompilerOptions(b), compilerOptions);
            KotlinType kt = new KotlinType(p.getReceiver().getClass().getCanonicalName());
            List<KotlinType> receivers = Collections.singletonList(kt);
            b.invoke(ScriptCompilationKt.getImplicitReceivers(b), receivers);
            return Unit.INSTANCE;
        });
    }

    private static ScriptEvaluationConfiguration buildEvaluationConfiguration(KotlinReplProperties p) {
        return new ScriptEvaluationConfiguration(b -> {
            b.invoke(ScriptEvaluationKt.getHostConfiguration(b), p.getHostConf());
            List<KotlinReceiver> receivers = Collections.singletonList(p.getReceiver());
            b.invoke(ScriptEvaluationKt.getImplicitReceivers(b), receivers);
            return Unit.INSTANCE;
        });
    }
}

