/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryElement;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;

public class CategoryExplorerModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -3413887384316015901L;
    protected boolean _renderFatal = true;
    protected ActionListener _listener = null;
    protected ActionEvent _event = new ActionEvent(this, 1001, "Nodes Selection changed");

    public CategoryExplorerModel(CategoryNode node) {
        super(node);
    }

    public void addLogRecord(LogRecord lr) {
        CategoryPath path2 = new CategoryPath(lr.getCategory());
        this.addCategory(path2);
        CategoryNode node = this.getCategoryNode(path2);
        node.addRecord();
        if (this._renderFatal && lr.isFatal()) {
            TreeNode[] nodes = this.getPathToRoot(node);
            int len = nodes.length;
            for (int i = 1; i < len - 1; ++i) {
                CategoryNode parent2 = (CategoryNode)nodes[i];
                parent2.setHasFatalChildren(true);
                this.nodeChanged(parent2);
            }
            node.setHasFatalRecords(true);
            this.nodeChanged(node);
        }
    }

    public CategoryNode getRootCategoryNode() {
        return (CategoryNode)this.getRoot();
    }

    public CategoryNode getCategoryNode(String category) {
        CategoryPath path2 = new CategoryPath(category);
        return this.getCategoryNode(path2);
    }

    public CategoryNode getCategoryNode(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        for (int i = 0; i < path2.size(); ++i) {
            CategoryElement element = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children2.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node;
                break;
            }
            if (categoryAlreadyExists) continue;
            return null;
        }
        return parent2;
    }

    public boolean isCategoryPathActive(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        boolean active = false;
        for (int i = 0; i < path2.size(); ++i) {
            CategoryElement element = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            active = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children2.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node;
                if (!parent2.isSelected()) break;
                active = true;
                break;
            }
            if (active && categoryAlreadyExists) continue;
            return false;
        }
        return active;
    }

    public CategoryNode addCategory(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        for (int i = 0; i < path2.size(); ++i) {
            CategoryElement element = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children2.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node;
                break;
            }
            if (categoryAlreadyExists) continue;
            CategoryNode newNode = new CategoryNode(element.getTitle());
            this.insertNodeInto(newNode, parent2, parent2.getChildCount());
            this.refresh(newNode);
            parent2 = newNode;
        }
        return parent2;
    }

    public void update(CategoryNode node, boolean selected) {
        if (node.isSelected() == selected) {
            return;
        }
        if (selected) {
            this.setParentSelection(node, true);
        } else {
            this.setDescendantSelection(node, false);
        }
    }

    public void setDescendantSelection(CategoryNode node, boolean selected) {
        Enumeration<TreeNode> descendants = node.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants.nextElement();
            if (current.isSelected() == selected) continue;
            current.setSelected(selected);
            this.nodeChanged(current);
        }
        this.notifyActionListeners();
    }

    public void setParentSelection(CategoryNode node, boolean selected) {
        TreeNode[] nodes = this.getPathToRoot(node);
        int len = nodes.length;
        for (int i = 1; i < len; ++i) {
            CategoryNode parent2 = (CategoryNode)nodes[i];
            if (parent2.isSelected() == selected) continue;
            parent2.setSelected(selected);
            this.nodeChanged(parent2);
        }
        this.notifyActionListeners();
    }

    public synchronized void addActionListener(ActionListener l) {
        this._listener = AWTEventMulticaster.add(this._listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this._listener = AWTEventMulticaster.remove(this._listener, l);
    }

    public void resetAllNodeCounts() {
        Enumeration<TreeNode> nodes = this.getRootCategoryNode().depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            CategoryNode current = (CategoryNode)nodes.nextElement();
            current.resetNumberOfContainedRecords();
            this.nodeChanged(current);
        }
    }

    public TreePath getTreePathToRoot(CategoryNode node) {
        if (node == null) {
            return null;
        }
        return new TreePath(this.getPathToRoot(node));
    }

    protected void notifyActionListeners() {
        if (this._listener != null) {
            this._listener.actionPerformed(this._event);
        }
    }

    protected void refresh(final CategoryNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CategoryExplorerModel.this.nodeChanged(node);
            }
        });
    }
}

