/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TObjectDoubleIterator;
import gnu.trove.TObjectDoubleProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectDoubleHashMap<K>
extends TObjectHash<K> {
    protected transient double[] _values;

    public TObjectDoubleHashMap() {
    }

    public TObjectDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectDoubleHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectDoubleHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectDoubleHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectDoubleIterator<K> iterator() {
        return new TObjectDoubleIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new double[capacity];
        return capacity;
    }

    public double put(K key, double value) {
        double previous = 0.0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        Object oldKey = this._set[index2];
        this._set[index2] = key;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        Object[] oldKeys = this._set;
        double[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new double[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public double get(K key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0.0 : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys2 = this._set;
        double[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = null;
            values2[i] = 0.0;
        }
    }

    public double remove(K key) {
        double prev = 0.0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectDoubleHashMap)) {
            return false;
        }
        TObjectDoubleHashMap that = (TObjectDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = 0.0;
        super.removeAt(index2);
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        Object[] keys2 = this._set;
        int i = keys2.length;
        int j = 0;
        while (i-- > 0) {
            if (keys2[i] == null || keys2[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys2 = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys2[j++] = k[i];
        }
        return keys2;
    }

    public boolean containsValue(double val) {
        Object[] keys2 = this._set;
        double[] vals = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (keys2[i] == null || keys2[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        Object[] keys2 = this._set;
        double[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (keys2[i] == null || keys2[i] == REMOVED || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectDoubleProcedure<K> procedure) {
        Object[] keys2 = this._set;
        double[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (keys2[i] == null || keys2[i] == REMOVED || procedure.execute(keys2[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectDoubleProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys2 = this._set;
        double[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = keys2.length;
            while (i-- > 0) {
                if (keys2[i] == null || keys2[i] == REMOVED || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TDoubleFunction function2) {
        Object[] keys2 = this._set;
        double[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (keys2[i] == null || keys2[i] == REMOVED) continue;
            values2[i] = function2.execute(values2[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(K key, double amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            double val = stream.readDouble();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TObjectDoubleProcedure<K>(){

            @Override
            public boolean execute(K key, double value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append((Object)(key == this ? "(this Map)" : key));
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TObjectDoubleProcedure<K> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(K key, double value) {
            this.h += TObjectDoubleHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<K>
    implements TObjectDoubleProcedure<K> {
        private final TObjectDoubleHashMap<K> _otherMap;

        EqProcedure(TObjectDoubleHashMap<K> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(K key, double value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(double v1, double v2) {
            return v1 == v2;
        }
    }
}

