/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.ObjectTruthValue;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Outputs inner content if expression evaluates to true, otherwise evaluates any elif blocks, finally outputting content of any else block present", snippets={@JinjavaSnippet(code="{% if condition %}\nIf the condition is true print this to template.\n{% endif %}"), @JinjavaSnippet(code="{% if number <= 2 %}\nVarible named number is less than or equal to 2.\n{% elif number <= 4 %}\nVarible named number is less than or equal to 4.\n{% elif number <= 6 %}\nVarible named number is less than or equal to 6.\n{% else %}\nVarible named number is greater than 6.\n{% endif %}")})
public class IfTag
implements Tag {
    private static final long serialVersionUID = -3784039314941268904L;
    private static final String TAGNAME = "if";
    private static final String ENDTAGNAME = "endif";

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (StringUtils.isBlank((CharSequence)tagNode.getHelpers())) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'if' expects expression", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        Iterator<Node> nodeIterator = tagNode.getChildren().iterator();
        TagNode nextIfElseTagNode = tagNode;
        while (nextIfElseTagNode != null && !this.evaluateIfElseTagNode(nextIfElseTagNode, interpreter)) {
            nextIfElseTagNode = this.findNextIfElseTagNode(nodeIterator);
        }
        LengthLimitingStringBuilder sb = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        if (nextIfElseTagNode != null) {
            Node n;
            while (nodeIterator.hasNext() && !(n = nodeIterator.next()).getName().equals("elif") && !n.getName().equals("else")) {
                sb.append(n.render(interpreter));
            }
        }
        return sb.toString();
    }

    private TagNode findNextIfElseTagNode(Iterator<Node> nodeIterator) {
        while (nodeIterator.hasNext()) {
            TagNode tag;
            Node node = nodeIterator.next();
            if (!TagNode.class.isAssignableFrom(node.getClass()) || !(tag = (TagNode)node).getName().equals("elif") && !tag.getName().equals("else")) continue;
            return tag;
        }
        return null;
    }

    protected boolean evaluateIfElseTagNode(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (tagNode.getName().equals("else")) {
            return true;
        }
        return ObjectTruthValue.evaluate(interpreter.resolveELExpression(tagNode.getHelpers(), tagNode.getLineNumber()));
    }

    @Override
    public String getEndTagName() {
        return ENDTAGNAME;
    }

    @Override
    public String getName() {
        return TAGNAME;
    }
}

