/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.core.transaction.AsyncTransaction;
import io.atomix.core.transaction.CommitStatus;
import io.atomix.core.transaction.Isolation;
import io.atomix.core.transaction.ParticipantInfo;
import io.atomix.core.transaction.Transaction;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionParticipant;
import io.atomix.core.transaction.TransactionService;
import io.atomix.core.transaction.TransactionType;
import io.atomix.core.transaction.TransactionalMapBuilder;
import io.atomix.core.transaction.TransactionalMapConfig;
import io.atomix.core.transaction.TransactionalSetBuilder;
import io.atomix.core.transaction.TransactionalSetConfig;
import io.atomix.core.transaction.impl.BlockingTransaction;
import io.atomix.core.transaction.impl.DefaultTransactionalMapBuilder;
import io.atomix.core.transaction.impl.DefaultTransactionalSetBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class DefaultTransaction
implements AsyncTransaction {
    private volatile TransactionId transactionId;
    private final TransactionService transactionService;
    private final PrimitiveManagementService managementService;
    private final Isolation isolation;
    private final Set<TransactionParticipant<?>> participants = Sets.newCopyOnWriteArraySet();

    public DefaultTransaction(TransactionService transactionService, PrimitiveManagementService managementService, Isolation isolation) {
        this.transactionService = (TransactionService)Preconditions.checkNotNull((Object)transactionService);
        this.managementService = (PrimitiveManagementService)Preconditions.checkNotNull((Object)managementService);
        this.isolation = (Isolation)((Object)Preconditions.checkNotNull((Object)((Object)isolation)));
    }

    public String name() {
        return null;
    }

    public PrimitiveType type() {
        return TransactionType.instance();
    }

    public PrimitiveProtocol protocol() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionId transactionId() {
        return this.transactionId;
    }

    @Override
    public Isolation isolation() {
        return this.isolation;
    }

    @Override
    public boolean isOpen() {
        return this.transactionId != null;
    }

    @Override
    public CompletableFuture<Void> begin() {
        return this.transactionService.begin().thenApply(transactionId -> {
            this.transactionId = transactionId;
            return null;
        });
    }

    void addParticipants(TransactionParticipant<?> ... participants) {
        this.addParticipants(Arrays.asList(participants));
    }

    void addParticipants(Collection<TransactionParticipant<?>> participants) {
        this.participants.addAll(participants);
    }

    @Override
    public CompletableFuture<CommitStatus> commit() {
        Set participants = this.participants.stream().filter(p -> !p.log().records().isEmpty()).collect(Collectors.toSet());
        Set<ParticipantInfo> participantInfo = participants.stream().map(participant -> new ParticipantInfo(participant.name(), participant.type().name(), participant.protocol().type().name(), participant.protocol().group())).collect(Collectors.toSet());
        CompletionStage status = ((CompletableFuture)this.transactionService.preparing(this.transactionId, participantInfo).thenCompose(v -> this.prepare(participants))).thenCompose(result -> result != false ? ((CompletableFuture)this.transactionService.committing(this.transactionId).thenCompose(v -> this.commit(participants))).thenApply(v -> CommitStatus.SUCCESS) : ((CompletableFuture)this.transactionService.aborting(this.transactionId).thenCompose(v -> this.rollback(participants))).thenApply(v -> CommitStatus.FAILURE));
        return ((CompletableFuture)status).thenCompose(v -> this.transactionService.complete(this.transactionId).thenApply(u -> v));
    }

    private CompletableFuture<Boolean> prepare(Set<TransactionParticipant<?>> participants) {
        return Futures.allOf(participants.stream().map(TransactionParticipant::prepare).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    private CompletableFuture<Void> commit(Set<TransactionParticipant<?>> participants) {
        return CompletableFuture.allOf((CompletableFuture[])participants.stream().map(TransactionParticipant::commit).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> rollback(Set<TransactionParticipant<?>> participants) {
        return CompletableFuture.allOf((CompletableFuture[])participants.stream().map(TransactionParticipant::rollback).toArray(CompletableFuture[]::new));
    }

    @Override
    public CompletableFuture<Void> abort() {
        TransactionId transactionId = this.transactionId;
        if (transactionId == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.transactionService.complete(transactionId).whenComplete((completeResult, completeError) -> Futures.allOf(this.participants.stream().map(TransactionParticipant::close).collect(Collectors.toList())).whenComplete((closeResult, closeError) -> {
            if (completeError != null) {
                future.completeExceptionally((Throwable)completeError);
            } else if (closeError != null) {
                future.completeExceptionally((Throwable)closeError);
            } else {
                future.complete(null);
            }
        }));
        return future;
    }

    @Override
    public <K, V> TransactionalMapBuilder<K, V> mapBuilder(String name) {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"transaction not open");
        return new DefaultTransactionalMapBuilder(name, new TransactionalMapConfig(), this.managementService, this);
    }

    @Override
    public <E> TransactionalSetBuilder<E> setBuilder(String name) {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"transaction not open");
        return new DefaultTransactionalSetBuilder(name, new TransactionalSetConfig(), this.managementService, this);
    }

    public CompletableFuture<Void> close() {
        return this.abort();
    }

    @Override
    public Transaction sync(Duration operationTimeout) {
        return new BlockingTransaction(this, operationTimeout.toMillis());
    }
}

