/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import io.atomix.core.semaphore.AsyncAtomicSemaphore;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicSemaphoreResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicSemaphoreResource.class);
    private final AsyncAtomicSemaphore semaphore;

    public AtomicSemaphoreResource(AsyncAtomicSemaphore semaphore) {
        this.semaphore = semaphore;
    }

    @POST
    @Path(value="/acquire")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void acquire(Integer permits, @Suspended AsyncResponse response) {
        this.semaphore.acquire(permits != null ? permits : 1).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result.value()).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/release")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void release(Integer permits, @Suspended AsyncResponse response) {
        this.semaphore.release(permits != null ? permits : 1).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/increase")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void increase(Integer permits, @Suspended AsyncResponse response) {
        this.semaphore.increasePermits(permits != null ? permits : 1).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/reduce")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void reduce(Integer permits, @Suspended AsyncResponse response) {
        this.semaphore.reducePermits(permits != null ? permits : 1).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @GET
    @Path(value="/permits")
    @Produces(value={"application/json"})
    public void availablePermits(@Suspended AsyncResponse response) {
        this.semaphore.availablePermits().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }
}

